/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesResponse;

public class DescribePortfolioSharesIterable
implements SdkIterable<DescribePortfolioSharesResponse> {
    private final ServiceCatalogClient client;
    private final DescribePortfolioSharesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribePortfolioSharesIterable(ServiceCatalogClient client, DescribePortfolioSharesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribePortfolioSharesResponseFetcher();
    }

    public Iterator<DescribePortfolioSharesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribePortfolioSharesResponseFetcher
    implements SyncPageFetcher<DescribePortfolioSharesResponse> {
        private DescribePortfolioSharesResponseFetcher() {
        }

        public boolean hasNextPage(DescribePortfolioSharesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public DescribePortfolioSharesResponse nextPage(DescribePortfolioSharesResponse previousPage) {
            if (previousPage == null) {
                return DescribePortfolioSharesIterable.this.client.describePortfolioShares(DescribePortfolioSharesIterable.this.firstRequest);
            }
            return DescribePortfolioSharesIterable.this.client.describePortfolioShares((DescribePortfolioSharesRequest)((Object)DescribePortfolioSharesIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

