/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.schemas.SchemasAsyncClient;
import software.amazon.awssdk.services.schemas.internal.UserAgentUtils;
import software.amazon.awssdk.services.schemas.model.DiscovererSummary;
import software.amazon.awssdk.services.schemas.model.ListDiscoverersRequest;
import software.amazon.awssdk.services.schemas.model.ListDiscoverersResponse;

public class ListDiscoverersPublisher
implements SdkPublisher<ListDiscoverersResponse> {
    private final SchemasAsyncClient client;
    private final ListDiscoverersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDiscoverersPublisher(SchemasAsyncClient client, ListDiscoverersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDiscoverersPublisher(SchemasAsyncClient client, ListDiscoverersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDiscoverersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDiscoverersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DiscovererSummary> discoverers() {
        Function<ListDiscoverersResponse, Iterator> getIterator = response -> {
            if (response != null && response.discoverers() != null) {
                return response.discoverers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDiscoverersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDiscoverersResponseFetcher
    implements AsyncPageFetcher<ListDiscoverersResponse> {
        private ListDiscoverersResponseFetcher() {
        }

        public boolean hasNextPage(ListDiscoverersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDiscoverersResponse> nextPage(ListDiscoverersResponse previousPage) {
            if (previousPage == null) {
                return ListDiscoverersPublisher.this.client.listDiscoverers(ListDiscoverersPublisher.this.firstRequest);
            }
            return ListDiscoverersPublisher.this.client.listDiscoverers((ListDiscoverersRequest)((Object)ListDiscoverersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

