/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.scheduler.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.scheduler.SchedulerAsyncClient;
import software.amazon.awssdk.services.scheduler.model.ListSchedulesRequest;
import software.amazon.awssdk.services.scheduler.model.ListSchedulesResponse;
import software.amazon.awssdk.services.scheduler.model.ScheduleSummary;

public class ListSchedulesPublisher
implements SdkPublisher<ListSchedulesResponse> {
    private final SchedulerAsyncClient client;
    private final ListSchedulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSchedulesPublisher(SchedulerAsyncClient client, ListSchedulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSchedulesPublisher(SchedulerAsyncClient client, ListSchedulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSchedulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSchedulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScheduleSummary> schedules() {
        Function<ListSchedulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.schedules() != null) {
                return response.schedules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSchedulesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSchedulesResponseFetcher
    implements AsyncPageFetcher<ListSchedulesResponse> {
        private ListSchedulesResponseFetcher() {
        }

        public boolean hasNextPage(ListSchedulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSchedulesResponse> nextPage(ListSchedulesResponse previousPage) {
            if (previousPage == null) {
                return ListSchedulesPublisher.this.client.listSchedules(ListSchedulesPublisher.this.firstRequest);
            }
            return ListSchedulesPublisher.this.client.listSchedules((ListSchedulesRequest)((Object)ListSchedulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

