/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.scheduler;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.scheduler.DefaultSchedulerAsyncClient;
import software.amazon.awssdk.services.scheduler.DefaultSchedulerBaseClientBuilder;
import software.amazon.awssdk.services.scheduler.SchedulerAsyncClient;
import software.amazon.awssdk.services.scheduler.SchedulerAsyncClientBuilder;
import software.amazon.awssdk.services.scheduler.SchedulerServiceClientConfiguration;
import software.amazon.awssdk.services.scheduler.endpoints.SchedulerEndpointProvider;

@SdkInternalApi
final class DefaultSchedulerAsyncClientBuilder
extends DefaultSchedulerBaseClientBuilder<SchedulerAsyncClientBuilder, SchedulerAsyncClient>
implements SchedulerAsyncClientBuilder {
    DefaultSchedulerAsyncClientBuilder() {
    }

    @Override
    public DefaultSchedulerAsyncClientBuilder endpointProvider(SchedulerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SchedulerAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSchedulerAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        SchedulerServiceClientConfiguration serviceClientConfiguration = SchedulerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultSchedulerAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

