/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input structure for Reverse Geocoding operation type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReverseGeocodingConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ReverseGeocodingConfig.Builder, ReverseGeocodingConfig> {
    private static final SdkField<String> X_ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("XAttributeName").getter(getter(ReverseGeocodingConfig::xAttributeName))
            .setter(setter(Builder::xAttributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XAttributeName").build()).build();

    private static final SdkField<String> Y_ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("YAttributeName").getter(getter(ReverseGeocodingConfig::yAttributeName))
            .setter(setter(Builder::yAttributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("YAttributeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(X_ATTRIBUTE_NAME_FIELD,
            Y_ATTRIBUTE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String xAttributeName;

    private final String yAttributeName;

    private ReverseGeocodingConfig(BuilderImpl builder) {
        this.xAttributeName = builder.xAttributeName;
        this.yAttributeName = builder.yAttributeName;
    }

    /**
     * <p>
     * The field name for the data that describes x-axis coordinate, eg. longitude of a point.
     * </p>
     * 
     * @return The field name for the data that describes x-axis coordinate, eg. longitude of a point.
     */
    public final String xAttributeName() {
        return xAttributeName;
    }

    /**
     * <p>
     * The field name for the data that describes y-axis coordinate, eg. latitude of a point.
     * </p>
     * 
     * @return The field name for the data that describes y-axis coordinate, eg. latitude of a point.
     */
    public final String yAttributeName() {
        return yAttributeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(xAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(yAttributeName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReverseGeocodingConfig)) {
            return false;
        }
        ReverseGeocodingConfig other = (ReverseGeocodingConfig) obj;
        return Objects.equals(xAttributeName(), other.xAttributeName())
                && Objects.equals(yAttributeName(), other.yAttributeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReverseGeocodingConfig").add("XAttributeName", xAttributeName())
                .add("YAttributeName", yAttributeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "XAttributeName":
            return Optional.ofNullable(clazz.cast(xAttributeName()));
        case "YAttributeName":
            return Optional.ofNullable(clazz.cast(yAttributeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReverseGeocodingConfig, T> g) {
        return obj -> g.apply((ReverseGeocodingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReverseGeocodingConfig> {
        /**
         * <p>
         * The field name for the data that describes x-axis coordinate, eg. longitude of a point.
         * </p>
         * 
         * @param xAttributeName
         *        The field name for the data that describes x-axis coordinate, eg. longitude of a point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xAttributeName(String xAttributeName);

        /**
         * <p>
         * The field name for the data that describes y-axis coordinate, eg. latitude of a point.
         * </p>
         * 
         * @param yAttributeName
         *        The field name for the data that describes y-axis coordinate, eg. latitude of a point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder yAttributeName(String yAttributeName);
    }

    static final class BuilderImpl implements Builder {
        private String xAttributeName;

        private String yAttributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(ReverseGeocodingConfig model) {
            xAttributeName(model.xAttributeName);
            yAttributeName(model.yAttributeName);
        }

        public final String getXAttributeName() {
            return xAttributeName;
        }

        public final void setXAttributeName(String xAttributeName) {
            this.xAttributeName = xAttributeName;
        }

        @Override
        public final Builder xAttributeName(String xAttributeName) {
            this.xAttributeName = xAttributeName;
            return this;
        }

        public final String getYAttributeName() {
            return yAttributeName;
        }

        public final void setYAttributeName(String yAttributeName) {
            this.yAttributeName = yAttributeName;
        }

        @Override
        public final Builder yAttributeName(String yAttributeName) {
            this.yAttributeName = yAttributeName;
            return this;
        }

        @Override
        public ReverseGeocodingConfig build() {
            return new ReverseGeocodingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
