/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is a RasterDataCollectionQueryInput containing AreaOfInterest, Time Range filter and Property filters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RasterDataCollectionQueryWithBandFilterInput implements SdkPojo, Serializable,
        ToCopyableBuilder<RasterDataCollectionQueryWithBandFilterInput.Builder, RasterDataCollectionQueryWithBandFilterInput> {
    private static final SdkField<AreaOfInterest> AREA_OF_INTEREST_FIELD = SdkField
            .<AreaOfInterest> builder(MarshallingType.SDK_POJO).memberName("AreaOfInterest")
            .getter(getter(RasterDataCollectionQueryWithBandFilterInput::areaOfInterest)).setter(setter(Builder::areaOfInterest))
            .constructor(AreaOfInterest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AreaOfInterest").build()).build();

    private static final SdkField<List<String>> BAND_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BandFilter")
            .getter(getter(RasterDataCollectionQueryWithBandFilterInput::bandFilter))
            .setter(setter(Builder::bandFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BandFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<PropertyFilters> PROPERTY_FILTERS_FIELD = SdkField
            .<PropertyFilters> builder(MarshallingType.SDK_POJO).memberName("PropertyFilters")
            .getter(getter(RasterDataCollectionQueryWithBandFilterInput::propertyFilters))
            .setter(setter(Builder::propertyFilters)).constructor(PropertyFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyFilters").build()).build();

    private static final SdkField<TimeRangeFilterInput> TIME_RANGE_FILTER_FIELD = SdkField
            .<TimeRangeFilterInput> builder(MarshallingType.SDK_POJO).memberName("TimeRangeFilter")
            .getter(getter(RasterDataCollectionQueryWithBandFilterInput::timeRangeFilter))
            .setter(setter(Builder::timeRangeFilter)).constructor(TimeRangeFilterInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRangeFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AREA_OF_INTEREST_FIELD,
            BAND_FILTER_FIELD, PROPERTY_FILTERS_FIELD, TIME_RANGE_FILTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final AreaOfInterest areaOfInterest;

    private final List<String> bandFilter;

    private final PropertyFilters propertyFilters;

    private final TimeRangeFilterInput timeRangeFilter;

    private RasterDataCollectionQueryWithBandFilterInput(BuilderImpl builder) {
        this.areaOfInterest = builder.areaOfInterest;
        this.bandFilter = builder.bandFilter;
        this.propertyFilters = builder.propertyFilters;
        this.timeRangeFilter = builder.timeRangeFilter;
    }

    /**
     * <p>
     * The Area of interest to be used in the search query.
     * </p>
     * 
     * @return The Area of interest to be used in the search query.
     */
    public final AreaOfInterest areaOfInterest() {
        return areaOfInterest;
    }

    /**
     * For responses, this returns true if the service returned a value for the BandFilter property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBandFilter() {
        return bandFilter != null && !(bandFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Bands to be displayed in the result for each item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBandFilter} method.
     * </p>
     * 
     * @return The list of Bands to be displayed in the result for each item.
     */
    public final List<String> bandFilter() {
        return bandFilter;
    }

    /**
     * <p>
     * The Property Filters used in the search query.
     * </p>
     * 
     * @return The Property Filters used in the search query.
     */
    public final PropertyFilters propertyFilters() {
        return propertyFilters;
    }

    /**
     * <p>
     * The TimeRange Filter used in the search query.
     * </p>
     * 
     * @return The TimeRange Filter used in the search query.
     */
    public final TimeRangeFilterInput timeRangeFilter() {
        return timeRangeFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(areaOfInterest());
        hashCode = 31 * hashCode + Objects.hashCode(hasBandFilter() ? bandFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(propertyFilters());
        hashCode = 31 * hashCode + Objects.hashCode(timeRangeFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RasterDataCollectionQueryWithBandFilterInput)) {
            return false;
        }
        RasterDataCollectionQueryWithBandFilterInput other = (RasterDataCollectionQueryWithBandFilterInput) obj;
        return Objects.equals(areaOfInterest(), other.areaOfInterest()) && hasBandFilter() == other.hasBandFilter()
                && Objects.equals(bandFilter(), other.bandFilter()) && Objects.equals(propertyFilters(), other.propertyFilters())
                && Objects.equals(timeRangeFilter(), other.timeRangeFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RasterDataCollectionQueryWithBandFilterInput").add("AreaOfInterest", areaOfInterest())
                .add("BandFilter", hasBandFilter() ? bandFilter() : null).add("PropertyFilters", propertyFilters())
                .add("TimeRangeFilter", timeRangeFilter() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AreaOfInterest":
            return Optional.ofNullable(clazz.cast(areaOfInterest()));
        case "BandFilter":
            return Optional.ofNullable(clazz.cast(bandFilter()));
        case "PropertyFilters":
            return Optional.ofNullable(clazz.cast(propertyFilters()));
        case "TimeRangeFilter":
            return Optional.ofNullable(clazz.cast(timeRangeFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RasterDataCollectionQueryWithBandFilterInput, T> g) {
        return obj -> g.apply((RasterDataCollectionQueryWithBandFilterInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RasterDataCollectionQueryWithBandFilterInput> {
        /**
         * <p>
         * The Area of interest to be used in the search query.
         * </p>
         * 
         * @param areaOfInterest
         *        The Area of interest to be used in the search query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder areaOfInterest(AreaOfInterest areaOfInterest);

        /**
         * <p>
         * The Area of interest to be used in the search query.
         * </p>
         * This is a convenience method that creates an instance of the {@link AreaOfInterest.Builder} avoiding the need
         * to create one manually via {@link AreaOfInterest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AreaOfInterest.Builder#build()} is called immediately and its
         * result is passed to {@link #areaOfInterest(AreaOfInterest)}.
         * 
         * @param areaOfInterest
         *        a consumer that will call methods on {@link AreaOfInterest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #areaOfInterest(AreaOfInterest)
         */
        default Builder areaOfInterest(Consumer<AreaOfInterest.Builder> areaOfInterest) {
            return areaOfInterest(AreaOfInterest.builder().applyMutation(areaOfInterest).build());
        }

        /**
         * <p>
         * The list of Bands to be displayed in the result for each item.
         * </p>
         * 
         * @param bandFilter
         *        The list of Bands to be displayed in the result for each item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bandFilter(Collection<String> bandFilter);

        /**
         * <p>
         * The list of Bands to be displayed in the result for each item.
         * </p>
         * 
         * @param bandFilter
         *        The list of Bands to be displayed in the result for each item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bandFilter(String... bandFilter);

        /**
         * <p>
         * The Property Filters used in the search query.
         * </p>
         * 
         * @param propertyFilters
         *        The Property Filters used in the search query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyFilters(PropertyFilters propertyFilters);

        /**
         * <p>
         * The Property Filters used in the search query.
         * </p>
         * This is a convenience method that creates an instance of the {@link PropertyFilters.Builder} avoiding the
         * need to create one manually via {@link PropertyFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PropertyFilters.Builder#build()} is called immediately and its
         * result is passed to {@link #propertyFilters(PropertyFilters)}.
         * 
         * @param propertyFilters
         *        a consumer that will call methods on {@link PropertyFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propertyFilters(PropertyFilters)
         */
        default Builder propertyFilters(Consumer<PropertyFilters.Builder> propertyFilters) {
            return propertyFilters(PropertyFilters.builder().applyMutation(propertyFilters).build());
        }

        /**
         * <p>
         * The TimeRange Filter used in the search query.
         * </p>
         * 
         * @param timeRangeFilter
         *        The TimeRange Filter used in the search query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRangeFilter(TimeRangeFilterInput timeRangeFilter);

        /**
         * <p>
         * The TimeRange Filter used in the search query.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeRangeFilterInput.Builder} avoiding
         * the need to create one manually via {@link TimeRangeFilterInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeRangeFilterInput.Builder#build()} is called immediately and
         * its result is passed to {@link #timeRangeFilter(TimeRangeFilterInput)}.
         * 
         * @param timeRangeFilter
         *        a consumer that will call methods on {@link TimeRangeFilterInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeRangeFilter(TimeRangeFilterInput)
         */
        default Builder timeRangeFilter(Consumer<TimeRangeFilterInput.Builder> timeRangeFilter) {
            return timeRangeFilter(TimeRangeFilterInput.builder().applyMutation(timeRangeFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AreaOfInterest areaOfInterest;

        private List<String> bandFilter = DefaultSdkAutoConstructList.getInstance();

        private PropertyFilters propertyFilters;

        private TimeRangeFilterInput timeRangeFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(RasterDataCollectionQueryWithBandFilterInput model) {
            areaOfInterest(model.areaOfInterest);
            bandFilter(model.bandFilter);
            propertyFilters(model.propertyFilters);
            timeRangeFilter(model.timeRangeFilter);
        }

        public final AreaOfInterest.Builder getAreaOfInterest() {
            return areaOfInterest != null ? areaOfInterest.toBuilder() : null;
        }

        public final void setAreaOfInterest(AreaOfInterest.BuilderImpl areaOfInterest) {
            this.areaOfInterest = areaOfInterest != null ? areaOfInterest.build() : null;
        }

        @Override
        public final Builder areaOfInterest(AreaOfInterest areaOfInterest) {
            this.areaOfInterest = areaOfInterest;
            return this;
        }

        public final Collection<String> getBandFilter() {
            if (bandFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return bandFilter;
        }

        public final void setBandFilter(Collection<String> bandFilter) {
            this.bandFilter = StringListInputCopier.copy(bandFilter);
        }

        @Override
        public final Builder bandFilter(Collection<String> bandFilter) {
            this.bandFilter = StringListInputCopier.copy(bandFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bandFilter(String... bandFilter) {
            bandFilter(Arrays.asList(bandFilter));
            return this;
        }

        public final PropertyFilters.Builder getPropertyFilters() {
            return propertyFilters != null ? propertyFilters.toBuilder() : null;
        }

        public final void setPropertyFilters(PropertyFilters.BuilderImpl propertyFilters) {
            this.propertyFilters = propertyFilters != null ? propertyFilters.build() : null;
        }

        @Override
        public final Builder propertyFilters(PropertyFilters propertyFilters) {
            this.propertyFilters = propertyFilters;
            return this;
        }

        public final TimeRangeFilterInput.Builder getTimeRangeFilter() {
            return timeRangeFilter != null ? timeRangeFilter.toBuilder() : null;
        }

        public final void setTimeRangeFilter(TimeRangeFilterInput.BuilderImpl timeRangeFilter) {
            this.timeRangeFilter = timeRangeFilter != null ? timeRangeFilter.build() : null;
        }

        @Override
        public final Builder timeRangeFilter(TimeRangeFilterInput timeRangeFilter) {
            this.timeRangeFilter = timeRangeFilter;
            return this;
        }

        @Override
        public RasterDataCollectionQueryWithBandFilterInput build() {
            return new RasterDataCollectionQueryWithBandFilterInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
