/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardExportJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardExportJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobSummary;

public class ListModelCardExportJobsIterable
implements SdkIterable<ListModelCardExportJobsResponse> {
    private final SageMakerClient client;
    private final ListModelCardExportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListModelCardExportJobsIterable(SageMakerClient client, ListModelCardExportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListModelCardExportJobsResponseFetcher();
    }

    public Iterator<ListModelCardExportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ModelCardExportJobSummary> modelCardExportJobSummaries() {
        Function<ListModelCardExportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.modelCardExportJobSummaries() != null) {
                return response.modelCardExportJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListModelCardExportJobsResponseFetcher
    implements SyncPageFetcher<ListModelCardExportJobsResponse> {
        private ListModelCardExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelCardExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListModelCardExportJobsResponse nextPage(ListModelCardExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListModelCardExportJobsIterable.this.client.listModelCardExportJobs(ListModelCardExportJobsIterable.this.firstRequest);
            }
            return ListModelCardExportJobsIterable.this.client.listModelCardExportJobs((ListModelCardExportJobsRequest)((Object)ListModelCardExportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

