/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OfflineStoreStatusValue {
    ACTIVE("Active"),
    BLOCKED("Blocked"),
    DISABLED("Disabled"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OfflineStoreStatusValue> VALUE_MAP;
    private final String value;

    private OfflineStoreStatusValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OfflineStoreStatusValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OfflineStoreStatusValue> knownValues() {
        EnumSet<OfflineStoreStatusValue> knownValues = EnumSet.allOf(OfflineStoreStatusValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OfflineStoreStatusValue.class, OfflineStoreStatusValue::toString);
    }
}

