/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ExperimentSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.ExperimentSummary;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExperimentsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListExperimentsResponse> {
    private static final SdkField<List<ExperimentSummary>> EXPERIMENT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExperimentSummaries").getter(ListExperimentsResponse.getter(ListExperimentsResponse::experimentSummaries)).setter(ListExperimentsResponse.setter(Builder::experimentSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExperimentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListExperimentsResponse.getter(ListExperimentsResponse::nextToken)).setter(ListExperimentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ExperimentSummary> experimentSummaries;
    private final String nextToken;

    private ListExperimentsResponse(BuilderImpl builder) {
        super(builder);
        this.experimentSummaries = builder.experimentSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasExperimentSummaries() {
        return this.experimentSummaries != null && !(this.experimentSummaries instanceof SdkAutoConstructList);
    }

    public final List<ExperimentSummary> experimentSummaries() {
        return this.experimentSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExperimentSummaries() ? this.experimentSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExperimentsResponse)) {
            return false;
        }
        ListExperimentsResponse other = (ListExperimentsResponse)((Object)obj);
        return this.hasExperimentSummaries() == other.hasExperimentSummaries() && Objects.equals(this.experimentSummaries(), other.experimentSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListExperimentsResponse").add("ExperimentSummaries", this.hasExperimentSummaries() ? this.experimentSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExperimentSummaries": {
                return Optional.ofNullable(clazz.cast(this.experimentSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListExperimentsResponse, T> g) {
        return obj -> g.apply((ListExperimentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<ExperimentSummary> experimentSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExperimentsResponse model) {
            super(model);
            this.experimentSummaries(model.experimentSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ExperimentSummary.Builder> getExperimentSummaries() {
            List<ExperimentSummary.Builder> result = ExperimentSummariesCopier.copyToBuilder(this.experimentSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExperimentSummaries(Collection<ExperimentSummary.BuilderImpl> experimentSummaries) {
            this.experimentSummaries = ExperimentSummariesCopier.copyFromBuilder(experimentSummaries);
        }

        @Override
        public final Builder experimentSummaries(Collection<ExperimentSummary> experimentSummaries) {
            this.experimentSummaries = ExperimentSummariesCopier.copy(experimentSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder experimentSummaries(ExperimentSummary ... experimentSummaries) {
            this.experimentSummaries(Arrays.asList(experimentSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder experimentSummaries(Consumer<ExperimentSummary.Builder> ... experimentSummaries) {
            this.experimentSummaries(Stream.of(experimentSummaries).map(c -> (ExperimentSummary)((ExperimentSummary.Builder)ExperimentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListExperimentsResponse build() {
            return new ListExperimentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExperimentsResponse> {
        public Builder experimentSummaries(Collection<ExperimentSummary> var1);

        public Builder experimentSummaries(ExperimentSummary ... var1);

        public Builder experimentSummaries(Consumer<ExperimentSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

