/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AdditionalCodeRepositoryNamesOrUrlsCopier;
import software.amazon.awssdk.services.sagemaker.model.DirectInternetAccess;
import software.amazon.awssdk.services.sagemaker.model.InstanceMetadataServiceConfiguration;
import software.amazon.awssdk.services.sagemaker.model.InstanceType;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorTypesCopier;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus;
import software.amazon.awssdk.services.sagemaker.model.RootAccess;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.SecurityGroupIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNotebookInstanceResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeNotebookInstanceResponse> {
    private static final SdkField<String> NOTEBOOK_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookInstanceArn").getter(DescribeNotebookInstanceResponse.getter(DescribeNotebookInstanceResponse::notebookInstanceArn)).setter(DescribeNotebookInstanceResponse.setter(Builder::notebookInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceArn").build()}).build();
    private static final SdkField<String> NOTEBOOK_INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookInstanceName").getter(DescribeNotebookInstanceResponse.getter(DescribeNotebookInstanceResponse::notebookInstanceName)).setter(DescribeNotebookInstanceResponse.setter(Builder::notebookInstanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceName").build()}).build();
    private static final SdkField<String> NOTEBOOK_INSTANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookInstanceStatus").getter(DescribeNotebookInstanceResponse.getter(DescribeNotebookInstanceResponse::notebookInstanceStatusAsString)).setter(DescribeNotebookInstanceResponse.setter(Builder::notebookInstanceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceStatus").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeNotebookInstanceResponse.getter(DescribeNotebookInstanceResponse::failureReason)).setter(DescribeNotebookInstanceResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(DescribeNotebookInstanceResponse.getter(DescribeNotebookInstanceResponse::url)).setter(DescribeNotebookInstanceResponse.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(DescribeNotebookInstanceResponse.getter(DescribeNotebookInstanceResponse::instanceTypeAsString)).setter(DescribeNotebookInstanceResponse.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(DescribeNotebookInstanceResponse.getter(DescribeNotebookInstanceResponse::subnetId)).setter(DescribeNotebookInstanceResponse.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(DescribeNotebookInstanceResponse.getter(DescribeNotebookInstanceResponse::securityGroups)).setter(DescribeNotebookInstanceResponse.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeNotebookInstanceResponse.getter(DescribeNotebookInstanceResponse::roleArn)).setter(DescribeNotebookInstanceResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(DescribeNotebookInstanceResponse.getter(DescribeNotebookInstanceResponse::kmsKeyId)).setter(DescribeNotebookInstanceResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(DescribeNotebookInstanceResponse.getter(DescribeNotebookInstanceResponse::networkInterfaceId)).setter(DescribeNotebookInstanceResponse.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeNotebookInstanceResponse.getter(DescribeNotebookInstanceResponse::lastModifiedTime)).setter(DescribeNotebookInstanceResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeNotebookInstanceResponse.getter(DescribeNotebookInstanceResponse::creationTime)).setter(DescribeNotebookInstanceResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookInstanceLifecycleConfigName").getter(DescribeNotebookInstanceResponse.getter(DescribeNotebookInstanceResponse::notebookInstanceLifecycleConfigName)).setter(DescribeNotebookInstanceResponse.setter(Builder::notebookInstanceLifecycleConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceLifecycleConfigName").build()}).build();
    private static final SdkField<String> DIRECT_INTERNET_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectInternetAccess").getter(DescribeNotebookInstanceResponse.getter(DescribeNotebookInstanceResponse::directInternetAccessAsString)).setter(DescribeNotebookInstanceResponse.setter(Builder::directInternetAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectInternetAccess").build()}).build();
    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VolumeSizeInGB").getter(DescribeNotebookInstanceResponse.getter(DescribeNotebookInstanceResponse::volumeSizeInGB)).setter(DescribeNotebookInstanceResponse.setter(Builder::volumeSizeInGB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInGB").build()}).build();
    private static final SdkField<List<String>> ACCELERATOR_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AcceleratorTypes").getter(DescribeNotebookInstanceResponse.getter(DescribeNotebookInstanceResponse::acceleratorTypesAsStrings)).setter(DescribeNotebookInstanceResponse.setter(Builder::acceleratorTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEFAULT_CODE_REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultCodeRepository").getter(DescribeNotebookInstanceResponse.getter(DescribeNotebookInstanceResponse::defaultCodeRepository)).setter(DescribeNotebookInstanceResponse.setter(Builder::defaultCodeRepository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCodeRepository").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_CODE_REPOSITORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalCodeRepositories").getter(DescribeNotebookInstanceResponse.getter(DescribeNotebookInstanceResponse::additionalCodeRepositories)).setter(DescribeNotebookInstanceResponse.setter(Builder::additionalCodeRepositories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalCodeRepositories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROOT_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RootAccess").getter(DescribeNotebookInstanceResponse.getter(DescribeNotebookInstanceResponse::rootAccessAsString)).setter(DescribeNotebookInstanceResponse.setter(Builder::rootAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootAccess").build()}).build();
    private static final SdkField<String> PLATFORM_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformIdentifier").getter(DescribeNotebookInstanceResponse.getter(DescribeNotebookInstanceResponse::platformIdentifier)).setter(DescribeNotebookInstanceResponse.setter(Builder::platformIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformIdentifier").build()}).build();
    private static final SdkField<InstanceMetadataServiceConfiguration> INSTANCE_METADATA_SERVICE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceMetadataServiceConfiguration").getter(DescribeNotebookInstanceResponse.getter(DescribeNotebookInstanceResponse::instanceMetadataServiceConfiguration)).setter(DescribeNotebookInstanceResponse.setter(Builder::instanceMetadataServiceConfiguration)).constructor(InstanceMetadataServiceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMetadataServiceConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_INSTANCE_ARN_FIELD, NOTEBOOK_INSTANCE_NAME_FIELD, NOTEBOOK_INSTANCE_STATUS_FIELD, FAILURE_REASON_FIELD, URL_FIELD, INSTANCE_TYPE_FIELD, SUBNET_ID_FIELD, SECURITY_GROUPS_FIELD, ROLE_ARN_FIELD, KMS_KEY_ID_FIELD, NETWORK_INTERFACE_ID_FIELD, LAST_MODIFIED_TIME_FIELD, CREATION_TIME_FIELD, NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD, DIRECT_INTERNET_ACCESS_FIELD, VOLUME_SIZE_IN_GB_FIELD, ACCELERATOR_TYPES_FIELD, DEFAULT_CODE_REPOSITORY_FIELD, ADDITIONAL_CODE_REPOSITORIES_FIELD, ROOT_ACCESS_FIELD, PLATFORM_IDENTIFIER_FIELD, INSTANCE_METADATA_SERVICE_CONFIGURATION_FIELD));
    private final String notebookInstanceArn;
    private final String notebookInstanceName;
    private final String notebookInstanceStatus;
    private final String failureReason;
    private final String url;
    private final String instanceType;
    private final String subnetId;
    private final List<String> securityGroups;
    private final String roleArn;
    private final String kmsKeyId;
    private final String networkInterfaceId;
    private final Instant lastModifiedTime;
    private final Instant creationTime;
    private final String notebookInstanceLifecycleConfigName;
    private final String directInternetAccess;
    private final Integer volumeSizeInGB;
    private final List<String> acceleratorTypes;
    private final String defaultCodeRepository;
    private final List<String> additionalCodeRepositories;
    private final String rootAccess;
    private final String platformIdentifier;
    private final InstanceMetadataServiceConfiguration instanceMetadataServiceConfiguration;

    private DescribeNotebookInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.notebookInstanceArn = builder.notebookInstanceArn;
        this.notebookInstanceName = builder.notebookInstanceName;
        this.notebookInstanceStatus = builder.notebookInstanceStatus;
        this.failureReason = builder.failureReason;
        this.url = builder.url;
        this.instanceType = builder.instanceType;
        this.subnetId = builder.subnetId;
        this.securityGroups = builder.securityGroups;
        this.roleArn = builder.roleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.creationTime = builder.creationTime;
        this.notebookInstanceLifecycleConfigName = builder.notebookInstanceLifecycleConfigName;
        this.directInternetAccess = builder.directInternetAccess;
        this.volumeSizeInGB = builder.volumeSizeInGB;
        this.acceleratorTypes = builder.acceleratorTypes;
        this.defaultCodeRepository = builder.defaultCodeRepository;
        this.additionalCodeRepositories = builder.additionalCodeRepositories;
        this.rootAccess = builder.rootAccess;
        this.platformIdentifier = builder.platformIdentifier;
        this.instanceMetadataServiceConfiguration = builder.instanceMetadataServiceConfiguration;
    }

    public final String notebookInstanceArn() {
        return this.notebookInstanceArn;
    }

    public final String notebookInstanceName() {
        return this.notebookInstanceName;
    }

    public final NotebookInstanceStatus notebookInstanceStatus() {
        return NotebookInstanceStatus.fromValue(this.notebookInstanceStatus);
    }

    public final String notebookInstanceStatusAsString() {
        return this.notebookInstanceStatus;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String url() {
        return this.url;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String notebookInstanceLifecycleConfigName() {
        return this.notebookInstanceLifecycleConfigName;
    }

    public final DirectInternetAccess directInternetAccess() {
        return DirectInternetAccess.fromValue(this.directInternetAccess);
    }

    public final String directInternetAccessAsString() {
        return this.directInternetAccess;
    }

    public final Integer volumeSizeInGB() {
        return this.volumeSizeInGB;
    }

    public final List<NotebookInstanceAcceleratorType> acceleratorTypes() {
        return NotebookInstanceAcceleratorTypesCopier.copyStringToEnum(this.acceleratorTypes);
    }

    public final boolean hasAcceleratorTypes() {
        return this.acceleratorTypes != null && !(this.acceleratorTypes instanceof SdkAutoConstructList);
    }

    public final List<String> acceleratorTypesAsStrings() {
        return this.acceleratorTypes;
    }

    public final String defaultCodeRepository() {
        return this.defaultCodeRepository;
    }

    public final boolean hasAdditionalCodeRepositories() {
        return this.additionalCodeRepositories != null && !(this.additionalCodeRepositories instanceof SdkAutoConstructList);
    }

    public final List<String> additionalCodeRepositories() {
        return this.additionalCodeRepositories;
    }

    public final RootAccess rootAccess() {
        return RootAccess.fromValue(this.rootAccess);
    }

    public final String rootAccessAsString() {
        return this.rootAccess;
    }

    public final String platformIdentifier() {
        return this.platformIdentifier;
    }

    public final InstanceMetadataServiceConfiguration instanceMetadataServiceConfiguration() {
        return this.instanceMetadataServiceConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceLifecycleConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.directInternetAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAcceleratorTypes() ? this.acceleratorTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCodeRepository());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalCodeRepositories() ? this.additionalCodeRepositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rootAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMetadataServiceConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotebookInstanceResponse)) {
            return false;
        }
        DescribeNotebookInstanceResponse other = (DescribeNotebookInstanceResponse)((Object)obj);
        return Objects.equals(this.notebookInstanceArn(), other.notebookInstanceArn()) && Objects.equals(this.notebookInstanceName(), other.notebookInstanceName()) && Objects.equals(this.notebookInstanceStatusAsString(), other.notebookInstanceStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.subnetId(), other.subnetId()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.notebookInstanceLifecycleConfigName(), other.notebookInstanceLifecycleConfigName()) && Objects.equals(this.directInternetAccessAsString(), other.directInternetAccessAsString()) && Objects.equals(this.volumeSizeInGB(), other.volumeSizeInGB()) && this.hasAcceleratorTypes() == other.hasAcceleratorTypes() && Objects.equals(this.acceleratorTypesAsStrings(), other.acceleratorTypesAsStrings()) && Objects.equals(this.defaultCodeRepository(), other.defaultCodeRepository()) && this.hasAdditionalCodeRepositories() == other.hasAdditionalCodeRepositories() && Objects.equals(this.additionalCodeRepositories(), other.additionalCodeRepositories()) && Objects.equals(this.rootAccessAsString(), other.rootAccessAsString()) && Objects.equals(this.platformIdentifier(), other.platformIdentifier()) && Objects.equals(this.instanceMetadataServiceConfiguration(), other.instanceMetadataServiceConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeNotebookInstanceResponse").add("NotebookInstanceArn", (Object)this.notebookInstanceArn()).add("NotebookInstanceName", (Object)this.notebookInstanceName()).add("NotebookInstanceStatus", (Object)this.notebookInstanceStatusAsString()).add("FailureReason", (Object)this.failureReason()).add("Url", (Object)this.url()).add("InstanceType", (Object)this.instanceTypeAsString()).add("SubnetId", (Object)this.subnetId()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("RoleArn", (Object)this.roleArn()).add("KmsKeyId", (Object)this.kmsKeyId()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("CreationTime", (Object)this.creationTime()).add("NotebookInstanceLifecycleConfigName", (Object)this.notebookInstanceLifecycleConfigName()).add("DirectInternetAccess", (Object)this.directInternetAccessAsString()).add("VolumeSizeInGB", (Object)this.volumeSizeInGB()).add("AcceleratorTypes", this.hasAcceleratorTypes() ? this.acceleratorTypesAsStrings() : null).add("DefaultCodeRepository", (Object)this.defaultCodeRepository()).add("AdditionalCodeRepositories", this.hasAdditionalCodeRepositories() ? this.additionalCodeRepositories() : null).add("RootAccess", (Object)this.rootAccessAsString()).add("PlatformIdentifier", (Object)this.platformIdentifier()).add("InstanceMetadataServiceConfiguration", (Object)this.instanceMetadataServiceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotebookInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceArn()));
            }
            case "NotebookInstanceName": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceName()));
            }
            case "NotebookInstanceStatus": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceStatusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "NotebookInstanceLifecycleConfigName": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceLifecycleConfigName()));
            }
            case "DirectInternetAccess": {
                return Optional.ofNullable(clazz.cast(this.directInternetAccessAsString()));
            }
            case "VolumeSizeInGB": {
                return Optional.ofNullable(clazz.cast(this.volumeSizeInGB()));
            }
            case "AcceleratorTypes": {
                return Optional.ofNullable(clazz.cast(this.acceleratorTypesAsStrings()));
            }
            case "DefaultCodeRepository": {
                return Optional.ofNullable(clazz.cast(this.defaultCodeRepository()));
            }
            case "AdditionalCodeRepositories": {
                return Optional.ofNullable(clazz.cast(this.additionalCodeRepositories()));
            }
            case "RootAccess": {
                return Optional.ofNullable(clazz.cast(this.rootAccessAsString()));
            }
            case "PlatformIdentifier": {
                return Optional.ofNullable(clazz.cast(this.platformIdentifier()));
            }
            case "InstanceMetadataServiceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.instanceMetadataServiceConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNotebookInstanceResponse, T> g) {
        return obj -> g.apply((DescribeNotebookInstanceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String notebookInstanceArn;
        private String notebookInstanceName;
        private String notebookInstanceStatus;
        private String failureReason;
        private String url;
        private String instanceType;
        private String subnetId;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;
        private String kmsKeyId;
        private String networkInterfaceId;
        private Instant lastModifiedTime;
        private Instant creationTime;
        private String notebookInstanceLifecycleConfigName;
        private String directInternetAccess;
        private Integer volumeSizeInGB;
        private List<String> acceleratorTypes = DefaultSdkAutoConstructList.getInstance();
        private String defaultCodeRepository;
        private List<String> additionalCodeRepositories = DefaultSdkAutoConstructList.getInstance();
        private String rootAccess;
        private String platformIdentifier;
        private InstanceMetadataServiceConfiguration instanceMetadataServiceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotebookInstanceResponse model) {
            super(model);
            this.notebookInstanceArn(model.notebookInstanceArn);
            this.notebookInstanceName(model.notebookInstanceName);
            this.notebookInstanceStatus(model.notebookInstanceStatus);
            this.failureReason(model.failureReason);
            this.url(model.url);
            this.instanceType(model.instanceType);
            this.subnetId(model.subnetId);
            this.securityGroups(model.securityGroups);
            this.roleArn(model.roleArn);
            this.kmsKeyId(model.kmsKeyId);
            this.networkInterfaceId(model.networkInterfaceId);
            this.lastModifiedTime(model.lastModifiedTime);
            this.creationTime(model.creationTime);
            this.notebookInstanceLifecycleConfigName(model.notebookInstanceLifecycleConfigName);
            this.directInternetAccess(model.directInternetAccess);
            this.volumeSizeInGB(model.volumeSizeInGB);
            this.acceleratorTypesWithStrings(model.acceleratorTypes);
            this.defaultCodeRepository(model.defaultCodeRepository);
            this.additionalCodeRepositories(model.additionalCodeRepositories);
            this.rootAccess(model.rootAccess);
            this.platformIdentifier(model.platformIdentifier);
            this.instanceMetadataServiceConfiguration(model.instanceMetadataServiceConfiguration);
        }

        public final String getNotebookInstanceArn() {
            return this.notebookInstanceArn;
        }

        public final void setNotebookInstanceArn(String notebookInstanceArn) {
            this.notebookInstanceArn = notebookInstanceArn;
        }

        @Override
        public final Builder notebookInstanceArn(String notebookInstanceArn) {
            this.notebookInstanceArn = notebookInstanceArn;
            return this;
        }

        public final String getNotebookInstanceName() {
            return this.notebookInstanceName;
        }

        public final void setNotebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
        }

        @Override
        public final Builder notebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
            return this;
        }

        public final String getNotebookInstanceStatus() {
            return this.notebookInstanceStatus;
        }

        public final void setNotebookInstanceStatus(String notebookInstanceStatus) {
            this.notebookInstanceStatus = notebookInstanceStatus;
        }

        @Override
        public final Builder notebookInstanceStatus(String notebookInstanceStatus) {
            this.notebookInstanceStatus = notebookInstanceStatus;
            return this;
        }

        @Override
        public final Builder notebookInstanceStatus(NotebookInstanceStatus notebookInstanceStatus) {
            this.notebookInstanceStatus(notebookInstanceStatus == null ? null : notebookInstanceStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupIdsCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupIdsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getNotebookInstanceLifecycleConfigName() {
            return this.notebookInstanceLifecycleConfigName;
        }

        public final void setNotebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
        }

        @Override
        public final Builder notebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
            return this;
        }

        public final String getDirectInternetAccess() {
            return this.directInternetAccess;
        }

        public final void setDirectInternetAccess(String directInternetAccess) {
            this.directInternetAccess = directInternetAccess;
        }

        @Override
        public final Builder directInternetAccess(String directInternetAccess) {
            this.directInternetAccess = directInternetAccess;
            return this;
        }

        @Override
        public final Builder directInternetAccess(DirectInternetAccess directInternetAccess) {
            this.directInternetAccess(directInternetAccess == null ? null : directInternetAccess.toString());
            return this;
        }

        public final Integer getVolumeSizeInGB() {
            return this.volumeSizeInGB;
        }

        public final void setVolumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
        }

        @Override
        public final Builder volumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
            return this;
        }

        public final Collection<String> getAcceleratorTypes() {
            if (this.acceleratorTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.acceleratorTypes;
        }

        public final void setAcceleratorTypes(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copy(acceleratorTypes);
        }

        @Override
        public final Builder acceleratorTypesWithStrings(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copy(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypesWithStrings(String ... acceleratorTypes) {
            this.acceleratorTypesWithStrings(Arrays.asList(acceleratorTypes));
            return this;
        }

        @Override
        public final Builder acceleratorTypes(Collection<NotebookInstanceAcceleratorType> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copyEnumToString(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypes(NotebookInstanceAcceleratorType ... acceleratorTypes) {
            this.acceleratorTypes(Arrays.asList(acceleratorTypes));
            return this;
        }

        public final String getDefaultCodeRepository() {
            return this.defaultCodeRepository;
        }

        public final void setDefaultCodeRepository(String defaultCodeRepository) {
            this.defaultCodeRepository = defaultCodeRepository;
        }

        @Override
        public final Builder defaultCodeRepository(String defaultCodeRepository) {
            this.defaultCodeRepository = defaultCodeRepository;
            return this;
        }

        public final Collection<String> getAdditionalCodeRepositories() {
            if (this.additionalCodeRepositories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalCodeRepositories;
        }

        public final void setAdditionalCodeRepositories(Collection<String> additionalCodeRepositories) {
            this.additionalCodeRepositories = AdditionalCodeRepositoryNamesOrUrlsCopier.copy(additionalCodeRepositories);
        }

        @Override
        public final Builder additionalCodeRepositories(Collection<String> additionalCodeRepositories) {
            this.additionalCodeRepositories = AdditionalCodeRepositoryNamesOrUrlsCopier.copy(additionalCodeRepositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalCodeRepositories(String ... additionalCodeRepositories) {
            this.additionalCodeRepositories(Arrays.asList(additionalCodeRepositories));
            return this;
        }

        public final String getRootAccess() {
            return this.rootAccess;
        }

        public final void setRootAccess(String rootAccess) {
            this.rootAccess = rootAccess;
        }

        @Override
        public final Builder rootAccess(String rootAccess) {
            this.rootAccess = rootAccess;
            return this;
        }

        @Override
        public final Builder rootAccess(RootAccess rootAccess) {
            this.rootAccess(rootAccess == null ? null : rootAccess.toString());
            return this;
        }

        public final String getPlatformIdentifier() {
            return this.platformIdentifier;
        }

        public final void setPlatformIdentifier(String platformIdentifier) {
            this.platformIdentifier = platformIdentifier;
        }

        @Override
        public final Builder platformIdentifier(String platformIdentifier) {
            this.platformIdentifier = platformIdentifier;
            return this;
        }

        public final InstanceMetadataServiceConfiguration.Builder getInstanceMetadataServiceConfiguration() {
            return this.instanceMetadataServiceConfiguration != null ? this.instanceMetadataServiceConfiguration.toBuilder() : null;
        }

        public final void setInstanceMetadataServiceConfiguration(InstanceMetadataServiceConfiguration.BuilderImpl instanceMetadataServiceConfiguration) {
            this.instanceMetadataServiceConfiguration = instanceMetadataServiceConfiguration != null ? instanceMetadataServiceConfiguration.build() : null;
        }

        @Override
        public final Builder instanceMetadataServiceConfiguration(InstanceMetadataServiceConfiguration instanceMetadataServiceConfiguration) {
            this.instanceMetadataServiceConfiguration = instanceMetadataServiceConfiguration;
            return this;
        }

        @Override
        public DescribeNotebookInstanceResponse build() {
            return new DescribeNotebookInstanceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNotebookInstanceResponse> {
        public Builder notebookInstanceArn(String var1);

        public Builder notebookInstanceName(String var1);

        public Builder notebookInstanceStatus(String var1);

        public Builder notebookInstanceStatus(NotebookInstanceStatus var1);

        public Builder failureReason(String var1);

        public Builder url(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder subnetId(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder roleArn(String var1);

        public Builder kmsKeyId(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder notebookInstanceLifecycleConfigName(String var1);

        public Builder directInternetAccess(String var1);

        public Builder directInternetAccess(DirectInternetAccess var1);

        public Builder volumeSizeInGB(Integer var1);

        public Builder acceleratorTypesWithStrings(Collection<String> var1);

        public Builder acceleratorTypesWithStrings(String ... var1);

        public Builder acceleratorTypes(Collection<NotebookInstanceAcceleratorType> var1);

        public Builder acceleratorTypes(NotebookInstanceAcceleratorType ... var1);

        public Builder defaultCodeRepository(String var1);

        public Builder additionalCodeRepositories(Collection<String> var1);

        public Builder additionalCodeRepositories(String ... var1);

        public Builder rootAccess(String var1);

        public Builder rootAccess(RootAccess var1);

        public Builder platformIdentifier(String var1);

        public Builder instanceMetadataServiceConfiguration(InstanceMetadataServiceConfiguration var1);

        default public Builder instanceMetadataServiceConfiguration(Consumer<InstanceMetadataServiceConfiguration.Builder> instanceMetadataServiceConfiguration) {
            return this.instanceMetadataServiceConfiguration((InstanceMetadataServiceConfiguration)((InstanceMetadataServiceConfiguration.Builder)InstanceMetadataServiceConfiguration.builder().applyMutation(instanceMetadataServiceConfiguration)).build());
        }
    }
}

