/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ClarifyShapBaselineConfig;
import software.amazon.awssdk.services.sagemaker.model.ClarifyTextConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClarifyShapConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClarifyShapConfig> {
    private static final SdkField<ClarifyShapBaselineConfig> SHAP_BASELINE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ShapBaselineConfig").getter(ClarifyShapConfig.getter(ClarifyShapConfig::shapBaselineConfig)).setter(ClarifyShapConfig.setter(Builder::shapBaselineConfig)).constructor(ClarifyShapBaselineConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShapBaselineConfig").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_SAMPLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfSamples").getter(ClarifyShapConfig.getter(ClarifyShapConfig::numberOfSamples)).setter(ClarifyShapConfig.setter(Builder::numberOfSamples)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfSamples").build()}).build();
    private static final SdkField<Boolean> USE_LOGIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseLogit").getter(ClarifyShapConfig.getter(ClarifyShapConfig::useLogit)).setter(ClarifyShapConfig.setter(Builder::useLogit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseLogit").build()}).build();
    private static final SdkField<Integer> SEED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Seed").getter(ClarifyShapConfig.getter(ClarifyShapConfig::seed)).setter(ClarifyShapConfig.setter(Builder::seed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Seed").build()}).build();
    private static final SdkField<ClarifyTextConfig> TEXT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TextConfig").getter(ClarifyShapConfig.getter(ClarifyShapConfig::textConfig)).setter(ClarifyShapConfig.setter(Builder::textConfig)).constructor(ClarifyTextConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHAP_BASELINE_CONFIG_FIELD, NUMBER_OF_SAMPLES_FIELD, USE_LOGIT_FIELD, SEED_FIELD, TEXT_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final ClarifyShapBaselineConfig shapBaselineConfig;
    private final Integer numberOfSamples;
    private final Boolean useLogit;
    private final Integer seed;
    private final ClarifyTextConfig textConfig;

    private ClarifyShapConfig(BuilderImpl builder) {
        this.shapBaselineConfig = builder.shapBaselineConfig;
        this.numberOfSamples = builder.numberOfSamples;
        this.useLogit = builder.useLogit;
        this.seed = builder.seed;
        this.textConfig = builder.textConfig;
    }

    public final ClarifyShapBaselineConfig shapBaselineConfig() {
        return this.shapBaselineConfig;
    }

    public final Integer numberOfSamples() {
        return this.numberOfSamples;
    }

    public final Boolean useLogit() {
        return this.useLogit;
    }

    public final Integer seed() {
        return this.seed;
    }

    public final ClarifyTextConfig textConfig() {
        return this.textConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shapBaselineConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfSamples());
        hashCode = 31 * hashCode + Objects.hashCode(this.useLogit());
        hashCode = 31 * hashCode + Objects.hashCode(this.seed());
        hashCode = 31 * hashCode + Objects.hashCode(this.textConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClarifyShapConfig)) {
            return false;
        }
        ClarifyShapConfig other = (ClarifyShapConfig)obj;
        return Objects.equals(this.shapBaselineConfig(), other.shapBaselineConfig()) && Objects.equals(this.numberOfSamples(), other.numberOfSamples()) && Objects.equals(this.useLogit(), other.useLogit()) && Objects.equals(this.seed(), other.seed()) && Objects.equals(this.textConfig(), other.textConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ClarifyShapConfig").add("ShapBaselineConfig", (Object)this.shapBaselineConfig()).add("NumberOfSamples", (Object)this.numberOfSamples()).add("UseLogit", (Object)this.useLogit()).add("Seed", (Object)this.seed()).add("TextConfig", (Object)this.textConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShapBaselineConfig": {
                return Optional.ofNullable(clazz.cast(this.shapBaselineConfig()));
            }
            case "NumberOfSamples": {
                return Optional.ofNullable(clazz.cast(this.numberOfSamples()));
            }
            case "UseLogit": {
                return Optional.ofNullable(clazz.cast(this.useLogit()));
            }
            case "Seed": {
                return Optional.ofNullable(clazz.cast(this.seed()));
            }
            case "TextConfig": {
                return Optional.ofNullable(clazz.cast(this.textConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClarifyShapConfig, T> g) {
        return obj -> g.apply((ClarifyShapConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ClarifyShapBaselineConfig shapBaselineConfig;
        private Integer numberOfSamples;
        private Boolean useLogit;
        private Integer seed;
        private ClarifyTextConfig textConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ClarifyShapConfig model) {
            this.shapBaselineConfig(model.shapBaselineConfig);
            this.numberOfSamples(model.numberOfSamples);
            this.useLogit(model.useLogit);
            this.seed(model.seed);
            this.textConfig(model.textConfig);
        }

        public final ClarifyShapBaselineConfig.Builder getShapBaselineConfig() {
            return this.shapBaselineConfig != null ? this.shapBaselineConfig.toBuilder() : null;
        }

        public final void setShapBaselineConfig(ClarifyShapBaselineConfig.BuilderImpl shapBaselineConfig) {
            this.shapBaselineConfig = shapBaselineConfig != null ? shapBaselineConfig.build() : null;
        }

        @Override
        public final Builder shapBaselineConfig(ClarifyShapBaselineConfig shapBaselineConfig) {
            this.shapBaselineConfig = shapBaselineConfig;
            return this;
        }

        public final Integer getNumberOfSamples() {
            return this.numberOfSamples;
        }

        public final void setNumberOfSamples(Integer numberOfSamples) {
            this.numberOfSamples = numberOfSamples;
        }

        @Override
        public final Builder numberOfSamples(Integer numberOfSamples) {
            this.numberOfSamples = numberOfSamples;
            return this;
        }

        public final Boolean getUseLogit() {
            return this.useLogit;
        }

        public final void setUseLogit(Boolean useLogit) {
            this.useLogit = useLogit;
        }

        @Override
        public final Builder useLogit(Boolean useLogit) {
            this.useLogit = useLogit;
            return this;
        }

        public final Integer getSeed() {
            return this.seed;
        }

        public final void setSeed(Integer seed) {
            this.seed = seed;
        }

        @Override
        public final Builder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public final ClarifyTextConfig.Builder getTextConfig() {
            return this.textConfig != null ? this.textConfig.toBuilder() : null;
        }

        public final void setTextConfig(ClarifyTextConfig.BuilderImpl textConfig) {
            this.textConfig = textConfig != null ? textConfig.build() : null;
        }

        @Override
        public final Builder textConfig(ClarifyTextConfig textConfig) {
            this.textConfig = textConfig;
            return this;
        }

        public ClarifyShapConfig build() {
            return new ClarifyShapConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClarifyShapConfig> {
        public Builder shapBaselineConfig(ClarifyShapBaselineConfig var1);

        default public Builder shapBaselineConfig(Consumer<ClarifyShapBaselineConfig.Builder> shapBaselineConfig) {
            return this.shapBaselineConfig((ClarifyShapBaselineConfig)((ClarifyShapBaselineConfig.Builder)ClarifyShapBaselineConfig.builder().applyMutation(shapBaselineConfig)).build());
        }

        public Builder numberOfSamples(Integer var1);

        public Builder useLogit(Boolean var1);

        public Builder seed(Integer var1);

        public Builder textConfig(ClarifyTextConfig var1);

        default public Builder textConfig(Consumer<ClarifyTextConfig.Builder> textConfig) {
            return this.textConfig((ClarifyTextConfig)((ClarifyTextConfig.Builder)ClarifyTextConfig.builder().applyMutation(textConfig)).build());
        }
    }
}

