/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of space settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpaceSettings implements SdkPojo, Serializable, ToCopyableBuilder<SpaceSettings.Builder, SpaceSettings> {
    private static final SdkField<JupyterServerAppSettings> JUPYTER_SERVER_APP_SETTINGS_FIELD = SdkField
            .<JupyterServerAppSettings> builder(MarshallingType.SDK_POJO).memberName("JupyterServerAppSettings")
            .getter(getter(SpaceSettings::jupyterServerAppSettings)).setter(setter(Builder::jupyterServerAppSettings))
            .constructor(JupyterServerAppSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JupyterServerAppSettings").build())
            .build();

    private static final SdkField<KernelGatewayAppSettings> KERNEL_GATEWAY_APP_SETTINGS_FIELD = SdkField
            .<KernelGatewayAppSettings> builder(MarshallingType.SDK_POJO).memberName("KernelGatewayAppSettings")
            .getter(getter(SpaceSettings::kernelGatewayAppSettings)).setter(setter(Builder::kernelGatewayAppSettings))
            .constructor(KernelGatewayAppSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelGatewayAppSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            JUPYTER_SERVER_APP_SETTINGS_FIELD, KERNEL_GATEWAY_APP_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final JupyterServerAppSettings jupyterServerAppSettings;

    private final KernelGatewayAppSettings kernelGatewayAppSettings;

    private SpaceSettings(BuilderImpl builder) {
        this.jupyterServerAppSettings = builder.jupyterServerAppSettings;
        this.kernelGatewayAppSettings = builder.kernelGatewayAppSettings;
    }

    /**
     * Returns the value of the JupyterServerAppSettings property for this object.
     * 
     * @return The value of the JupyterServerAppSettings property for this object.
     */
    public final JupyterServerAppSettings jupyterServerAppSettings() {
        return jupyterServerAppSettings;
    }

    /**
     * Returns the value of the KernelGatewayAppSettings property for this object.
     * 
     * @return The value of the KernelGatewayAppSettings property for this object.
     */
    public final KernelGatewayAppSettings kernelGatewayAppSettings() {
        return kernelGatewayAppSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jupyterServerAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(kernelGatewayAppSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpaceSettings)) {
            return false;
        }
        SpaceSettings other = (SpaceSettings) obj;
        return Objects.equals(jupyterServerAppSettings(), other.jupyterServerAppSettings())
                && Objects.equals(kernelGatewayAppSettings(), other.kernelGatewayAppSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpaceSettings").add("JupyterServerAppSettings", jupyterServerAppSettings())
                .add("KernelGatewayAppSettings", kernelGatewayAppSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JupyterServerAppSettings":
            return Optional.ofNullable(clazz.cast(jupyterServerAppSettings()));
        case "KernelGatewayAppSettings":
            return Optional.ofNullable(clazz.cast(kernelGatewayAppSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpaceSettings, T> g) {
        return obj -> g.apply((SpaceSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpaceSettings> {
        /**
         * Sets the value of the JupyterServerAppSettings property for this object.
         *
         * @param jupyterServerAppSettings
         *        The new value for the JupyterServerAppSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jupyterServerAppSettings(JupyterServerAppSettings jupyterServerAppSettings);

        /**
         * Sets the value of the JupyterServerAppSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link JupyterServerAppSettings.Builder}
         * avoiding the need to create one manually via {@link JupyterServerAppSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JupyterServerAppSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #jupyterServerAppSettings(JupyterServerAppSettings)}.
         * 
         * @param jupyterServerAppSettings
         *        a consumer that will call methods on {@link JupyterServerAppSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jupyterServerAppSettings(JupyterServerAppSettings)
         */
        default Builder jupyterServerAppSettings(Consumer<JupyterServerAppSettings.Builder> jupyterServerAppSettings) {
            return jupyterServerAppSettings(JupyterServerAppSettings.builder().applyMutation(jupyterServerAppSettings).build());
        }

        /**
         * Sets the value of the KernelGatewayAppSettings property for this object.
         *
         * @param kernelGatewayAppSettings
         *        The new value for the KernelGatewayAppSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelGatewayAppSettings(KernelGatewayAppSettings kernelGatewayAppSettings);

        /**
         * Sets the value of the KernelGatewayAppSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link KernelGatewayAppSettings.Builder}
         * avoiding the need to create one manually via {@link KernelGatewayAppSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KernelGatewayAppSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #kernelGatewayAppSettings(KernelGatewayAppSettings)}.
         * 
         * @param kernelGatewayAppSettings
         *        a consumer that will call methods on {@link KernelGatewayAppSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kernelGatewayAppSettings(KernelGatewayAppSettings)
         */
        default Builder kernelGatewayAppSettings(Consumer<KernelGatewayAppSettings.Builder> kernelGatewayAppSettings) {
            return kernelGatewayAppSettings(KernelGatewayAppSettings.builder().applyMutation(kernelGatewayAppSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private JupyterServerAppSettings jupyterServerAppSettings;

        private KernelGatewayAppSettings kernelGatewayAppSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(SpaceSettings model) {
            jupyterServerAppSettings(model.jupyterServerAppSettings);
            kernelGatewayAppSettings(model.kernelGatewayAppSettings);
        }

        public final JupyterServerAppSettings.Builder getJupyterServerAppSettings() {
            return jupyterServerAppSettings != null ? jupyterServerAppSettings.toBuilder() : null;
        }

        public final void setJupyterServerAppSettings(JupyterServerAppSettings.BuilderImpl jupyterServerAppSettings) {
            this.jupyterServerAppSettings = jupyterServerAppSettings != null ? jupyterServerAppSettings.build() : null;
        }

        @Override
        public final Builder jupyterServerAppSettings(JupyterServerAppSettings jupyterServerAppSettings) {
            this.jupyterServerAppSettings = jupyterServerAppSettings;
            return this;
        }

        public final KernelGatewayAppSettings.Builder getKernelGatewayAppSettings() {
            return kernelGatewayAppSettings != null ? kernelGatewayAppSettings.toBuilder() : null;
        }

        public final void setKernelGatewayAppSettings(KernelGatewayAppSettings.BuilderImpl kernelGatewayAppSettings) {
            this.kernelGatewayAppSettings = kernelGatewayAppSettings != null ? kernelGatewayAppSettings.build() : null;
        }

        @Override
        public final Builder kernelGatewayAppSettings(KernelGatewayAppSettings kernelGatewayAppSettings) {
            this.kernelGatewayAppSettings = kernelGatewayAppSettings;
            return this;
        }

        @Override
        public SpaceSettings build() {
            return new SpaceSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
