/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A pipeline execution summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineExecutionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<PipelineExecutionSummary.Builder, PipelineExecutionSummary> {
    private static final SdkField<String> PIPELINE_EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineExecutionArn").getter(getter(PipelineExecutionSummary::pipelineExecutionArn))
            .setter(setter(Builder::pipelineExecutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionArn").build())
            .build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(PipelineExecutionSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<String> PIPELINE_EXECUTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineExecutionStatus").getter(getter(PipelineExecutionSummary::pipelineExecutionStatusAsString))
            .setter(setter(Builder::pipelineExecutionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionStatus").build())
            .build();

    private static final SdkField<String> PIPELINE_EXECUTION_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PipelineExecutionDescription")
            .getter(getter(PipelineExecutionSummary::pipelineExecutionDescription))
            .setter(setter(Builder::pipelineExecutionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionDescription")
                    .build()).build();

    private static final SdkField<String> PIPELINE_EXECUTION_DISPLAY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PipelineExecutionDisplayName")
            .getter(getter(PipelineExecutionSummary::pipelineExecutionDisplayName))
            .setter(setter(Builder::pipelineExecutionDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionDisplayName")
                    .build()).build();

    private static final SdkField<String> PIPELINE_EXECUTION_FAILURE_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PipelineExecutionFailureReason")
            .getter(getter(PipelineExecutionSummary::pipelineExecutionFailureReason))
            .setter(setter(Builder::pipelineExecutionFailureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionFailureReason")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_EXECUTION_ARN_FIELD,
            START_TIME_FIELD, PIPELINE_EXECUTION_STATUS_FIELD, PIPELINE_EXECUTION_DESCRIPTION_FIELD,
            PIPELINE_EXECUTION_DISPLAY_NAME_FIELD, PIPELINE_EXECUTION_FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pipelineExecutionArn;

    private final Instant startTime;

    private final String pipelineExecutionStatus;

    private final String pipelineExecutionDescription;

    private final String pipelineExecutionDisplayName;

    private final String pipelineExecutionFailureReason;

    private PipelineExecutionSummary(BuilderImpl builder) {
        this.pipelineExecutionArn = builder.pipelineExecutionArn;
        this.startTime = builder.startTime;
        this.pipelineExecutionStatus = builder.pipelineExecutionStatus;
        this.pipelineExecutionDescription = builder.pipelineExecutionDescription;
        this.pipelineExecutionDisplayName = builder.pipelineExecutionDisplayName;
        this.pipelineExecutionFailureReason = builder.pipelineExecutionFailureReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pipeline execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pipeline execution.
     */
    public final String pipelineExecutionArn() {
        return pipelineExecutionArn;
    }

    /**
     * <p>
     * The start time of the pipeline execution.
     * </p>
     * 
     * @return The start time of the pipeline execution.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The status of the pipeline execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pipelineExecutionStatus} will return {@link PipelineExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #pipelineExecutionStatusAsString}.
     * </p>
     * 
     * @return The status of the pipeline execution.
     * @see PipelineExecutionStatus
     */
    public final PipelineExecutionStatus pipelineExecutionStatus() {
        return PipelineExecutionStatus.fromValue(pipelineExecutionStatus);
    }

    /**
     * <p>
     * The status of the pipeline execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pipelineExecutionStatus} will return {@link PipelineExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #pipelineExecutionStatusAsString}.
     * </p>
     * 
     * @return The status of the pipeline execution.
     * @see PipelineExecutionStatus
     */
    public final String pipelineExecutionStatusAsString() {
        return pipelineExecutionStatus;
    }

    /**
     * <p>
     * The description of the pipeline execution.
     * </p>
     * 
     * @return The description of the pipeline execution.
     */
    public final String pipelineExecutionDescription() {
        return pipelineExecutionDescription;
    }

    /**
     * <p>
     * The display name of the pipeline execution.
     * </p>
     * 
     * @return The display name of the pipeline execution.
     */
    public final String pipelineExecutionDisplayName() {
        return pipelineExecutionDisplayName;
    }

    /**
     * <p>
     * A message generated by SageMaker Pipelines describing why the pipeline execution failed.
     * </p>
     * 
     * @return A message generated by SageMaker Pipelines describing why the pipeline execution failed.
     */
    public final String pipelineExecutionFailureReason() {
        return pipelineExecutionFailureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionFailureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineExecutionSummary)) {
            return false;
        }
        PipelineExecutionSummary other = (PipelineExecutionSummary) obj;
        return Objects.equals(pipelineExecutionArn(), other.pipelineExecutionArn())
                && Objects.equals(startTime(), other.startTime())
                && Objects.equals(pipelineExecutionStatusAsString(), other.pipelineExecutionStatusAsString())
                && Objects.equals(pipelineExecutionDescription(), other.pipelineExecutionDescription())
                && Objects.equals(pipelineExecutionDisplayName(), other.pipelineExecutionDisplayName())
                && Objects.equals(pipelineExecutionFailureReason(), other.pipelineExecutionFailureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineExecutionSummary").add("PipelineExecutionArn", pipelineExecutionArn())
                .add("StartTime", startTime()).add("PipelineExecutionStatus", pipelineExecutionStatusAsString())
                .add("PipelineExecutionDescription", pipelineExecutionDescription())
                .add("PipelineExecutionDisplayName", pipelineExecutionDisplayName())
                .add("PipelineExecutionFailureReason", pipelineExecutionFailureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineExecutionArn":
            return Optional.ofNullable(clazz.cast(pipelineExecutionArn()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "PipelineExecutionStatus":
            return Optional.ofNullable(clazz.cast(pipelineExecutionStatusAsString()));
        case "PipelineExecutionDescription":
            return Optional.ofNullable(clazz.cast(pipelineExecutionDescription()));
        case "PipelineExecutionDisplayName":
            return Optional.ofNullable(clazz.cast(pipelineExecutionDisplayName()));
        case "PipelineExecutionFailureReason":
            return Optional.ofNullable(clazz.cast(pipelineExecutionFailureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineExecutionSummary, T> g) {
        return obj -> g.apply((PipelineExecutionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineExecutionSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pipeline execution.
         * </p>
         * 
         * @param pipelineExecutionArn
         *        The Amazon Resource Name (ARN) of the pipeline execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionArn(String pipelineExecutionArn);

        /**
         * <p>
         * The start time of the pipeline execution.
         * </p>
         * 
         * @param startTime
         *        The start time of the pipeline execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The status of the pipeline execution.
         * </p>
         * 
         * @param pipelineExecutionStatus
         *        The status of the pipeline execution.
         * @see PipelineExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineExecutionStatus
         */
        Builder pipelineExecutionStatus(String pipelineExecutionStatus);

        /**
         * <p>
         * The status of the pipeline execution.
         * </p>
         * 
         * @param pipelineExecutionStatus
         *        The status of the pipeline execution.
         * @see PipelineExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineExecutionStatus
         */
        Builder pipelineExecutionStatus(PipelineExecutionStatus pipelineExecutionStatus);

        /**
         * <p>
         * The description of the pipeline execution.
         * </p>
         * 
         * @param pipelineExecutionDescription
         *        The description of the pipeline execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionDescription(String pipelineExecutionDescription);

        /**
         * <p>
         * The display name of the pipeline execution.
         * </p>
         * 
         * @param pipelineExecutionDisplayName
         *        The display name of the pipeline execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionDisplayName(String pipelineExecutionDisplayName);

        /**
         * <p>
         * A message generated by SageMaker Pipelines describing why the pipeline execution failed.
         * </p>
         * 
         * @param pipelineExecutionFailureReason
         *        A message generated by SageMaker Pipelines describing why the pipeline execution failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionFailureReason(String pipelineExecutionFailureReason);
    }

    static final class BuilderImpl implements Builder {
        private String pipelineExecutionArn;

        private Instant startTime;

        private String pipelineExecutionStatus;

        private String pipelineExecutionDescription;

        private String pipelineExecutionDisplayName;

        private String pipelineExecutionFailureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineExecutionSummary model) {
            pipelineExecutionArn(model.pipelineExecutionArn);
            startTime(model.startTime);
            pipelineExecutionStatus(model.pipelineExecutionStatus);
            pipelineExecutionDescription(model.pipelineExecutionDescription);
            pipelineExecutionDisplayName(model.pipelineExecutionDisplayName);
            pipelineExecutionFailureReason(model.pipelineExecutionFailureReason);
        }

        public final String getPipelineExecutionArn() {
            return pipelineExecutionArn;
        }

        public final void setPipelineExecutionArn(String pipelineExecutionArn) {
            this.pipelineExecutionArn = pipelineExecutionArn;
        }

        @Override
        public final Builder pipelineExecutionArn(String pipelineExecutionArn) {
            this.pipelineExecutionArn = pipelineExecutionArn;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getPipelineExecutionStatus() {
            return pipelineExecutionStatus;
        }

        public final void setPipelineExecutionStatus(String pipelineExecutionStatus) {
            this.pipelineExecutionStatus = pipelineExecutionStatus;
        }

        @Override
        public final Builder pipelineExecutionStatus(String pipelineExecutionStatus) {
            this.pipelineExecutionStatus = pipelineExecutionStatus;
            return this;
        }

        @Override
        public final Builder pipelineExecutionStatus(PipelineExecutionStatus pipelineExecutionStatus) {
            this.pipelineExecutionStatus(pipelineExecutionStatus == null ? null : pipelineExecutionStatus.toString());
            return this;
        }

        public final String getPipelineExecutionDescription() {
            return pipelineExecutionDescription;
        }

        public final void setPipelineExecutionDescription(String pipelineExecutionDescription) {
            this.pipelineExecutionDescription = pipelineExecutionDescription;
        }

        @Override
        public final Builder pipelineExecutionDescription(String pipelineExecutionDescription) {
            this.pipelineExecutionDescription = pipelineExecutionDescription;
            return this;
        }

        public final String getPipelineExecutionDisplayName() {
            return pipelineExecutionDisplayName;
        }

        public final void setPipelineExecutionDisplayName(String pipelineExecutionDisplayName) {
            this.pipelineExecutionDisplayName = pipelineExecutionDisplayName;
        }

        @Override
        public final Builder pipelineExecutionDisplayName(String pipelineExecutionDisplayName) {
            this.pipelineExecutionDisplayName = pipelineExecutionDisplayName;
            return this;
        }

        public final String getPipelineExecutionFailureReason() {
            return pipelineExecutionFailureReason;
        }

        public final void setPipelineExecutionFailureReason(String pipelineExecutionFailureReason) {
            this.pipelineExecutionFailureReason = pipelineExecutionFailureReason;
        }

        @Override
        public final Builder pipelineExecutionFailureReason(String pipelineExecutionFailureReason) {
            this.pipelineExecutionFailureReason = pipelineExecutionFailureReason;
            return this;
        }

        @Override
        public PipelineExecutionSummary build() {
            return new PipelineExecutionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
