/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMonitoringAlertHistoryResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListMonitoringAlertHistoryResponse.Builder, ListMonitoringAlertHistoryResponse> {
    private static final SdkField<List<MonitoringAlertHistorySummary>> MONITORING_ALERT_HISTORY_FIELD = SdkField
            .<List<MonitoringAlertHistorySummary>> builder(MarshallingType.LIST)
            .memberName("MonitoringAlertHistory")
            .getter(getter(ListMonitoringAlertHistoryResponse::monitoringAlertHistory))
            .setter(setter(Builder::monitoringAlertHistory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringAlertHistory").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MonitoringAlertHistorySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MonitoringAlertHistorySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMonitoringAlertHistoryResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MONITORING_ALERT_HISTORY_FIELD, NEXT_TOKEN_FIELD));

    private final List<MonitoringAlertHistorySummary> monitoringAlertHistory;

    private final String nextToken;

    private ListMonitoringAlertHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.monitoringAlertHistory = builder.monitoringAlertHistory;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MonitoringAlertHistory property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMonitoringAlertHistory() {
        return monitoringAlertHistory != null && !(monitoringAlertHistory instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An alert history for a model monitoring schedule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMonitoringAlertHistory} method.
     * </p>
     * 
     * @return An alert history for a model monitoring schedule.
     */
    public final List<MonitoringAlertHistorySummary> monitoringAlertHistory() {
        return monitoringAlertHistory;
    }

    /**
     * <p>
     * If the response is truncated, SageMaker returns this token. To retrieve the next set of alerts, use it in the
     * subsequent request.
     * </p>
     * 
     * @return If the response is truncated, SageMaker returns this token. To retrieve the next set of alerts, use it in
     *         the subsequent request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMonitoringAlertHistory() ? monitoringAlertHistory() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMonitoringAlertHistoryResponse)) {
            return false;
        }
        ListMonitoringAlertHistoryResponse other = (ListMonitoringAlertHistoryResponse) obj;
        return hasMonitoringAlertHistory() == other.hasMonitoringAlertHistory()
                && Objects.equals(monitoringAlertHistory(), other.monitoringAlertHistory())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMonitoringAlertHistoryResponse")
                .add("MonitoringAlertHistory", hasMonitoringAlertHistory() ? monitoringAlertHistory() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringAlertHistory":
            return Optional.ofNullable(clazz.cast(monitoringAlertHistory()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMonitoringAlertHistoryResponse, T> g) {
        return obj -> g.apply((ListMonitoringAlertHistoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMonitoringAlertHistoryResponse> {
        /**
         * <p>
         * An alert history for a model monitoring schedule.
         * </p>
         * 
         * @param monitoringAlertHistory
         *        An alert history for a model monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringAlertHistory(Collection<MonitoringAlertHistorySummary> monitoringAlertHistory);

        /**
         * <p>
         * An alert history for a model monitoring schedule.
         * </p>
         * 
         * @param monitoringAlertHistory
         *        An alert history for a model monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringAlertHistory(MonitoringAlertHistorySummary... monitoringAlertHistory);

        /**
         * <p>
         * An alert history for a model monitoring schedule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.MonitoringAlertHistorySummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.MonitoringAlertHistorySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.MonitoringAlertHistorySummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #monitoringAlertHistory(List<MonitoringAlertHistorySummary>)}.
         * 
         * @param monitoringAlertHistory
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.MonitoringAlertHistorySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringAlertHistory(java.util.Collection<MonitoringAlertHistorySummary>)
         */
        Builder monitoringAlertHistory(Consumer<MonitoringAlertHistorySummary.Builder>... monitoringAlertHistory);

        /**
         * <p>
         * If the response is truncated, SageMaker returns this token. To retrieve the next set of alerts, use it in the
         * subsequent request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, SageMaker returns this token. To retrieve the next set of alerts, use it
         *        in the subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<MonitoringAlertHistorySummary> monitoringAlertHistory = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMonitoringAlertHistoryResponse model) {
            super(model);
            monitoringAlertHistory(model.monitoringAlertHistory);
            nextToken(model.nextToken);
        }

        public final List<MonitoringAlertHistorySummary.Builder> getMonitoringAlertHistory() {
            List<MonitoringAlertHistorySummary.Builder> result = MonitoringAlertHistoryListCopier
                    .copyToBuilder(this.monitoringAlertHistory);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMonitoringAlertHistory(Collection<MonitoringAlertHistorySummary.BuilderImpl> monitoringAlertHistory) {
            this.monitoringAlertHistory = MonitoringAlertHistoryListCopier.copyFromBuilder(monitoringAlertHistory);
        }

        @Override
        public final Builder monitoringAlertHistory(Collection<MonitoringAlertHistorySummary> monitoringAlertHistory) {
            this.monitoringAlertHistory = MonitoringAlertHistoryListCopier.copy(monitoringAlertHistory);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitoringAlertHistory(MonitoringAlertHistorySummary... monitoringAlertHistory) {
            monitoringAlertHistory(Arrays.asList(monitoringAlertHistory));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitoringAlertHistory(Consumer<MonitoringAlertHistorySummary.Builder>... monitoringAlertHistory) {
            monitoringAlertHistory(Stream.of(monitoringAlertHistory)
                    .map(c -> MonitoringAlertHistorySummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMonitoringAlertHistoryResponse build() {
            return new ListMonitoringAlertHistoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
