/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListModelPackagesResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListModelPackagesResponse.Builder, ListModelPackagesResponse> {
    private static final SdkField<List<ModelPackageSummary>> MODEL_PACKAGE_SUMMARY_LIST_FIELD = SdkField
            .<List<ModelPackageSummary>> builder(MarshallingType.LIST)
            .memberName("ModelPackageSummaryList")
            .getter(getter(ListModelPackagesResponse::modelPackageSummaryList))
            .setter(setter(Builder::modelPackageSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelPackageSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelPackageSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListModelPackagesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MODEL_PACKAGE_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<ModelPackageSummary> modelPackageSummaryList;

    private final String nextToken;

    private ListModelPackagesResponse(BuilderImpl builder) {
        super(builder);
        this.modelPackageSummaryList = builder.modelPackageSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelPackageSummaryList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasModelPackageSummaryList() {
        return modelPackageSummaryList != null && !(modelPackageSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ModelPackageSummary</code> objects, each of which lists a model package.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelPackageSummaryList} method.
     * </p>
     * 
     * @return An array of <code>ModelPackageSummary</code> objects, each of which lists a model package.
     */
    public final List<ModelPackageSummary> modelPackageSummaryList() {
        return modelPackageSummaryList;
    }

    /**
     * <p>
     * If the response is truncated, SageMaker returns this token. To retrieve the next set of model packages, use it in
     * the subsequent request.
     * </p>
     * 
     * @return If the response is truncated, SageMaker returns this token. To retrieve the next set of model packages,
     *         use it in the subsequent request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasModelPackageSummaryList() ? modelPackageSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelPackagesResponse)) {
            return false;
        }
        ListModelPackagesResponse other = (ListModelPackagesResponse) obj;
        return hasModelPackageSummaryList() == other.hasModelPackageSummaryList()
                && Objects.equals(modelPackageSummaryList(), other.modelPackageSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListModelPackagesResponse")
                .add("ModelPackageSummaryList", hasModelPackageSummaryList() ? modelPackageSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelPackageSummaryList":
            return Optional.ofNullable(clazz.cast(modelPackageSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListModelPackagesResponse, T> g) {
        return obj -> g.apply((ListModelPackagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListModelPackagesResponse> {
        /**
         * <p>
         * An array of <code>ModelPackageSummary</code> objects, each of which lists a model package.
         * </p>
         * 
         * @param modelPackageSummaryList
         *        An array of <code>ModelPackageSummary</code> objects, each of which lists a model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageSummaryList(Collection<ModelPackageSummary> modelPackageSummaryList);

        /**
         * <p>
         * An array of <code>ModelPackageSummary</code> objects, each of which lists a model package.
         * </p>
         * 
         * @param modelPackageSummaryList
         *        An array of <code>ModelPackageSummary</code> objects, each of which lists a model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageSummaryList(ModelPackageSummary... modelPackageSummaryList);

        /**
         * <p>
         * An array of <code>ModelPackageSummary</code> objects, each of which lists a model package.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelPackageSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.sagemaker.model.ModelPackageSummary#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelPackageSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #modelPackageSummaryList(List<ModelPackageSummary>)}.
         * 
         * @param modelPackageSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ModelPackageSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelPackageSummaryList(java.util.Collection<ModelPackageSummary>)
         */
        Builder modelPackageSummaryList(Consumer<ModelPackageSummary.Builder>... modelPackageSummaryList);

        /**
         * <p>
         * If the response is truncated, SageMaker returns this token. To retrieve the next set of model packages, use
         * it in the subsequent request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, SageMaker returns this token. To retrieve the next set of model
         *        packages, use it in the subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<ModelPackageSummary> modelPackageSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelPackagesResponse model) {
            super(model);
            modelPackageSummaryList(model.modelPackageSummaryList);
            nextToken(model.nextToken);
        }

        public final List<ModelPackageSummary.Builder> getModelPackageSummaryList() {
            List<ModelPackageSummary.Builder> result = ModelPackageSummaryListCopier.copyToBuilder(this.modelPackageSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelPackageSummaryList(Collection<ModelPackageSummary.BuilderImpl> modelPackageSummaryList) {
            this.modelPackageSummaryList = ModelPackageSummaryListCopier.copyFromBuilder(modelPackageSummaryList);
        }

        @Override
        public final Builder modelPackageSummaryList(Collection<ModelPackageSummary> modelPackageSummaryList) {
            this.modelPackageSummaryList = ModelPackageSummaryListCopier.copy(modelPackageSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelPackageSummaryList(ModelPackageSummary... modelPackageSummaryList) {
            modelPackageSummaryList(Arrays.asList(modelPackageSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelPackageSummaryList(Consumer<ModelPackageSummary.Builder>... modelPackageSummaryList) {
            modelPackageSummaryList(Stream.of(modelPackageSummaryList)
                    .map(c -> ModelPackageSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListModelPackagesResponse build() {
            return new ListModelPackagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
