/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInferenceRecommendationsJobsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListInferenceRecommendationsJobsResponse.Builder, ListInferenceRecommendationsJobsResponse> {
    private static final SdkField<List<InferenceRecommendationsJob>> INFERENCE_RECOMMENDATIONS_JOBS_FIELD = SdkField
            .<List<InferenceRecommendationsJob>> builder(MarshallingType.LIST)
            .memberName("InferenceRecommendationsJobs")
            .getter(getter(ListInferenceRecommendationsJobsResponse::inferenceRecommendationsJobs))
            .setter(setter(Builder::inferenceRecommendationsJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceRecommendationsJobs")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InferenceRecommendationsJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(InferenceRecommendationsJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInferenceRecommendationsJobsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INFERENCE_RECOMMENDATIONS_JOBS_FIELD, NEXT_TOKEN_FIELD));

    private final List<InferenceRecommendationsJob> inferenceRecommendationsJobs;

    private final String nextToken;

    private ListInferenceRecommendationsJobsResponse(BuilderImpl builder) {
        super(builder);
        this.inferenceRecommendationsJobs = builder.inferenceRecommendationsJobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InferenceRecommendationsJobs property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInferenceRecommendationsJobs() {
        return inferenceRecommendationsJobs != null && !(inferenceRecommendationsJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The recommendations created from the Amazon SageMaker Inference Recommender job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInferenceRecommendationsJobs} method.
     * </p>
     * 
     * @return The recommendations created from the Amazon SageMaker Inference Recommender job.
     */
    public final List<InferenceRecommendationsJob> inferenceRecommendationsJobs() {
        return inferenceRecommendationsJobs;
    }

    /**
     * <p>
     * A token for getting the next set of recommendations, if there are any.
     * </p>
     * 
     * @return A token for getting the next set of recommendations, if there are any.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInferenceRecommendationsJobs() ? inferenceRecommendationsJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInferenceRecommendationsJobsResponse)) {
            return false;
        }
        ListInferenceRecommendationsJobsResponse other = (ListInferenceRecommendationsJobsResponse) obj;
        return hasInferenceRecommendationsJobs() == other.hasInferenceRecommendationsJobs()
                && Objects.equals(inferenceRecommendationsJobs(), other.inferenceRecommendationsJobs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInferenceRecommendationsJobsResponse")
                .add("InferenceRecommendationsJobs", hasInferenceRecommendationsJobs() ? inferenceRecommendationsJobs() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InferenceRecommendationsJobs":
            return Optional.ofNullable(clazz.cast(inferenceRecommendationsJobs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInferenceRecommendationsJobsResponse, T> g) {
        return obj -> g.apply((ListInferenceRecommendationsJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListInferenceRecommendationsJobsResponse> {
        /**
         * <p>
         * The recommendations created from the Amazon SageMaker Inference Recommender job.
         * </p>
         * 
         * @param inferenceRecommendationsJobs
         *        The recommendations created from the Amazon SageMaker Inference Recommender job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceRecommendationsJobs(Collection<InferenceRecommendationsJob> inferenceRecommendationsJobs);

        /**
         * <p>
         * The recommendations created from the Amazon SageMaker Inference Recommender job.
         * </p>
         * 
         * @param inferenceRecommendationsJobs
         *        The recommendations created from the Amazon SageMaker Inference Recommender job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceRecommendationsJobs(InferenceRecommendationsJob... inferenceRecommendationsJobs);

        /**
         * <p>
         * The recommendations created from the Amazon SageMaker Inference Recommender job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.InferenceRecommendationsJob.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.InferenceRecommendationsJob#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.InferenceRecommendationsJob.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #inferenceRecommendationsJobs(List<InferenceRecommendationsJob>)}.
         * 
         * @param inferenceRecommendationsJobs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.InferenceRecommendationsJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceRecommendationsJobs(java.util.Collection<InferenceRecommendationsJob>)
         */
        Builder inferenceRecommendationsJobs(Consumer<InferenceRecommendationsJob.Builder>... inferenceRecommendationsJobs);

        /**
         * <p>
         * A token for getting the next set of recommendations, if there are any.
         * </p>
         * 
         * @param nextToken
         *        A token for getting the next set of recommendations, if there are any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<InferenceRecommendationsJob> inferenceRecommendationsJobs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInferenceRecommendationsJobsResponse model) {
            super(model);
            inferenceRecommendationsJobs(model.inferenceRecommendationsJobs);
            nextToken(model.nextToken);
        }

        public final List<InferenceRecommendationsJob.Builder> getInferenceRecommendationsJobs() {
            List<InferenceRecommendationsJob.Builder> result = InferenceRecommendationsJobsCopier
                    .copyToBuilder(this.inferenceRecommendationsJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInferenceRecommendationsJobs(
                Collection<InferenceRecommendationsJob.BuilderImpl> inferenceRecommendationsJobs) {
            this.inferenceRecommendationsJobs = InferenceRecommendationsJobsCopier.copyFromBuilder(inferenceRecommendationsJobs);
        }

        @Override
        public final Builder inferenceRecommendationsJobs(Collection<InferenceRecommendationsJob> inferenceRecommendationsJobs) {
            this.inferenceRecommendationsJobs = InferenceRecommendationsJobsCopier.copy(inferenceRecommendationsJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceRecommendationsJobs(InferenceRecommendationsJob... inferenceRecommendationsJobs) {
            inferenceRecommendationsJobs(Arrays.asList(inferenceRecommendationsJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceRecommendationsJobs(
                Consumer<InferenceRecommendationsJob.Builder>... inferenceRecommendationsJobs) {
            inferenceRecommendationsJobs(Stream.of(inferenceRecommendationsJobs)
                    .map(c -> InferenceRecommendationsJob.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInferenceRecommendationsJobsResponse build() {
            return new ListInferenceRecommendationsJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
