/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The name, ARN, <code>CreationTime</code>, <code>FeatureGroup</code> values, <code>LastUpdatedTime</code> and
 * <code>EnableOnlineStorage</code> status of a <code>FeatureGroup</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FeatureGroupSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<FeatureGroupSummary.Builder, FeatureGroupSummary> {
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureGroupName").getter(getter(FeatureGroupSummary::featureGroupName))
            .setter(setter(Builder::featureGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupName").build()).build();

    private static final SdkField<String> FEATURE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureGroupArn").getter(getter(FeatureGroupSummary::featureGroupArn))
            .setter(setter(Builder::featureGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(FeatureGroupSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> FEATURE_GROUP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureGroupStatus").getter(getter(FeatureGroupSummary::featureGroupStatusAsString))
            .setter(setter(Builder::featureGroupStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupStatus").build())
            .build();

    private static final SdkField<OfflineStoreStatus> OFFLINE_STORE_STATUS_FIELD = SdkField
            .<OfflineStoreStatus> builder(MarshallingType.SDK_POJO).memberName("OfflineStoreStatus")
            .getter(getter(FeatureGroupSummary::offlineStoreStatus)).setter(setter(Builder::offlineStoreStatus))
            .constructor(OfflineStoreStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfflineStoreStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_NAME_FIELD,
            FEATURE_GROUP_ARN_FIELD, CREATION_TIME_FIELD, FEATURE_GROUP_STATUS_FIELD, OFFLINE_STORE_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String featureGroupName;

    private final String featureGroupArn;

    private final Instant creationTime;

    private final String featureGroupStatus;

    private final OfflineStoreStatus offlineStoreStatus;

    private FeatureGroupSummary(BuilderImpl builder) {
        this.featureGroupName = builder.featureGroupName;
        this.featureGroupArn = builder.featureGroupArn;
        this.creationTime = builder.creationTime;
        this.featureGroupStatus = builder.featureGroupStatus;
        this.offlineStoreStatus = builder.offlineStoreStatus;
    }

    /**
     * <p>
     * The name of <code>FeatureGroup</code>.
     * </p>
     * 
     * @return The name of <code>FeatureGroup</code>.
     */
    public final String featureGroupName() {
        return featureGroupName;
    }

    /**
     * <p>
     * Unique identifier for the <code>FeatureGroup</code>.
     * </p>
     * 
     * @return Unique identifier for the <code>FeatureGroup</code>.
     */
    public final String featureGroupArn() {
        return featureGroupArn;
    }

    /**
     * <p>
     * A timestamp indicating the time of creation time of the <code>FeatureGroup</code>.
     * </p>
     * 
     * @return A timestamp indicating the time of creation time of the <code>FeatureGroup</code>.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The status of a FeatureGroup. The status can be any of the following: <code>Creating</code>, <code>Created</code>, <code>CreateFail</code>, <code>Deleting</code> or <code>DetailFail</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #featureGroupStatus} will return {@link FeatureGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #featureGroupStatusAsString}.
     * </p>
     * 
     * @return The status of a FeatureGroup. The status can be any of the following: <code>Creating</code>,
     *         <code>Created</code>, <code>CreateFail</code>, <code>Deleting</code> or <code>DetailFail</code>.
     * @see FeatureGroupStatus
     */
    public final FeatureGroupStatus featureGroupStatus() {
        return FeatureGroupStatus.fromValue(featureGroupStatus);
    }

    /**
     * <p>
     * The status of a FeatureGroup. The status can be any of the following: <code>Creating</code>, <code>Created</code>, <code>CreateFail</code>, <code>Deleting</code> or <code>DetailFail</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #featureGroupStatus} will return {@link FeatureGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #featureGroupStatusAsString}.
     * </p>
     * 
     * @return The status of a FeatureGroup. The status can be any of the following: <code>Creating</code>,
     *         <code>Created</code>, <code>CreateFail</code>, <code>Deleting</code> or <code>DetailFail</code>.
     * @see FeatureGroupStatus
     */
    public final String featureGroupStatusAsString() {
        return featureGroupStatus;
    }

    /**
     * <p>
     * Notifies you if replicating data into the <code>OfflineStore</code> has failed. Returns either:
     * <code>Active</code> or <code>Blocked</code>.
     * </p>
     * 
     * @return Notifies you if replicating data into the <code>OfflineStore</code> has failed. Returns either:
     *         <code>Active</code> or <code>Blocked</code>.
     */
    public final OfflineStoreStatus offlineStoreStatus() {
        return offlineStoreStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(featureGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(featureGroupStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(offlineStoreStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeatureGroupSummary)) {
            return false;
        }
        FeatureGroupSummary other = (FeatureGroupSummary) obj;
        return Objects.equals(featureGroupName(), other.featureGroupName())
                && Objects.equals(featureGroupArn(), other.featureGroupArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(featureGroupStatusAsString(), other.featureGroupStatusAsString())
                && Objects.equals(offlineStoreStatus(), other.offlineStoreStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FeatureGroupSummary").add("FeatureGroupName", featureGroupName())
                .add("FeatureGroupArn", featureGroupArn()).add("CreationTime", creationTime())
                .add("FeatureGroupStatus", featureGroupStatusAsString()).add("OfflineStoreStatus", offlineStoreStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeatureGroupName":
            return Optional.ofNullable(clazz.cast(featureGroupName()));
        case "FeatureGroupArn":
            return Optional.ofNullable(clazz.cast(featureGroupArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "FeatureGroupStatus":
            return Optional.ofNullable(clazz.cast(featureGroupStatusAsString()));
        case "OfflineStoreStatus":
            return Optional.ofNullable(clazz.cast(offlineStoreStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FeatureGroupSummary, T> g) {
        return obj -> g.apply((FeatureGroupSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FeatureGroupSummary> {
        /**
         * <p>
         * The name of <code>FeatureGroup</code>.
         * </p>
         * 
         * @param featureGroupName
         *        The name of <code>FeatureGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureGroupName(String featureGroupName);

        /**
         * <p>
         * Unique identifier for the <code>FeatureGroup</code>.
         * </p>
         * 
         * @param featureGroupArn
         *        Unique identifier for the <code>FeatureGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureGroupArn(String featureGroupArn);

        /**
         * <p>
         * A timestamp indicating the time of creation time of the <code>FeatureGroup</code>.
         * </p>
         * 
         * @param creationTime
         *        A timestamp indicating the time of creation time of the <code>FeatureGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The status of a FeatureGroup. The status can be any of the following: <code>Creating</code>,
         * <code>Created</code>, <code>CreateFail</code>, <code>Deleting</code> or <code>DetailFail</code>.
         * </p>
         * 
         * @param featureGroupStatus
         *        The status of a FeatureGroup. The status can be any of the following: <code>Creating</code>,
         *        <code>Created</code>, <code>CreateFail</code>, <code>Deleting</code> or <code>DetailFail</code>.
         * @see FeatureGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureGroupStatus
         */
        Builder featureGroupStatus(String featureGroupStatus);

        /**
         * <p>
         * The status of a FeatureGroup. The status can be any of the following: <code>Creating</code>,
         * <code>Created</code>, <code>CreateFail</code>, <code>Deleting</code> or <code>DetailFail</code>.
         * </p>
         * 
         * @param featureGroupStatus
         *        The status of a FeatureGroup. The status can be any of the following: <code>Creating</code>,
         *        <code>Created</code>, <code>CreateFail</code>, <code>Deleting</code> or <code>DetailFail</code>.
         * @see FeatureGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureGroupStatus
         */
        Builder featureGroupStatus(FeatureGroupStatus featureGroupStatus);

        /**
         * <p>
         * Notifies you if replicating data into the <code>OfflineStore</code> has failed. Returns either:
         * <code>Active</code> or <code>Blocked</code>.
         * </p>
         * 
         * @param offlineStoreStatus
         *        Notifies you if replicating data into the <code>OfflineStore</code> has failed. Returns either:
         *        <code>Active</code> or <code>Blocked</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offlineStoreStatus(OfflineStoreStatus offlineStoreStatus);

        /**
         * <p>
         * Notifies you if replicating data into the <code>OfflineStore</code> has failed. Returns either:
         * <code>Active</code> or <code>Blocked</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link OfflineStoreStatus.Builder} avoiding the
         * need to create one manually via {@link OfflineStoreStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OfflineStoreStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #offlineStoreStatus(OfflineStoreStatus)}.
         * 
         * @param offlineStoreStatus
         *        a consumer that will call methods on {@link OfflineStoreStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offlineStoreStatus(OfflineStoreStatus)
         */
        default Builder offlineStoreStatus(Consumer<OfflineStoreStatus.Builder> offlineStoreStatus) {
            return offlineStoreStatus(OfflineStoreStatus.builder().applyMutation(offlineStoreStatus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String featureGroupName;

        private String featureGroupArn;

        private Instant creationTime;

        private String featureGroupStatus;

        private OfflineStoreStatus offlineStoreStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(FeatureGroupSummary model) {
            featureGroupName(model.featureGroupName);
            featureGroupArn(model.featureGroupArn);
            creationTime(model.creationTime);
            featureGroupStatus(model.featureGroupStatus);
            offlineStoreStatus(model.offlineStoreStatus);
        }

        public final String getFeatureGroupName() {
            return featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final String getFeatureGroupArn() {
            return featureGroupArn;
        }

        public final void setFeatureGroupArn(String featureGroupArn) {
            this.featureGroupArn = featureGroupArn;
        }

        @Override
        public final Builder featureGroupArn(String featureGroupArn) {
            this.featureGroupArn = featureGroupArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFeatureGroupStatus() {
            return featureGroupStatus;
        }

        public final void setFeatureGroupStatus(String featureGroupStatus) {
            this.featureGroupStatus = featureGroupStatus;
        }

        @Override
        public final Builder featureGroupStatus(String featureGroupStatus) {
            this.featureGroupStatus = featureGroupStatus;
            return this;
        }

        @Override
        public final Builder featureGroupStatus(FeatureGroupStatus featureGroupStatus) {
            this.featureGroupStatus(featureGroupStatus == null ? null : featureGroupStatus.toString());
            return this;
        }

        public final OfflineStoreStatus.Builder getOfflineStoreStatus() {
            return offlineStoreStatus != null ? offlineStoreStatus.toBuilder() : null;
        }

        public final void setOfflineStoreStatus(OfflineStoreStatus.BuilderImpl offlineStoreStatus) {
            this.offlineStoreStatus = offlineStoreStatus != null ? offlineStoreStatus.build() : null;
        }

        @Override
        public final Builder offlineStoreStatus(OfflineStoreStatus offlineStoreStatus) {
            this.offlineStoreStatus = offlineStoreStatus;
            return this;
        }

        @Override
        public FeatureGroupSummary build() {
            return new FeatureGroupSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
