/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information summarizing an edge deployment plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EdgeDeploymentPlanSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EdgeDeploymentPlanSummary.Builder, EdgeDeploymentPlanSummary> {
    private static final SdkField<String> EDGE_DEPLOYMENT_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgeDeploymentPlanArn").getter(getter(EdgeDeploymentPlanSummary::edgeDeploymentPlanArn))
            .setter(setter(Builder::edgeDeploymentPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentPlanArn").build())
            .build();

    private static final SdkField<String> EDGE_DEPLOYMENT_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgeDeploymentPlanName").getter(getter(EdgeDeploymentPlanSummary::edgeDeploymentPlanName))
            .setter(setter(Builder::edgeDeploymentPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentPlanName").build())
            .build();

    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceFleetName").getter(getter(EdgeDeploymentPlanSummary::deviceFleetName))
            .setter(setter(Builder::deviceFleetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()).build();

    private static final SdkField<Integer> EDGE_DEPLOYMENT_SUCCESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EdgeDeploymentSuccess").getter(getter(EdgeDeploymentPlanSummary::edgeDeploymentSuccess))
            .setter(setter(Builder::edgeDeploymentSuccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentSuccess").build())
            .build();

    private static final SdkField<Integer> EDGE_DEPLOYMENT_PENDING_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EdgeDeploymentPending").getter(getter(EdgeDeploymentPlanSummary::edgeDeploymentPending))
            .setter(setter(Builder::edgeDeploymentPending))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentPending").build())
            .build();

    private static final SdkField<Integer> EDGE_DEPLOYMENT_FAILED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EdgeDeploymentFailed").getter(getter(EdgeDeploymentPlanSummary::edgeDeploymentFailed))
            .setter(setter(Builder::edgeDeploymentFailed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentFailed").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(EdgeDeploymentPlanSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(EdgeDeploymentPlanSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EDGE_DEPLOYMENT_PLAN_ARN_FIELD, EDGE_DEPLOYMENT_PLAN_NAME_FIELD, DEVICE_FLEET_NAME_FIELD,
            EDGE_DEPLOYMENT_SUCCESS_FIELD, EDGE_DEPLOYMENT_PENDING_FIELD, EDGE_DEPLOYMENT_FAILED_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String edgeDeploymentPlanArn;

    private final String edgeDeploymentPlanName;

    private final String deviceFleetName;

    private final Integer edgeDeploymentSuccess;

    private final Integer edgeDeploymentPending;

    private final Integer edgeDeploymentFailed;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private EdgeDeploymentPlanSummary(BuilderImpl builder) {
        this.edgeDeploymentPlanArn = builder.edgeDeploymentPlanArn;
        this.edgeDeploymentPlanName = builder.edgeDeploymentPlanName;
        this.deviceFleetName = builder.deviceFleetName;
        this.edgeDeploymentSuccess = builder.edgeDeploymentSuccess;
        this.edgeDeploymentPending = builder.edgeDeploymentPending;
        this.edgeDeploymentFailed = builder.edgeDeploymentFailed;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The ARN of the edge deployment plan.
     * </p>
     * 
     * @return The ARN of the edge deployment plan.
     */
    public final String edgeDeploymentPlanArn() {
        return edgeDeploymentPlanArn;
    }

    /**
     * <p>
     * The name of the edge deployment plan.
     * </p>
     * 
     * @return The name of the edge deployment plan.
     */
    public final String edgeDeploymentPlanName() {
        return edgeDeploymentPlanName;
    }

    /**
     * <p>
     * The name of the device fleet used for the deployment.
     * </p>
     * 
     * @return The name of the device fleet used for the deployment.
     */
    public final String deviceFleetName() {
        return deviceFleetName;
    }

    /**
     * <p>
     * The number of edge devices with the successful deployment.
     * </p>
     * 
     * @return The number of edge devices with the successful deployment.
     */
    public final Integer edgeDeploymentSuccess() {
        return edgeDeploymentSuccess;
    }

    /**
     * <p>
     * The number of edge devices yet to pick up the deployment, or in progress.
     * </p>
     * 
     * @return The number of edge devices yet to pick up the deployment, or in progress.
     */
    public final Integer edgeDeploymentPending() {
        return edgeDeploymentPending;
    }

    /**
     * <p>
     * The number of edge devices that failed the deployment.
     * </p>
     * 
     * @return The number of edge devices that failed the deployment.
     */
    public final Integer edgeDeploymentFailed() {
        return edgeDeploymentFailed;
    }

    /**
     * <p>
     * The time when the edge deployment plan was created.
     * </p>
     * 
     * @return The time when the edge deployment plan was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time when the edge deployment plan was last updated.
     * </p>
     * 
     * @return The time when the edge deployment plan was last updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(edgeDeploymentPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(edgeDeploymentPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceFleetName());
        hashCode = 31 * hashCode + Objects.hashCode(edgeDeploymentSuccess());
        hashCode = 31 * hashCode + Objects.hashCode(edgeDeploymentPending());
        hashCode = 31 * hashCode + Objects.hashCode(edgeDeploymentFailed());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeDeploymentPlanSummary)) {
            return false;
        }
        EdgeDeploymentPlanSummary other = (EdgeDeploymentPlanSummary) obj;
        return Objects.equals(edgeDeploymentPlanArn(), other.edgeDeploymentPlanArn())
                && Objects.equals(edgeDeploymentPlanName(), other.edgeDeploymentPlanName())
                && Objects.equals(deviceFleetName(), other.deviceFleetName())
                && Objects.equals(edgeDeploymentSuccess(), other.edgeDeploymentSuccess())
                && Objects.equals(edgeDeploymentPending(), other.edgeDeploymentPending())
                && Objects.equals(edgeDeploymentFailed(), other.edgeDeploymentFailed())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EdgeDeploymentPlanSummary").add("EdgeDeploymentPlanArn", edgeDeploymentPlanArn())
                .add("EdgeDeploymentPlanName", edgeDeploymentPlanName()).add("DeviceFleetName", deviceFleetName())
                .add("EdgeDeploymentSuccess", edgeDeploymentSuccess()).add("EdgeDeploymentPending", edgeDeploymentPending())
                .add("EdgeDeploymentFailed", edgeDeploymentFailed()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EdgeDeploymentPlanArn":
            return Optional.ofNullable(clazz.cast(edgeDeploymentPlanArn()));
        case "EdgeDeploymentPlanName":
            return Optional.ofNullable(clazz.cast(edgeDeploymentPlanName()));
        case "DeviceFleetName":
            return Optional.ofNullable(clazz.cast(deviceFleetName()));
        case "EdgeDeploymentSuccess":
            return Optional.ofNullable(clazz.cast(edgeDeploymentSuccess()));
        case "EdgeDeploymentPending":
            return Optional.ofNullable(clazz.cast(edgeDeploymentPending()));
        case "EdgeDeploymentFailed":
            return Optional.ofNullable(clazz.cast(edgeDeploymentFailed()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EdgeDeploymentPlanSummary, T> g) {
        return obj -> g.apply((EdgeDeploymentPlanSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EdgeDeploymentPlanSummary> {
        /**
         * <p>
         * The ARN of the edge deployment plan.
         * </p>
         * 
         * @param edgeDeploymentPlanArn
         *        The ARN of the edge deployment plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeDeploymentPlanArn(String edgeDeploymentPlanArn);

        /**
         * <p>
         * The name of the edge deployment plan.
         * </p>
         * 
         * @param edgeDeploymentPlanName
         *        The name of the edge deployment plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeDeploymentPlanName(String edgeDeploymentPlanName);

        /**
         * <p>
         * The name of the device fleet used for the deployment.
         * </p>
         * 
         * @param deviceFleetName
         *        The name of the device fleet used for the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceFleetName(String deviceFleetName);

        /**
         * <p>
         * The number of edge devices with the successful deployment.
         * </p>
         * 
         * @param edgeDeploymentSuccess
         *        The number of edge devices with the successful deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeDeploymentSuccess(Integer edgeDeploymentSuccess);

        /**
         * <p>
         * The number of edge devices yet to pick up the deployment, or in progress.
         * </p>
         * 
         * @param edgeDeploymentPending
         *        The number of edge devices yet to pick up the deployment, or in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeDeploymentPending(Integer edgeDeploymentPending);

        /**
         * <p>
         * The number of edge devices that failed the deployment.
         * </p>
         * 
         * @param edgeDeploymentFailed
         *        The number of edge devices that failed the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeDeploymentFailed(Integer edgeDeploymentFailed);

        /**
         * <p>
         * The time when the edge deployment plan was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the edge deployment plan was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time when the edge deployment plan was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time when the edge deployment plan was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String edgeDeploymentPlanArn;

        private String edgeDeploymentPlanName;

        private String deviceFleetName;

        private Integer edgeDeploymentSuccess;

        private Integer edgeDeploymentPending;

        private Integer edgeDeploymentFailed;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeDeploymentPlanSummary model) {
            edgeDeploymentPlanArn(model.edgeDeploymentPlanArn);
            edgeDeploymentPlanName(model.edgeDeploymentPlanName);
            deviceFleetName(model.deviceFleetName);
            edgeDeploymentSuccess(model.edgeDeploymentSuccess);
            edgeDeploymentPending(model.edgeDeploymentPending);
            edgeDeploymentFailed(model.edgeDeploymentFailed);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getEdgeDeploymentPlanArn() {
            return edgeDeploymentPlanArn;
        }

        public final void setEdgeDeploymentPlanArn(String edgeDeploymentPlanArn) {
            this.edgeDeploymentPlanArn = edgeDeploymentPlanArn;
        }

        @Override
        public final Builder edgeDeploymentPlanArn(String edgeDeploymentPlanArn) {
            this.edgeDeploymentPlanArn = edgeDeploymentPlanArn;
            return this;
        }

        public final String getEdgeDeploymentPlanName() {
            return edgeDeploymentPlanName;
        }

        public final void setEdgeDeploymentPlanName(String edgeDeploymentPlanName) {
            this.edgeDeploymentPlanName = edgeDeploymentPlanName;
        }

        @Override
        public final Builder edgeDeploymentPlanName(String edgeDeploymentPlanName) {
            this.edgeDeploymentPlanName = edgeDeploymentPlanName;
            return this;
        }

        public final String getDeviceFleetName() {
            return deviceFleetName;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        @Override
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        public final Integer getEdgeDeploymentSuccess() {
            return edgeDeploymentSuccess;
        }

        public final void setEdgeDeploymentSuccess(Integer edgeDeploymentSuccess) {
            this.edgeDeploymentSuccess = edgeDeploymentSuccess;
        }

        @Override
        public final Builder edgeDeploymentSuccess(Integer edgeDeploymentSuccess) {
            this.edgeDeploymentSuccess = edgeDeploymentSuccess;
            return this;
        }

        public final Integer getEdgeDeploymentPending() {
            return edgeDeploymentPending;
        }

        public final void setEdgeDeploymentPending(Integer edgeDeploymentPending) {
            this.edgeDeploymentPending = edgeDeploymentPending;
        }

        @Override
        public final Builder edgeDeploymentPending(Integer edgeDeploymentPending) {
            this.edgeDeploymentPending = edgeDeploymentPending;
            return this;
        }

        public final Integer getEdgeDeploymentFailed() {
            return edgeDeploymentFailed;
        }

        public final void setEdgeDeploymentFailed(Integer edgeDeploymentFailed) {
            this.edgeDeploymentFailed = edgeDeploymentFailed;
        }

        @Override
        public final Builder edgeDeploymentFailed(Integer edgeDeploymentFailed) {
            this.edgeDeploymentFailed = edgeDeploymentFailed;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public EdgeDeploymentPlanSummary build() {
            return new EdgeDeploymentPlanSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
