/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesResponse;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSummary;

public class ListNotebookInstancesPublisher
implements SdkPublisher<ListNotebookInstancesResponse> {
    private final SageMakerAsyncClient client;
    private final ListNotebookInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNotebookInstancesPublisher(SageMakerAsyncClient client, ListNotebookInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNotebookInstancesPublisher(SageMakerAsyncClient client, ListNotebookInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNotebookInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNotebookInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NotebookInstanceSummary> notebookInstances() {
        Function<ListNotebookInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.notebookInstances() != null) {
                return response.notebookInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListNotebookInstancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListNotebookInstancesResponseFetcher
    implements AsyncPageFetcher<ListNotebookInstancesResponse> {
        private ListNotebookInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListNotebookInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListNotebookInstancesResponse> nextPage(ListNotebookInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListNotebookInstancesPublisher.this.client.listNotebookInstances(ListNotebookInstancesPublisher.this.firstRequest);
            }
            return ListNotebookInstancesPublisher.this.client.listNotebookInstances((ListNotebookInstancesRequest)((Object)ListNotebookInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

