/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobSummary;
import software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsResponse;

public class ListEdgePackagingJobsPublisher
implements SdkPublisher<ListEdgePackagingJobsResponse> {
    private final SageMakerAsyncClient client;
    private final ListEdgePackagingJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEdgePackagingJobsPublisher(SageMakerAsyncClient client, ListEdgePackagingJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEdgePackagingJobsPublisher(SageMakerAsyncClient client, ListEdgePackagingJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEdgePackagingJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEdgePackagingJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EdgePackagingJobSummary> edgePackagingJobSummaries() {
        Function<ListEdgePackagingJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.edgePackagingJobSummaries() != null) {
                return response.edgePackagingJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEdgePackagingJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEdgePackagingJobsResponseFetcher
    implements AsyncPageFetcher<ListEdgePackagingJobsResponse> {
        private ListEdgePackagingJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListEdgePackagingJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEdgePackagingJobsResponse> nextPage(ListEdgePackagingJobsResponse previousPage) {
            if (previousPage == null) {
                return ListEdgePackagingJobsPublisher.this.client.listEdgePackagingJobs(ListEdgePackagingJobsPublisher.this.firstRequest);
            }
            return ListEdgePackagingJobsPublisher.this.client.listEdgePackagingJobs((ListEdgePackagingJobsRequest)((Object)ListEdgePackagingJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

