/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.AdditionalInferenceSpecificationDefinition;
import software.amazon.awssdk.services.sagemaker.model.AdditionalInferenceSpecificationsCopier;
import software.amazon.awssdk.services.sagemaker.model.CustomerMetadataKeyListCopier;
import software.amazon.awssdk.services.sagemaker.model.CustomerMetadataMapCopier;
import software.amazon.awssdk.services.sagemaker.model.ModelApprovalStatus;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateModelPackageRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateModelPackageRequest> {
    private static final SdkField<String> MODEL_PACKAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageArn").getter(UpdateModelPackageRequest.getter(UpdateModelPackageRequest::modelPackageArn)).setter(UpdateModelPackageRequest.setter(Builder::modelPackageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageArn").build()}).build();
    private static final SdkField<String> MODEL_APPROVAL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelApprovalStatus").getter(UpdateModelPackageRequest.getter(UpdateModelPackageRequest::modelApprovalStatusAsString)).setter(UpdateModelPackageRequest.setter(Builder::modelApprovalStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelApprovalStatus").build()}).build();
    private static final SdkField<String> APPROVAL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApprovalDescription").getter(UpdateModelPackageRequest.getter(UpdateModelPackageRequest::approvalDescription)).setter(UpdateModelPackageRequest.setter(Builder::approvalDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalDescription").build()}).build();
    private static final SdkField<Map<String, String>> CUSTOMER_METADATA_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CustomerMetadataProperties").getter(UpdateModelPackageRequest.getter(UpdateModelPackageRequest::customerMetadataProperties)).setter(UpdateModelPackageRequest.setter(Builder::customerMetadataProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerMetadataProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CUSTOMER_METADATA_PROPERTIES_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomerMetadataPropertiesToRemove").getter(UpdateModelPackageRequest.getter(UpdateModelPackageRequest::customerMetadataPropertiesToRemove)).setter(UpdateModelPackageRequest.setter(Builder::customerMetadataPropertiesToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerMetadataPropertiesToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AdditionalInferenceSpecificationDefinition>> ADDITIONAL_INFERENCE_SPECIFICATIONS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalInferenceSpecificationsToAdd").getter(UpdateModelPackageRequest.getter(UpdateModelPackageRequest::additionalInferenceSpecificationsToAdd)).setter(UpdateModelPackageRequest.setter(Builder::additionalInferenceSpecificationsToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInferenceSpecificationsToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdditionalInferenceSpecificationDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_ARN_FIELD, MODEL_APPROVAL_STATUS_FIELD, APPROVAL_DESCRIPTION_FIELD, CUSTOMER_METADATA_PROPERTIES_FIELD, CUSTOMER_METADATA_PROPERTIES_TO_REMOVE_FIELD, ADDITIONAL_INFERENCE_SPECIFICATIONS_TO_ADD_FIELD));
    private final String modelPackageArn;
    private final String modelApprovalStatus;
    private final String approvalDescription;
    private final Map<String, String> customerMetadataProperties;
    private final List<String> customerMetadataPropertiesToRemove;
    private final List<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecificationsToAdd;

    private UpdateModelPackageRequest(BuilderImpl builder) {
        super(builder);
        this.modelPackageArn = builder.modelPackageArn;
        this.modelApprovalStatus = builder.modelApprovalStatus;
        this.approvalDescription = builder.approvalDescription;
        this.customerMetadataProperties = builder.customerMetadataProperties;
        this.customerMetadataPropertiesToRemove = builder.customerMetadataPropertiesToRemove;
        this.additionalInferenceSpecificationsToAdd = builder.additionalInferenceSpecificationsToAdd;
    }

    public final String modelPackageArn() {
        return this.modelPackageArn;
    }

    public final ModelApprovalStatus modelApprovalStatus() {
        return ModelApprovalStatus.fromValue(this.modelApprovalStatus);
    }

    public final String modelApprovalStatusAsString() {
        return this.modelApprovalStatus;
    }

    public final String approvalDescription() {
        return this.approvalDescription;
    }

    public final boolean hasCustomerMetadataProperties() {
        return this.customerMetadataProperties != null && !(this.customerMetadataProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> customerMetadataProperties() {
        return this.customerMetadataProperties;
    }

    public final boolean hasCustomerMetadataPropertiesToRemove() {
        return this.customerMetadataPropertiesToRemove != null && !(this.customerMetadataPropertiesToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> customerMetadataPropertiesToRemove() {
        return this.customerMetadataPropertiesToRemove;
    }

    public final boolean hasAdditionalInferenceSpecificationsToAdd() {
        return this.additionalInferenceSpecificationsToAdd != null && !(this.additionalInferenceSpecificationsToAdd instanceof SdkAutoConstructList);
    }

    public final List<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecificationsToAdd() {
        return this.additionalInferenceSpecificationsToAdd;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelApprovalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomerMetadataProperties() ? this.customerMetadataProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomerMetadataPropertiesToRemove() ? this.customerMetadataPropertiesToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalInferenceSpecificationsToAdd() ? this.additionalInferenceSpecificationsToAdd() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateModelPackageRequest)) {
            return false;
        }
        UpdateModelPackageRequest other = (UpdateModelPackageRequest)((Object)obj);
        return Objects.equals(this.modelPackageArn(), other.modelPackageArn()) && Objects.equals(this.modelApprovalStatusAsString(), other.modelApprovalStatusAsString()) && Objects.equals(this.approvalDescription(), other.approvalDescription()) && this.hasCustomerMetadataProperties() == other.hasCustomerMetadataProperties() && Objects.equals(this.customerMetadataProperties(), other.customerMetadataProperties()) && this.hasCustomerMetadataPropertiesToRemove() == other.hasCustomerMetadataPropertiesToRemove() && Objects.equals(this.customerMetadataPropertiesToRemove(), other.customerMetadataPropertiesToRemove()) && this.hasAdditionalInferenceSpecificationsToAdd() == other.hasAdditionalInferenceSpecificationsToAdd() && Objects.equals(this.additionalInferenceSpecificationsToAdd(), other.additionalInferenceSpecificationsToAdd());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateModelPackageRequest").add("ModelPackageArn", (Object)this.modelPackageArn()).add("ModelApprovalStatus", (Object)this.modelApprovalStatusAsString()).add("ApprovalDescription", (Object)this.approvalDescription()).add("CustomerMetadataProperties", this.hasCustomerMetadataProperties() ? this.customerMetadataProperties() : null).add("CustomerMetadataPropertiesToRemove", this.hasCustomerMetadataPropertiesToRemove() ? this.customerMetadataPropertiesToRemove() : null).add("AdditionalInferenceSpecificationsToAdd", this.hasAdditionalInferenceSpecificationsToAdd() ? this.additionalInferenceSpecificationsToAdd() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelPackageArn": {
                return Optional.ofNullable(clazz.cast(this.modelPackageArn()));
            }
            case "ModelApprovalStatus": {
                return Optional.ofNullable(clazz.cast(this.modelApprovalStatusAsString()));
            }
            case "ApprovalDescription": {
                return Optional.ofNullable(clazz.cast(this.approvalDescription()));
            }
            case "CustomerMetadataProperties": {
                return Optional.ofNullable(clazz.cast(this.customerMetadataProperties()));
            }
            case "CustomerMetadataPropertiesToRemove": {
                return Optional.ofNullable(clazz.cast(this.customerMetadataPropertiesToRemove()));
            }
            case "AdditionalInferenceSpecificationsToAdd": {
                return Optional.ofNullable(clazz.cast(this.additionalInferenceSpecificationsToAdd()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateModelPackageRequest, T> g) {
        return obj -> g.apply((UpdateModelPackageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String modelPackageArn;
        private String modelApprovalStatus;
        private String approvalDescription;
        private Map<String, String> customerMetadataProperties = DefaultSdkAutoConstructMap.getInstance();
        private List<String> customerMetadataPropertiesToRemove = DefaultSdkAutoConstructList.getInstance();
        private List<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecificationsToAdd = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateModelPackageRequest model) {
            super(model);
            this.modelPackageArn(model.modelPackageArn);
            this.modelApprovalStatus(model.modelApprovalStatus);
            this.approvalDescription(model.approvalDescription);
            this.customerMetadataProperties(model.customerMetadataProperties);
            this.customerMetadataPropertiesToRemove(model.customerMetadataPropertiesToRemove);
            this.additionalInferenceSpecificationsToAdd(model.additionalInferenceSpecificationsToAdd);
        }

        public final String getModelPackageArn() {
            return this.modelPackageArn;
        }

        public final void setModelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
        }

        @Override
        public final Builder modelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
            return this;
        }

        public final String getModelApprovalStatus() {
            return this.modelApprovalStatus;
        }

        public final void setModelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
        }

        @Override
        public final Builder modelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
            return this;
        }

        @Override
        public final Builder modelApprovalStatus(ModelApprovalStatus modelApprovalStatus) {
            this.modelApprovalStatus(modelApprovalStatus == null ? null : modelApprovalStatus.toString());
            return this;
        }

        public final String getApprovalDescription() {
            return this.approvalDescription;
        }

        public final void setApprovalDescription(String approvalDescription) {
            this.approvalDescription = approvalDescription;
        }

        @Override
        public final Builder approvalDescription(String approvalDescription) {
            this.approvalDescription = approvalDescription;
            return this;
        }

        public final Map<String, String> getCustomerMetadataProperties() {
            if (this.customerMetadataProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.customerMetadataProperties;
        }

        public final void setCustomerMetadataProperties(Map<String, String> customerMetadataProperties) {
            this.customerMetadataProperties = CustomerMetadataMapCopier.copy(customerMetadataProperties);
        }

        @Override
        public final Builder customerMetadataProperties(Map<String, String> customerMetadataProperties) {
            this.customerMetadataProperties = CustomerMetadataMapCopier.copy(customerMetadataProperties);
            return this;
        }

        public final Collection<String> getCustomerMetadataPropertiesToRemove() {
            if (this.customerMetadataPropertiesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customerMetadataPropertiesToRemove;
        }

        public final void setCustomerMetadataPropertiesToRemove(Collection<String> customerMetadataPropertiesToRemove) {
            this.customerMetadataPropertiesToRemove = CustomerMetadataKeyListCopier.copy(customerMetadataPropertiesToRemove);
        }

        @Override
        public final Builder customerMetadataPropertiesToRemove(Collection<String> customerMetadataPropertiesToRemove) {
            this.customerMetadataPropertiesToRemove = CustomerMetadataKeyListCopier.copy(customerMetadataPropertiesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerMetadataPropertiesToRemove(String ... customerMetadataPropertiesToRemove) {
            this.customerMetadataPropertiesToRemove(Arrays.asList(customerMetadataPropertiesToRemove));
            return this;
        }

        public final List<AdditionalInferenceSpecificationDefinition.Builder> getAdditionalInferenceSpecificationsToAdd() {
            List<AdditionalInferenceSpecificationDefinition.Builder> result = AdditionalInferenceSpecificationsCopier.copyToBuilder(this.additionalInferenceSpecificationsToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalInferenceSpecificationsToAdd(Collection<AdditionalInferenceSpecificationDefinition.BuilderImpl> additionalInferenceSpecificationsToAdd) {
            this.additionalInferenceSpecificationsToAdd = AdditionalInferenceSpecificationsCopier.copyFromBuilder(additionalInferenceSpecificationsToAdd);
        }

        @Override
        public final Builder additionalInferenceSpecificationsToAdd(Collection<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecificationsToAdd) {
            this.additionalInferenceSpecificationsToAdd = AdditionalInferenceSpecificationsCopier.copy(additionalInferenceSpecificationsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalInferenceSpecificationsToAdd(AdditionalInferenceSpecificationDefinition ... additionalInferenceSpecificationsToAdd) {
            this.additionalInferenceSpecificationsToAdd(Arrays.asList(additionalInferenceSpecificationsToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalInferenceSpecificationsToAdd(Consumer<AdditionalInferenceSpecificationDefinition.Builder> ... additionalInferenceSpecificationsToAdd) {
            this.additionalInferenceSpecificationsToAdd(Stream.of(additionalInferenceSpecificationsToAdd).map(c -> (AdditionalInferenceSpecificationDefinition)((AdditionalInferenceSpecificationDefinition.Builder)AdditionalInferenceSpecificationDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateModelPackageRequest build() {
            return new UpdateModelPackageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateModelPackageRequest> {
        public Builder modelPackageArn(String var1);

        public Builder modelApprovalStatus(String var1);

        public Builder modelApprovalStatus(ModelApprovalStatus var1);

        public Builder approvalDescription(String var1);

        public Builder customerMetadataProperties(Map<String, String> var1);

        public Builder customerMetadataPropertiesToRemove(Collection<String> var1);

        public Builder customerMetadataPropertiesToRemove(String ... var1);

        public Builder additionalInferenceSpecificationsToAdd(Collection<AdditionalInferenceSpecificationDefinition> var1);

        public Builder additionalInferenceSpecificationsToAdd(AdditionalInferenceSpecificationDefinition ... var1);

        public Builder additionalInferenceSpecificationsToAdd(Consumer<AdditionalInferenceSpecificationDefinition.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

