/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrialComponentArtifact
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrialComponentArtifact> {
    private static final SdkField<String> MEDIA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaType").getter(TrialComponentArtifact.getter(TrialComponentArtifact::mediaType)).setter(TrialComponentArtifact.setter(Builder::mediaType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaType").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(TrialComponentArtifact.getter(TrialComponentArtifact::value)).setter(TrialComponentArtifact.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_TYPE_FIELD, VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String mediaType;
    private final String value;

    private TrialComponentArtifact(BuilderImpl builder) {
        this.mediaType = builder.mediaType;
        this.value = builder.value;
    }

    public final String mediaType() {
        return this.mediaType;
    }

    public final String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaType());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrialComponentArtifact)) {
            return false;
        }
        TrialComponentArtifact other = (TrialComponentArtifact)obj;
        return Objects.equals(this.mediaType(), other.mediaType()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"TrialComponentArtifact").add("MediaType", (Object)this.mediaType()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MediaType": {
                return Optional.ofNullable(clazz.cast(this.mediaType()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrialComponentArtifact, T> g) {
        return obj -> g.apply((TrialComponentArtifact)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mediaType;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(TrialComponentArtifact model) {
            this.mediaType(model.mediaType);
            this.value(model.value);
        }

        public final String getMediaType() {
            return this.mediaType;
        }

        public final void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        @Override
        public final Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public TrialComponentArtifact build() {
            return new TrialComponentArtifact(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrialComponentArtifact> {
        public Builder mediaType(String var1);

        public Builder value(String var1);
    }
}

