/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3StorageConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3StorageConfig> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Uri").getter(S3StorageConfig.getter(S3StorageConfig::s3Uri)).setter(S3StorageConfig.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(S3StorageConfig.getter(S3StorageConfig::kmsKeyId)).setter(S3StorageConfig.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> RESOLVED_OUTPUT_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResolvedOutputS3Uri").getter(S3StorageConfig.getter(S3StorageConfig::resolvedOutputS3Uri)).setter(S3StorageConfig.setter(Builder::resolvedOutputS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolvedOutputS3Uri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD, KMS_KEY_ID_FIELD, RESOLVED_OUTPUT_S3_URI_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3Uri;
    private final String kmsKeyId;
    private final String resolvedOutputS3Uri;

    private S3StorageConfig(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.kmsKeyId = builder.kmsKeyId;
        this.resolvedOutputS3Uri = builder.resolvedOutputS3Uri;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String resolvedOutputS3Uri() {
        return this.resolvedOutputS3Uri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedOutputS3Uri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3StorageConfig)) {
            return false;
        }
        S3StorageConfig other = (S3StorageConfig)obj;
        return Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.resolvedOutputS3Uri(), other.resolvedOutputS3Uri());
    }

    public final String toString() {
        return ToString.builder((String)"S3StorageConfig").add("S3Uri", (Object)this.s3Uri()).add("KmsKeyId", (Object)this.kmsKeyId()).add("ResolvedOutputS3Uri", (Object)this.resolvedOutputS3Uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "ResolvedOutputS3Uri": {
                return Optional.ofNullable(clazz.cast(this.resolvedOutputS3Uri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3StorageConfig, T> g) {
        return obj -> g.apply((S3StorageConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Uri;
        private String kmsKeyId;
        private String resolvedOutputS3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(S3StorageConfig model) {
            this.s3Uri(model.s3Uri);
            this.kmsKeyId(model.kmsKeyId);
            this.resolvedOutputS3Uri(model.resolvedOutputS3Uri);
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getResolvedOutputS3Uri() {
            return this.resolvedOutputS3Uri;
        }

        public final void setResolvedOutputS3Uri(String resolvedOutputS3Uri) {
            this.resolvedOutputS3Uri = resolvedOutputS3Uri;
        }

        @Override
        public final Builder resolvedOutputS3Uri(String resolvedOutputS3Uri) {
            this.resolvedOutputS3Uri = resolvedOutputS3Uri;
            return this;
        }

        public S3StorageConfig build() {
            return new S3StorageConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3StorageConfig> {
        public Builder s3Uri(String var1);

        public Builder kmsKeyId(String var1);

        public Builder resolvedOutputS3Uri(String var1);
    }
}

