/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AppInstanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceSpec
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceSpec> {
    private static final SdkField<String> SAGE_MAKER_IMAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SageMakerImageArn").getter(ResourceSpec.getter(ResourceSpec::sageMakerImageArn)).setter(ResourceSpec.setter(Builder::sageMakerImageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SageMakerImageArn").build()}).build();
    private static final SdkField<String> SAGE_MAKER_IMAGE_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SageMakerImageVersionArn").getter(ResourceSpec.getter(ResourceSpec::sageMakerImageVersionArn)).setter(ResourceSpec.setter(Builder::sageMakerImageVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SageMakerImageVersionArn").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ResourceSpec.getter(ResourceSpec::instanceTypeAsString)).setter(ResourceSpec.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> LIFECYCLE_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LifecycleConfigArn").getter(ResourceSpec.getter(ResourceSpec::lifecycleConfigArn)).setter(ResourceSpec.setter(Builder::lifecycleConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleConfigArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAGE_MAKER_IMAGE_ARN_FIELD, SAGE_MAKER_IMAGE_VERSION_ARN_FIELD, INSTANCE_TYPE_FIELD, LIFECYCLE_CONFIG_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sageMakerImageArn;
    private final String sageMakerImageVersionArn;
    private final String instanceType;
    private final String lifecycleConfigArn;

    private ResourceSpec(BuilderImpl builder) {
        this.sageMakerImageArn = builder.sageMakerImageArn;
        this.sageMakerImageVersionArn = builder.sageMakerImageVersionArn;
        this.instanceType = builder.instanceType;
        this.lifecycleConfigArn = builder.lifecycleConfigArn;
    }

    public final String sageMakerImageArn() {
        return this.sageMakerImageArn;
    }

    public final String sageMakerImageVersionArn() {
        return this.sageMakerImageVersionArn;
    }

    public final AppInstanceType instanceType() {
        return AppInstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final String lifecycleConfigArn() {
        return this.lifecycleConfigArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sageMakerImageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sageMakerImageVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleConfigArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSpec)) {
            return false;
        }
        ResourceSpec other = (ResourceSpec)obj;
        return Objects.equals(this.sageMakerImageArn(), other.sageMakerImageArn()) && Objects.equals(this.sageMakerImageVersionArn(), other.sageMakerImageVersionArn()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.lifecycleConfigArn(), other.lifecycleConfigArn());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceSpec").add("SageMakerImageArn", (Object)this.sageMakerImageArn()).add("SageMakerImageVersionArn", (Object)this.sageMakerImageVersionArn()).add("InstanceType", (Object)this.instanceTypeAsString()).add("LifecycleConfigArn", (Object)this.lifecycleConfigArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SageMakerImageArn": {
                return Optional.ofNullable(clazz.cast(this.sageMakerImageArn()));
            }
            case "SageMakerImageVersionArn": {
                return Optional.ofNullable(clazz.cast(this.sageMakerImageVersionArn()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "LifecycleConfigArn": {
                return Optional.ofNullable(clazz.cast(this.lifecycleConfigArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceSpec, T> g) {
        return obj -> g.apply((ResourceSpec)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sageMakerImageArn;
        private String sageMakerImageVersionArn;
        private String instanceType;
        private String lifecycleConfigArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSpec model) {
            this.sageMakerImageArn(model.sageMakerImageArn);
            this.sageMakerImageVersionArn(model.sageMakerImageVersionArn);
            this.instanceType(model.instanceType);
            this.lifecycleConfigArn(model.lifecycleConfigArn);
        }

        public final String getSageMakerImageArn() {
            return this.sageMakerImageArn;
        }

        public final void setSageMakerImageArn(String sageMakerImageArn) {
            this.sageMakerImageArn = sageMakerImageArn;
        }

        @Override
        public final Builder sageMakerImageArn(String sageMakerImageArn) {
            this.sageMakerImageArn = sageMakerImageArn;
            return this;
        }

        public final String getSageMakerImageVersionArn() {
            return this.sageMakerImageVersionArn;
        }

        public final void setSageMakerImageVersionArn(String sageMakerImageVersionArn) {
            this.sageMakerImageVersionArn = sageMakerImageVersionArn;
        }

        @Override
        public final Builder sageMakerImageVersionArn(String sageMakerImageVersionArn) {
            this.sageMakerImageVersionArn = sageMakerImageVersionArn;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(AppInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getLifecycleConfigArn() {
            return this.lifecycleConfigArn;
        }

        public final void setLifecycleConfigArn(String lifecycleConfigArn) {
            this.lifecycleConfigArn = lifecycleConfigArn;
        }

        @Override
        public final Builder lifecycleConfigArn(String lifecycleConfigArn) {
            this.lifecycleConfigArn = lifecycleConfigArn;
            return this;
        }

        public ResourceSpec build() {
            return new ResourceSpec(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceSpec> {
        public Builder sageMakerImageArn(String var1);

        public Builder sageMakerImageVersionArn(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(AppInstanceType var1);

        public Builder lifecycleConfigArn(String var1);
    }
}

