/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrainingJobsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListTrainingJobsResponse> {
    private static final SdkField<List<TrainingJobSummary>> TRAINING_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrainingJobSummaries").getter(ListTrainingJobsResponse.getter(ListTrainingJobsResponse::trainingJobSummaries)).setter(ListTrainingJobsResponse.setter(Builder::trainingJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrainingJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTrainingJobsResponse.getter(ListTrainingJobsResponse::nextToken)).setter(ListTrainingJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<TrainingJobSummary> trainingJobSummaries;
    private final String nextToken;

    private ListTrainingJobsResponse(BuilderImpl builder) {
        super(builder);
        this.trainingJobSummaries = builder.trainingJobSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTrainingJobSummaries() {
        return this.trainingJobSummaries != null && !(this.trainingJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<TrainingJobSummary> trainingJobSummaries() {
        return this.trainingJobSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrainingJobSummaries() ? this.trainingJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrainingJobsResponse)) {
            return false;
        }
        ListTrainingJobsResponse other = (ListTrainingJobsResponse)((Object)obj);
        return this.hasTrainingJobSummaries() == other.hasTrainingJobSummaries() && Objects.equals(this.trainingJobSummaries(), other.trainingJobSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrainingJobsResponse").add("TrainingJobSummaries", this.hasTrainingJobSummaries() ? this.trainingJobSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.trainingJobSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrainingJobsResponse, T> g) {
        return obj -> g.apply((ListTrainingJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<TrainingJobSummary> trainingJobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrainingJobsResponse model) {
            super(model);
            this.trainingJobSummaries(model.trainingJobSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<TrainingJobSummary.Builder> getTrainingJobSummaries() {
            List<TrainingJobSummary.Builder> result = TrainingJobSummariesCopier.copyToBuilder(this.trainingJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrainingJobSummaries(Collection<TrainingJobSummary.BuilderImpl> trainingJobSummaries) {
            this.trainingJobSummaries = TrainingJobSummariesCopier.copyFromBuilder(trainingJobSummaries);
        }

        @Override
        public final Builder trainingJobSummaries(Collection<TrainingJobSummary> trainingJobSummaries) {
            this.trainingJobSummaries = TrainingJobSummariesCopier.copy(trainingJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingJobSummaries(TrainingJobSummary ... trainingJobSummaries) {
            this.trainingJobSummaries(Arrays.asList(trainingJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingJobSummaries(Consumer<TrainingJobSummary.Builder> ... trainingJobSummaries) {
            this.trainingJobSummaries(Stream.of(trainingJobSummaries).map(c -> (TrainingJobSummary)((TrainingJobSummary.Builder)TrainingJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTrainingJobsResponse build() {
            return new ListTrainingJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrainingJobsResponse> {
        public Builder trainingJobSummaries(Collection<TrainingJobSummary> var1);

        public Builder trainingJobSummaries(TrainingJobSummary ... var1);

        public Builder trainingJobSummaries(Consumer<TrainingJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

