/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.HubInfo;
import software.amazon.awssdk.services.sagemaker.model.HubInfoListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListHubsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListHubsResponse> {
    private static final SdkField<List<HubInfo>> HUB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HubSummaries").getter(ListHubsResponse.getter(ListHubsResponse::hubSummaries)).setter(ListHubsResponse.setter(Builder::hubSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HubInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListHubsResponse.getter(ListHubsResponse::nextToken)).setter(ListHubsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<HubInfo> hubSummaries;
    private final String nextToken;

    private ListHubsResponse(BuilderImpl builder) {
        super(builder);
        this.hubSummaries = builder.hubSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasHubSummaries() {
        return this.hubSummaries != null && !(this.hubSummaries instanceof SdkAutoConstructList);
    }

    public final List<HubInfo> hubSummaries() {
        return this.hubSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHubSummaries() ? this.hubSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHubsResponse)) {
            return false;
        }
        ListHubsResponse other = (ListHubsResponse)((Object)obj);
        return this.hasHubSummaries() == other.hasHubSummaries() && Objects.equals(this.hubSummaries(), other.hubSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListHubsResponse").add("HubSummaries", this.hasHubSummaries() ? this.hubSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HubSummaries": {
                return Optional.ofNullable(clazz.cast(this.hubSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHubsResponse, T> g) {
        return obj -> g.apply((ListHubsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<HubInfo> hubSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHubsResponse model) {
            super(model);
            this.hubSummaries(model.hubSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<HubInfo.Builder> getHubSummaries() {
            List<HubInfo.Builder> result = HubInfoListCopier.copyToBuilder(this.hubSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHubSummaries(Collection<HubInfo.BuilderImpl> hubSummaries) {
            this.hubSummaries = HubInfoListCopier.copyFromBuilder(hubSummaries);
        }

        @Override
        public final Builder hubSummaries(Collection<HubInfo> hubSummaries) {
            this.hubSummaries = HubInfoListCopier.copy(hubSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubSummaries(HubInfo ... hubSummaries) {
            this.hubSummaries(Arrays.asList(hubSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubSummaries(Consumer<HubInfo.Builder> ... hubSummaries) {
            this.hubSummaries(Stream.of(hubSummaries).map(c -> (HubInfo)((HubInfo.Builder)HubInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListHubsResponse build() {
            return new ListHubsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListHubsResponse> {
        public Builder hubSummaries(Collection<HubInfo> var1);

        public Builder hubSummaries(HubInfo ... var1);

        public Builder hubSummaries(Consumer<HubInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

