/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.EndpointPerformance;
import software.amazon.awssdk.services.sagemaker.model.EndpointPerformancesCopier;
import software.amazon.awssdk.services.sagemaker.model.InferenceRecommendation;
import software.amazon.awssdk.services.sagemaker.model.InferenceRecommendationsCopier;
import software.amazon.awssdk.services.sagemaker.model.RecommendationJobInputConfig;
import software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus;
import software.amazon.awssdk.services.sagemaker.model.RecommendationJobStoppingConditions;
import software.amazon.awssdk.services.sagemaker.model.RecommendationJobType;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInferenceRecommendationsJobResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeInferenceRecommendationsJobResponse> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(DescribeInferenceRecommendationsJobResponse.getter(DescribeInferenceRecommendationsJobResponse::jobName)).setter(DescribeInferenceRecommendationsJobResponse.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<String> JOB_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobDescription").getter(DescribeInferenceRecommendationsJobResponse.getter(DescribeInferenceRecommendationsJobResponse::jobDescription)).setter(DescribeInferenceRecommendationsJobResponse.setter(Builder::jobDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDescription").build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobType").getter(DescribeInferenceRecommendationsJobResponse.getter(DescribeInferenceRecommendationsJobResponse::jobTypeAsString)).setter(DescribeInferenceRecommendationsJobResponse.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()}).build();
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobArn").getter(DescribeInferenceRecommendationsJobResponse.getter(DescribeInferenceRecommendationsJobResponse::jobArn)).setter(DescribeInferenceRecommendationsJobResponse.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobArn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeInferenceRecommendationsJobResponse.getter(DescribeInferenceRecommendationsJobResponse::roleArn)).setter(DescribeInferenceRecommendationsJobResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeInferenceRecommendationsJobResponse.getter(DescribeInferenceRecommendationsJobResponse::statusAsString)).setter(DescribeInferenceRecommendationsJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeInferenceRecommendationsJobResponse.getter(DescribeInferenceRecommendationsJobResponse::creationTime)).setter(DescribeInferenceRecommendationsJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionTime").getter(DescribeInferenceRecommendationsJobResponse.getter(DescribeInferenceRecommendationsJobResponse::completionTime)).setter(DescribeInferenceRecommendationsJobResponse.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeInferenceRecommendationsJobResponse.getter(DescribeInferenceRecommendationsJobResponse::lastModifiedTime)).setter(DescribeInferenceRecommendationsJobResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeInferenceRecommendationsJobResponse.getter(DescribeInferenceRecommendationsJobResponse::failureReason)).setter(DescribeInferenceRecommendationsJobResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<RecommendationJobInputConfig> INPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputConfig").getter(DescribeInferenceRecommendationsJobResponse.getter(DescribeInferenceRecommendationsJobResponse::inputConfig)).setter(DescribeInferenceRecommendationsJobResponse.setter(Builder::inputConfig)).constructor(RecommendationJobInputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()}).build();
    private static final SdkField<RecommendationJobStoppingConditions> STOPPING_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StoppingConditions").getter(DescribeInferenceRecommendationsJobResponse.getter(DescribeInferenceRecommendationsJobResponse::stoppingConditions)).setter(DescribeInferenceRecommendationsJobResponse.setter(Builder::stoppingConditions)).constructor(RecommendationJobStoppingConditions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingConditions").build()}).build();
    private static final SdkField<List<InferenceRecommendation>> INFERENCE_RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InferenceRecommendations").getter(DescribeInferenceRecommendationsJobResponse.getter(DescribeInferenceRecommendationsJobResponse::inferenceRecommendations)).setter(DescribeInferenceRecommendationsJobResponse.setter(Builder::inferenceRecommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceRecommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InferenceRecommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EndpointPerformance>> ENDPOINT_PERFORMANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EndpointPerformances").getter(DescribeInferenceRecommendationsJobResponse.getter(DescribeInferenceRecommendationsJobResponse::endpointPerformances)).setter(DescribeInferenceRecommendationsJobResponse.setter(Builder::endpointPerformances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointPerformances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointPerformance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, JOB_DESCRIPTION_FIELD, JOB_TYPE_FIELD, JOB_ARN_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, COMPLETION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD, INPUT_CONFIG_FIELD, STOPPING_CONDITIONS_FIELD, INFERENCE_RECOMMENDATIONS_FIELD, ENDPOINT_PERFORMANCES_FIELD));
    private final String jobName;
    private final String jobDescription;
    private final String jobType;
    private final String jobArn;
    private final String roleArn;
    private final String status;
    private final Instant creationTime;
    private final Instant completionTime;
    private final Instant lastModifiedTime;
    private final String failureReason;
    private final RecommendationJobInputConfig inputConfig;
    private final RecommendationJobStoppingConditions stoppingConditions;
    private final List<InferenceRecommendation> inferenceRecommendations;
    private final List<EndpointPerformance> endpointPerformances;

    private DescribeInferenceRecommendationsJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.jobDescription = builder.jobDescription;
        this.jobType = builder.jobType;
        this.jobArn = builder.jobArn;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
        this.inputConfig = builder.inputConfig;
        this.stoppingConditions = builder.stoppingConditions;
        this.inferenceRecommendations = builder.inferenceRecommendations;
        this.endpointPerformances = builder.endpointPerformances;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String jobDescription() {
        return this.jobDescription;
    }

    public final RecommendationJobType jobType() {
        return RecommendationJobType.fromValue(this.jobType);
    }

    public final String jobTypeAsString() {
        return this.jobType;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final RecommendationJobStatus status() {
        return RecommendationJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final RecommendationJobInputConfig inputConfig() {
        return this.inputConfig;
    }

    public final RecommendationJobStoppingConditions stoppingConditions() {
        return this.stoppingConditions;
    }

    public final boolean hasInferenceRecommendations() {
        return this.inferenceRecommendations != null && !(this.inferenceRecommendations instanceof SdkAutoConstructList);
    }

    public final List<InferenceRecommendation> inferenceRecommendations() {
        return this.inferenceRecommendations;
    }

    public final boolean hasEndpointPerformances() {
        return this.endpointPerformances != null && !(this.endpointPerformances instanceof SdkAutoConstructList);
    }

    public final List<EndpointPerformance> endpointPerformances() {
        return this.endpointPerformances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingConditions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInferenceRecommendations() ? this.inferenceRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpointPerformances() ? this.endpointPerformances() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInferenceRecommendationsJobResponse)) {
            return false;
        }
        DescribeInferenceRecommendationsJobResponse other = (DescribeInferenceRecommendationsJobResponse)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobDescription(), other.jobDescription()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.inputConfig(), other.inputConfig()) && Objects.equals(this.stoppingConditions(), other.stoppingConditions()) && this.hasInferenceRecommendations() == other.hasInferenceRecommendations() && Objects.equals(this.inferenceRecommendations(), other.inferenceRecommendations()) && this.hasEndpointPerformances() == other.hasEndpointPerformances() && Objects.equals(this.endpointPerformances(), other.endpointPerformances());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInferenceRecommendationsJobResponse").add("JobName", (Object)this.jobName()).add("JobDescription", (Object)this.jobDescription()).add("JobType", (Object)this.jobTypeAsString()).add("JobArn", (Object)this.jobArn()).add("RoleArn", (Object)this.roleArn()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("CompletionTime", (Object)this.completionTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("FailureReason", (Object)this.failureReason()).add("InputConfig", (Object)this.inputConfig()).add("StoppingConditions", (Object)this.stoppingConditions()).add("InferenceRecommendations", this.hasInferenceRecommendations() ? this.inferenceRecommendations() : null).add("EndpointPerformances", this.hasEndpointPerformances() ? this.endpointPerformances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobDescription": {
                return Optional.ofNullable(clazz.cast(this.jobDescription()));
            }
            case "JobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "JobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CompletionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "InputConfig": {
                return Optional.ofNullable(clazz.cast(this.inputConfig()));
            }
            case "StoppingConditions": {
                return Optional.ofNullable(clazz.cast(this.stoppingConditions()));
            }
            case "InferenceRecommendations": {
                return Optional.ofNullable(clazz.cast(this.inferenceRecommendations()));
            }
            case "EndpointPerformances": {
                return Optional.ofNullable(clazz.cast(this.endpointPerformances()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInferenceRecommendationsJobResponse, T> g) {
        return obj -> g.apply((DescribeInferenceRecommendationsJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String jobName;
        private String jobDescription;
        private String jobType;
        private String jobArn;
        private String roleArn;
        private String status;
        private Instant creationTime;
        private Instant completionTime;
        private Instant lastModifiedTime;
        private String failureReason;
        private RecommendationJobInputConfig inputConfig;
        private RecommendationJobStoppingConditions stoppingConditions;
        private List<InferenceRecommendation> inferenceRecommendations = DefaultSdkAutoConstructList.getInstance();
        private List<EndpointPerformance> endpointPerformances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInferenceRecommendationsJobResponse model) {
            super(model);
            this.jobName(model.jobName);
            this.jobDescription(model.jobDescription);
            this.jobType(model.jobType);
            this.jobArn(model.jobArn);
            this.roleArn(model.roleArn);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.completionTime(model.completionTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.failureReason(model.failureReason);
            this.inputConfig(model.inputConfig);
            this.stoppingConditions(model.stoppingConditions);
            this.inferenceRecommendations(model.inferenceRecommendations);
            this.endpointPerformances(model.endpointPerformances);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobDescription() {
            return this.jobDescription;
        }

        public final void setJobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
        }

        @Override
        public final Builder jobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
            return this;
        }

        public final String getJobType() {
            return this.jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(RecommendationJobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecommendationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final RecommendationJobInputConfig.Builder getInputConfig() {
            return this.inputConfig != null ? this.inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(RecommendationJobInputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        public final Builder inputConfig(RecommendationJobInputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final RecommendationJobStoppingConditions.Builder getStoppingConditions() {
            return this.stoppingConditions != null ? this.stoppingConditions.toBuilder() : null;
        }

        public final void setStoppingConditions(RecommendationJobStoppingConditions.BuilderImpl stoppingConditions) {
            this.stoppingConditions = stoppingConditions != null ? stoppingConditions.build() : null;
        }

        @Override
        public final Builder stoppingConditions(RecommendationJobStoppingConditions stoppingConditions) {
            this.stoppingConditions = stoppingConditions;
            return this;
        }

        public final List<InferenceRecommendation.Builder> getInferenceRecommendations() {
            List<InferenceRecommendation.Builder> result = InferenceRecommendationsCopier.copyToBuilder(this.inferenceRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInferenceRecommendations(Collection<InferenceRecommendation.BuilderImpl> inferenceRecommendations) {
            this.inferenceRecommendations = InferenceRecommendationsCopier.copyFromBuilder(inferenceRecommendations);
        }

        @Override
        public final Builder inferenceRecommendations(Collection<InferenceRecommendation> inferenceRecommendations) {
            this.inferenceRecommendations = InferenceRecommendationsCopier.copy(inferenceRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceRecommendations(InferenceRecommendation ... inferenceRecommendations) {
            this.inferenceRecommendations(Arrays.asList(inferenceRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceRecommendations(Consumer<InferenceRecommendation.Builder> ... inferenceRecommendations) {
            this.inferenceRecommendations(Stream.of(inferenceRecommendations).map(c -> (InferenceRecommendation)((InferenceRecommendation.Builder)InferenceRecommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EndpointPerformance.Builder> getEndpointPerformances() {
            List<EndpointPerformance.Builder> result = EndpointPerformancesCopier.copyToBuilder(this.endpointPerformances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpointPerformances(Collection<EndpointPerformance.BuilderImpl> endpointPerformances) {
            this.endpointPerformances = EndpointPerformancesCopier.copyFromBuilder(endpointPerformances);
        }

        @Override
        public final Builder endpointPerformances(Collection<EndpointPerformance> endpointPerformances) {
            this.endpointPerformances = EndpointPerformancesCopier.copy(endpointPerformances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointPerformances(EndpointPerformance ... endpointPerformances) {
            this.endpointPerformances(Arrays.asList(endpointPerformances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointPerformances(Consumer<EndpointPerformance.Builder> ... endpointPerformances) {
            this.endpointPerformances(Stream.of(endpointPerformances).map(c -> (EndpointPerformance)((EndpointPerformance.Builder)EndpointPerformance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeInferenceRecommendationsJobResponse build() {
            return new DescribeInferenceRecommendationsJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInferenceRecommendationsJobResponse> {
        public Builder jobName(String var1);

        public Builder jobDescription(String var1);

        public Builder jobType(String var1);

        public Builder jobType(RecommendationJobType var1);

        public Builder jobArn(String var1);

        public Builder roleArn(String var1);

        public Builder status(String var1);

        public Builder status(RecommendationJobStatus var1);

        public Builder creationTime(Instant var1);

        public Builder completionTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder failureReason(String var1);

        public Builder inputConfig(RecommendationJobInputConfig var1);

        default public Builder inputConfig(Consumer<RecommendationJobInputConfig.Builder> inputConfig) {
            return this.inputConfig((RecommendationJobInputConfig)((RecommendationJobInputConfig.Builder)RecommendationJobInputConfig.builder().applyMutation(inputConfig)).build());
        }

        public Builder stoppingConditions(RecommendationJobStoppingConditions var1);

        default public Builder stoppingConditions(Consumer<RecommendationJobStoppingConditions.Builder> stoppingConditions) {
            return this.stoppingConditions((RecommendationJobStoppingConditions)((RecommendationJobStoppingConditions.Builder)RecommendationJobStoppingConditions.builder().applyMutation(stoppingConditions)).build());
        }

        public Builder inferenceRecommendations(Collection<InferenceRecommendation> var1);

        public Builder inferenceRecommendations(InferenceRecommendation ... var1);

        public Builder inferenceRecommendations(Consumer<InferenceRecommendation.Builder> ... var1);

        public Builder endpointPerformances(Collection<EndpointPerformance> var1);

        public Builder endpointPerformances(EndpointPerformance ... var1);

        public Builder endpointPerformances(Consumer<EndpointPerformance.Builder> ... var1);
    }
}

