/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AutoRollbackConfig;
import software.amazon.awssdk.services.sagemaker.model.BlueGreenUpdatePolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentConfig> {
    private static final SdkField<BlueGreenUpdatePolicy> BLUE_GREEN_UPDATE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BlueGreenUpdatePolicy").getter(DeploymentConfig.getter(DeploymentConfig::blueGreenUpdatePolicy)).setter(DeploymentConfig.setter(Builder::blueGreenUpdatePolicy)).constructor(BlueGreenUpdatePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueGreenUpdatePolicy").build()}).build();
    private static final SdkField<AutoRollbackConfig> AUTO_ROLLBACK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoRollbackConfiguration").getter(DeploymentConfig.getter(DeploymentConfig::autoRollbackConfiguration)).setter(DeploymentConfig.setter(Builder::autoRollbackConfiguration)).constructor(AutoRollbackConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRollbackConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUE_GREEN_UPDATE_POLICY_FIELD, AUTO_ROLLBACK_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final BlueGreenUpdatePolicy blueGreenUpdatePolicy;
    private final AutoRollbackConfig autoRollbackConfiguration;

    private DeploymentConfig(BuilderImpl builder) {
        this.blueGreenUpdatePolicy = builder.blueGreenUpdatePolicy;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
    }

    public final BlueGreenUpdatePolicy blueGreenUpdatePolicy() {
        return this.blueGreenUpdatePolicy;
    }

    public final AutoRollbackConfig autoRollbackConfiguration() {
        return this.autoRollbackConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blueGreenUpdatePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRollbackConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentConfig)) {
            return false;
        }
        DeploymentConfig other = (DeploymentConfig)obj;
        return Objects.equals(this.blueGreenUpdatePolicy(), other.blueGreenUpdatePolicy()) && Objects.equals(this.autoRollbackConfiguration(), other.autoRollbackConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentConfig").add("BlueGreenUpdatePolicy", (Object)this.blueGreenUpdatePolicy()).add("AutoRollbackConfiguration", (Object)this.autoRollbackConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlueGreenUpdatePolicy": {
                return Optional.ofNullable(clazz.cast(this.blueGreenUpdatePolicy()));
            }
            case "AutoRollbackConfiguration": {
                return Optional.ofNullable(clazz.cast(this.autoRollbackConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentConfig, T> g) {
        return obj -> g.apply((DeploymentConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BlueGreenUpdatePolicy blueGreenUpdatePolicy;
        private AutoRollbackConfig autoRollbackConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentConfig model) {
            this.blueGreenUpdatePolicy(model.blueGreenUpdatePolicy);
            this.autoRollbackConfiguration(model.autoRollbackConfiguration);
        }

        public final BlueGreenUpdatePolicy.Builder getBlueGreenUpdatePolicy() {
            return this.blueGreenUpdatePolicy != null ? this.blueGreenUpdatePolicy.toBuilder() : null;
        }

        public final void setBlueGreenUpdatePolicy(BlueGreenUpdatePolicy.BuilderImpl blueGreenUpdatePolicy) {
            this.blueGreenUpdatePolicy = blueGreenUpdatePolicy != null ? blueGreenUpdatePolicy.build() : null;
        }

        @Override
        public final Builder blueGreenUpdatePolicy(BlueGreenUpdatePolicy blueGreenUpdatePolicy) {
            this.blueGreenUpdatePolicy = blueGreenUpdatePolicy;
            return this;
        }

        public final AutoRollbackConfig.Builder getAutoRollbackConfiguration() {
            return this.autoRollbackConfiguration != null ? this.autoRollbackConfiguration.toBuilder() : null;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfig.BuilderImpl autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration != null ? autoRollbackConfiguration.build() : null;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfig autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public DeploymentConfig build() {
            return new DeploymentConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentConfig> {
        public Builder blueGreenUpdatePolicy(BlueGreenUpdatePolicy var1);

        default public Builder blueGreenUpdatePolicy(Consumer<BlueGreenUpdatePolicy.Builder> blueGreenUpdatePolicy) {
            return this.blueGreenUpdatePolicy((BlueGreenUpdatePolicy)((BlueGreenUpdatePolicy.Builder)BlueGreenUpdatePolicy.builder().applyMutation(blueGreenUpdatePolicy)).build());
        }

        public Builder autoRollbackConfiguration(AutoRollbackConfig var1);

        default public Builder autoRollbackConfiguration(Consumer<AutoRollbackConfig.Builder> autoRollbackConfiguration) {
            return this.autoRollbackConfiguration((AutoRollbackConfig)((AutoRollbackConfig.Builder)AutoRollbackConfig.builder().applyMutation(autoRollbackConfiguration)).build());
        }
    }
}

