/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.ImageClassificationJobConfig;
import software.amazon.awssdk.services.sagemaker.model.TextClassificationJobConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoMLProblemTypeConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoMLProblemTypeConfig> {
    private static final SdkField<ImageClassificationJobConfig> IMAGE_CLASSIFICATION_JOB_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImageClassificationJobConfig").getter(AutoMLProblemTypeConfig.getter(AutoMLProblemTypeConfig::imageClassificationJobConfig)).setter(AutoMLProblemTypeConfig.setter(Builder::imageClassificationJobConfig)).constructor(ImageClassificationJobConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageClassificationJobConfig").build()}).build();
    private static final SdkField<TextClassificationJobConfig> TEXT_CLASSIFICATION_JOB_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TextClassificationJobConfig").getter(AutoMLProblemTypeConfig.getter(AutoMLProblemTypeConfig::textClassificationJobConfig)).setter(AutoMLProblemTypeConfig.setter(Builder::textClassificationJobConfig)).constructor(TextClassificationJobConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextClassificationJobConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_CLASSIFICATION_JOB_CONFIG_FIELD, TEXT_CLASSIFICATION_JOB_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final ImageClassificationJobConfig imageClassificationJobConfig;
    private final TextClassificationJobConfig textClassificationJobConfig;
    private final Type type;

    private AutoMLProblemTypeConfig(BuilderImpl builder) {
        this.imageClassificationJobConfig = builder.imageClassificationJobConfig;
        this.textClassificationJobConfig = builder.textClassificationJobConfig;
        this.type = builder.type;
    }

    public final ImageClassificationJobConfig imageClassificationJobConfig() {
        return this.imageClassificationJobConfig;
    }

    public final TextClassificationJobConfig textClassificationJobConfig() {
        return this.textClassificationJobConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageClassificationJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.textClassificationJobConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLProblemTypeConfig)) {
            return false;
        }
        AutoMLProblemTypeConfig other = (AutoMLProblemTypeConfig)obj;
        return Objects.equals(this.imageClassificationJobConfig(), other.imageClassificationJobConfig()) && Objects.equals(this.textClassificationJobConfig(), other.textClassificationJobConfig());
    }

    public final String toString() {
        return ToString.builder((String)"AutoMLProblemTypeConfig").add("ImageClassificationJobConfig", (Object)this.imageClassificationJobConfig()).add("TextClassificationJobConfig", (Object)this.textClassificationJobConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageClassificationJobConfig": {
                return Optional.ofNullable(clazz.cast(this.imageClassificationJobConfig()));
            }
            case "TextClassificationJobConfig": {
                return Optional.ofNullable(clazz.cast(this.textClassificationJobConfig()));
            }
        }
        return Optional.empty();
    }

    public static AutoMLProblemTypeConfig fromImageClassificationJobConfig(ImageClassificationJobConfig imageClassificationJobConfig) {
        return (AutoMLProblemTypeConfig)AutoMLProblemTypeConfig.builder().imageClassificationJobConfig(imageClassificationJobConfig).build();
    }

    public static AutoMLProblemTypeConfig fromImageClassificationJobConfig(Consumer<ImageClassificationJobConfig.Builder> imageClassificationJobConfig) {
        ImageClassificationJobConfig.Builder builder = ImageClassificationJobConfig.builder();
        imageClassificationJobConfig.accept(builder);
        return AutoMLProblemTypeConfig.fromImageClassificationJobConfig((ImageClassificationJobConfig)builder.build());
    }

    public static AutoMLProblemTypeConfig fromTextClassificationJobConfig(TextClassificationJobConfig textClassificationJobConfig) {
        return (AutoMLProblemTypeConfig)AutoMLProblemTypeConfig.builder().textClassificationJobConfig(textClassificationJobConfig).build();
    }

    public static AutoMLProblemTypeConfig fromTextClassificationJobConfig(Consumer<TextClassificationJobConfig.Builder> textClassificationJobConfig) {
        TextClassificationJobConfig.Builder builder = TextClassificationJobConfig.builder();
        textClassificationJobConfig.accept(builder);
        return AutoMLProblemTypeConfig.fromTextClassificationJobConfig((TextClassificationJobConfig)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLProblemTypeConfig, T> g) {
        return obj -> g.apply((AutoMLProblemTypeConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        IMAGE_CLASSIFICATION_JOB_CONFIG,
        TEXT_CLASSIFICATION_JOB_CONFIG,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ImageClassificationJobConfig imageClassificationJobConfig;
        private TextClassificationJobConfig textClassificationJobConfig;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLProblemTypeConfig model) {
            this.imageClassificationJobConfig(model.imageClassificationJobConfig);
            this.textClassificationJobConfig(model.textClassificationJobConfig);
        }

        public final ImageClassificationJobConfig.Builder getImageClassificationJobConfig() {
            return this.imageClassificationJobConfig != null ? this.imageClassificationJobConfig.toBuilder() : null;
        }

        public final void setImageClassificationJobConfig(ImageClassificationJobConfig.BuilderImpl imageClassificationJobConfig) {
            ImageClassificationJobConfig oldValue = this.imageClassificationJobConfig;
            this.imageClassificationJobConfig = imageClassificationJobConfig != null ? imageClassificationJobConfig.build() : null;
            this.handleUnionValueChange(Type.IMAGE_CLASSIFICATION_JOB_CONFIG, oldValue, this.imageClassificationJobConfig);
        }

        @Override
        public final Builder imageClassificationJobConfig(ImageClassificationJobConfig imageClassificationJobConfig) {
            ImageClassificationJobConfig oldValue = this.imageClassificationJobConfig;
            this.imageClassificationJobConfig = imageClassificationJobConfig;
            this.handleUnionValueChange(Type.IMAGE_CLASSIFICATION_JOB_CONFIG, oldValue, this.imageClassificationJobConfig);
            return this;
        }

        public final TextClassificationJobConfig.Builder getTextClassificationJobConfig() {
            return this.textClassificationJobConfig != null ? this.textClassificationJobConfig.toBuilder() : null;
        }

        public final void setTextClassificationJobConfig(TextClassificationJobConfig.BuilderImpl textClassificationJobConfig) {
            TextClassificationJobConfig oldValue = this.textClassificationJobConfig;
            this.textClassificationJobConfig = textClassificationJobConfig != null ? textClassificationJobConfig.build() : null;
            this.handleUnionValueChange(Type.TEXT_CLASSIFICATION_JOB_CONFIG, oldValue, this.textClassificationJobConfig);
        }

        @Override
        public final Builder textClassificationJobConfig(TextClassificationJobConfig textClassificationJobConfig) {
            TextClassificationJobConfig oldValue = this.textClassificationJobConfig;
            this.textClassificationJobConfig = textClassificationJobConfig;
            this.handleUnionValueChange(Type.TEXT_CLASSIFICATION_JOB_CONFIG, oldValue, this.textClassificationJobConfig);
            return this;
        }

        public AutoMLProblemTypeConfig build() {
            return new AutoMLProblemTypeConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoMLProblemTypeConfig> {
        public Builder imageClassificationJobConfig(ImageClassificationJobConfig var1);

        default public Builder imageClassificationJobConfig(Consumer<ImageClassificationJobConfig.Builder> imageClassificationJobConfig) {
            return this.imageClassificationJobConfig((ImageClassificationJobConfig)((ImageClassificationJobConfig.Builder)ImageClassificationJobConfig.builder().applyMutation(imageClassificationJobConfig)).build());
        }

        public Builder textClassificationJobConfig(TextClassificationJobConfig var1);

        default public Builder textClassificationJobConfig(Consumer<TextClassificationJobConfig.Builder> textClassificationJobConfig) {
            return this.textClassificationJobConfig((TextClassificationJobConfig)((TextClassificationJobConfig.Builder)TextClassificationJobConfig.builder().applyMutation(textClassificationJobConfig)).build());
        }
    }
}

