/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobSummary;

public class ListTrainingJobsIterable
implements SdkIterable<ListTrainingJobsResponse> {
    private final SageMakerClient client;
    private final ListTrainingJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTrainingJobsIterable(SageMakerClient client, ListTrainingJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTrainingJobsResponseFetcher();
    }

    public Iterator<ListTrainingJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TrainingJobSummary> trainingJobSummaries() {
        Function<ListTrainingJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trainingJobSummaries() != null) {
                return response.trainingJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTrainingJobsResponseFetcher
    implements SyncPageFetcher<ListTrainingJobsResponse> {
        private ListTrainingJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrainingJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTrainingJobsResponse nextPage(ListTrainingJobsResponse previousPage) {
            if (previousPage == null) {
                return ListTrainingJobsIterable.this.client.listTrainingJobs(ListTrainingJobsIterable.this.firstRequest);
            }
            return ListTrainingJobsIterable.this.client.listTrainingJobs((ListTrainingJobsRequest)((Object)ListTrainingJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

