/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantAcceleratorType;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantCoreDumpConfig;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantServerlessConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProductionVariant
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProductionVariant> {
    private static final SdkField<String> VARIANT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VariantName").getter(ProductionVariant.getter(ProductionVariant::variantName)).setter(ProductionVariant.setter(Builder::variantName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariantName").build()}).build();
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(ProductionVariant.getter(ProductionVariant::modelName)).setter(ProductionVariant.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<Integer> INITIAL_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InitialInstanceCount").getter(ProductionVariant.getter(ProductionVariant::initialInstanceCount)).setter(ProductionVariant.setter(Builder::initialInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialInstanceCount").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ProductionVariant.getter(ProductionVariant::instanceTypeAsString)).setter(ProductionVariant.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Float> INITIAL_VARIANT_WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("InitialVariantWeight").getter(ProductionVariant.getter(ProductionVariant::initialVariantWeight)).setter(ProductionVariant.setter(Builder::initialVariantWeight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialVariantWeight").build()}).build();
    private static final SdkField<String> ACCELERATOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceleratorType").getter(ProductionVariant.getter(ProductionVariant::acceleratorTypeAsString)).setter(ProductionVariant.setter(Builder::acceleratorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorType").build()}).build();
    private static final SdkField<ProductionVariantCoreDumpConfig> CORE_DUMP_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CoreDumpConfig").getter(ProductionVariant.getter(ProductionVariant::coreDumpConfig)).setter(ProductionVariant.setter(Builder::coreDumpConfig)).constructor(ProductionVariantCoreDumpConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreDumpConfig").build()}).build();
    private static final SdkField<ProductionVariantServerlessConfig> SERVERLESS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServerlessConfig").getter(ProductionVariant.getter(ProductionVariant::serverlessConfig)).setter(ProductionVariant.setter(Builder::serverlessConfig)).constructor(ProductionVariantServerlessConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessConfig").build()}).build();
    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VolumeSizeInGB").getter(ProductionVariant.getter(ProductionVariant::volumeSizeInGB)).setter(ProductionVariant.setter(Builder::volumeSizeInGB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInGB").build()}).build();
    private static final SdkField<Integer> MODEL_DATA_DOWNLOAD_TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ModelDataDownloadTimeoutInSeconds").getter(ProductionVariant.getter(ProductionVariant::modelDataDownloadTimeoutInSeconds)).setter(ProductionVariant.setter(Builder::modelDataDownloadTimeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDataDownloadTimeoutInSeconds").build()}).build();
    private static final SdkField<Integer> CONTAINER_STARTUP_HEALTH_CHECK_TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ContainerStartupHealthCheckTimeoutInSeconds").getter(ProductionVariant.getter(ProductionVariant::containerStartupHealthCheckTimeoutInSeconds)).setter(ProductionVariant.setter(Builder::containerStartupHealthCheckTimeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerStartupHealthCheckTimeoutInSeconds").build()}).build();
    private static final SdkField<Boolean> ENABLE_SSM_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableSSMAccess").getter(ProductionVariant.getter(ProductionVariant::enableSSMAccess)).setter(ProductionVariant.setter(Builder::enableSSMAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableSSMAccess").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIANT_NAME_FIELD, MODEL_NAME_FIELD, INITIAL_INSTANCE_COUNT_FIELD, INSTANCE_TYPE_FIELD, INITIAL_VARIANT_WEIGHT_FIELD, ACCELERATOR_TYPE_FIELD, CORE_DUMP_CONFIG_FIELD, SERVERLESS_CONFIG_FIELD, VOLUME_SIZE_IN_GB_FIELD, MODEL_DATA_DOWNLOAD_TIMEOUT_IN_SECONDS_FIELD, CONTAINER_STARTUP_HEALTH_CHECK_TIMEOUT_IN_SECONDS_FIELD, ENABLE_SSM_ACCESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String variantName;
    private final String modelName;
    private final Integer initialInstanceCount;
    private final String instanceType;
    private final Float initialVariantWeight;
    private final String acceleratorType;
    private final ProductionVariantCoreDumpConfig coreDumpConfig;
    private final ProductionVariantServerlessConfig serverlessConfig;
    private final Integer volumeSizeInGB;
    private final Integer modelDataDownloadTimeoutInSeconds;
    private final Integer containerStartupHealthCheckTimeoutInSeconds;
    private final Boolean enableSSMAccess;

    private ProductionVariant(BuilderImpl builder) {
        this.variantName = builder.variantName;
        this.modelName = builder.modelName;
        this.initialInstanceCount = builder.initialInstanceCount;
        this.instanceType = builder.instanceType;
        this.initialVariantWeight = builder.initialVariantWeight;
        this.acceleratorType = builder.acceleratorType;
        this.coreDumpConfig = builder.coreDumpConfig;
        this.serverlessConfig = builder.serverlessConfig;
        this.volumeSizeInGB = builder.volumeSizeInGB;
        this.modelDataDownloadTimeoutInSeconds = builder.modelDataDownloadTimeoutInSeconds;
        this.containerStartupHealthCheckTimeoutInSeconds = builder.containerStartupHealthCheckTimeoutInSeconds;
        this.enableSSMAccess = builder.enableSSMAccess;
    }

    public final String variantName() {
        return this.variantName;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final Integer initialInstanceCount() {
        return this.initialInstanceCount;
    }

    public final ProductionVariantInstanceType instanceType() {
        return ProductionVariantInstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Float initialVariantWeight() {
        return this.initialVariantWeight;
    }

    public final ProductionVariantAcceleratorType acceleratorType() {
        return ProductionVariantAcceleratorType.fromValue(this.acceleratorType);
    }

    public final String acceleratorTypeAsString() {
        return this.acceleratorType;
    }

    public final ProductionVariantCoreDumpConfig coreDumpConfig() {
        return this.coreDumpConfig;
    }

    public final ProductionVariantServerlessConfig serverlessConfig() {
        return this.serverlessConfig;
    }

    public final Integer volumeSizeInGB() {
        return this.volumeSizeInGB;
    }

    public final Integer modelDataDownloadTimeoutInSeconds() {
        return this.modelDataDownloadTimeoutInSeconds;
    }

    public final Integer containerStartupHealthCheckTimeoutInSeconds() {
        return this.containerStartupHealthCheckTimeoutInSeconds;
    }

    public final Boolean enableSSMAccess() {
        return this.enableSSMAccess;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.variantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialVariantWeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreDumpConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverlessConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDataDownloadTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerStartupHealthCheckTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableSSMAccess());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductionVariant)) {
            return false;
        }
        ProductionVariant other = (ProductionVariant)obj;
        return Objects.equals(this.variantName(), other.variantName()) && Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.initialInstanceCount(), other.initialInstanceCount()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.initialVariantWeight(), other.initialVariantWeight()) && Objects.equals(this.acceleratorTypeAsString(), other.acceleratorTypeAsString()) && Objects.equals(this.coreDumpConfig(), other.coreDumpConfig()) && Objects.equals(this.serverlessConfig(), other.serverlessConfig()) && Objects.equals(this.volumeSizeInGB(), other.volumeSizeInGB()) && Objects.equals(this.modelDataDownloadTimeoutInSeconds(), other.modelDataDownloadTimeoutInSeconds()) && Objects.equals(this.containerStartupHealthCheckTimeoutInSeconds(), other.containerStartupHealthCheckTimeoutInSeconds()) && Objects.equals(this.enableSSMAccess(), other.enableSSMAccess());
    }

    public final String toString() {
        return ToString.builder((String)"ProductionVariant").add("VariantName", (Object)this.variantName()).add("ModelName", (Object)this.modelName()).add("InitialInstanceCount", (Object)this.initialInstanceCount()).add("InstanceType", (Object)this.instanceTypeAsString()).add("InitialVariantWeight", (Object)this.initialVariantWeight()).add("AcceleratorType", (Object)this.acceleratorTypeAsString()).add("CoreDumpConfig", (Object)this.coreDumpConfig()).add("ServerlessConfig", (Object)this.serverlessConfig()).add("VolumeSizeInGB", (Object)this.volumeSizeInGB()).add("ModelDataDownloadTimeoutInSeconds", (Object)this.modelDataDownloadTimeoutInSeconds()).add("ContainerStartupHealthCheckTimeoutInSeconds", (Object)this.containerStartupHealthCheckTimeoutInSeconds()).add("EnableSSMAccess", (Object)this.enableSSMAccess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VariantName": {
                return Optional.ofNullable(clazz.cast(this.variantName()));
            }
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "InitialInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.initialInstanceCount()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "InitialVariantWeight": {
                return Optional.ofNullable(clazz.cast(this.initialVariantWeight()));
            }
            case "AcceleratorType": {
                return Optional.ofNullable(clazz.cast(this.acceleratorTypeAsString()));
            }
            case "CoreDumpConfig": {
                return Optional.ofNullable(clazz.cast(this.coreDumpConfig()));
            }
            case "ServerlessConfig": {
                return Optional.ofNullable(clazz.cast(this.serverlessConfig()));
            }
            case "VolumeSizeInGB": {
                return Optional.ofNullable(clazz.cast(this.volumeSizeInGB()));
            }
            case "ModelDataDownloadTimeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.modelDataDownloadTimeoutInSeconds()));
            }
            case "ContainerStartupHealthCheckTimeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.containerStartupHealthCheckTimeoutInSeconds()));
            }
            case "EnableSSMAccess": {
                return Optional.ofNullable(clazz.cast(this.enableSSMAccess()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProductionVariant, T> g) {
        return obj -> g.apply((ProductionVariant)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String variantName;
        private String modelName;
        private Integer initialInstanceCount;
        private String instanceType;
        private Float initialVariantWeight;
        private String acceleratorType;
        private ProductionVariantCoreDumpConfig coreDumpConfig;
        private ProductionVariantServerlessConfig serverlessConfig;
        private Integer volumeSizeInGB;
        private Integer modelDataDownloadTimeoutInSeconds;
        private Integer containerStartupHealthCheckTimeoutInSeconds;
        private Boolean enableSSMAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductionVariant model) {
            this.variantName(model.variantName);
            this.modelName(model.modelName);
            this.initialInstanceCount(model.initialInstanceCount);
            this.instanceType(model.instanceType);
            this.initialVariantWeight(model.initialVariantWeight);
            this.acceleratorType(model.acceleratorType);
            this.coreDumpConfig(model.coreDumpConfig);
            this.serverlessConfig(model.serverlessConfig);
            this.volumeSizeInGB(model.volumeSizeInGB);
            this.modelDataDownloadTimeoutInSeconds(model.modelDataDownloadTimeoutInSeconds);
            this.containerStartupHealthCheckTimeoutInSeconds(model.containerStartupHealthCheckTimeoutInSeconds);
            this.enableSSMAccess(model.enableSSMAccess);
        }

        public final String getVariantName() {
            return this.variantName;
        }

        public final void setVariantName(String variantName) {
            this.variantName = variantName;
        }

        @Override
        public final Builder variantName(String variantName) {
            this.variantName = variantName;
            return this;
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final Integer getInitialInstanceCount() {
            return this.initialInstanceCount;
        }

        public final void setInitialInstanceCount(Integer initialInstanceCount) {
            this.initialInstanceCount = initialInstanceCount;
        }

        @Override
        public final Builder initialInstanceCount(Integer initialInstanceCount) {
            this.initialInstanceCount = initialInstanceCount;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ProductionVariantInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Float getInitialVariantWeight() {
            return this.initialVariantWeight;
        }

        public final void setInitialVariantWeight(Float initialVariantWeight) {
            this.initialVariantWeight = initialVariantWeight;
        }

        @Override
        public final Builder initialVariantWeight(Float initialVariantWeight) {
            this.initialVariantWeight = initialVariantWeight;
            return this;
        }

        public final String getAcceleratorType() {
            return this.acceleratorType;
        }

        public final void setAcceleratorType(String acceleratorType) {
            this.acceleratorType = acceleratorType;
        }

        @Override
        public final Builder acceleratorType(String acceleratorType) {
            this.acceleratorType = acceleratorType;
            return this;
        }

        @Override
        public final Builder acceleratorType(ProductionVariantAcceleratorType acceleratorType) {
            this.acceleratorType(acceleratorType == null ? null : acceleratorType.toString());
            return this;
        }

        public final ProductionVariantCoreDumpConfig.Builder getCoreDumpConfig() {
            return this.coreDumpConfig != null ? this.coreDumpConfig.toBuilder() : null;
        }

        public final void setCoreDumpConfig(ProductionVariantCoreDumpConfig.BuilderImpl coreDumpConfig) {
            this.coreDumpConfig = coreDumpConfig != null ? coreDumpConfig.build() : null;
        }

        @Override
        public final Builder coreDumpConfig(ProductionVariantCoreDumpConfig coreDumpConfig) {
            this.coreDumpConfig = coreDumpConfig;
            return this;
        }

        public final ProductionVariantServerlessConfig.Builder getServerlessConfig() {
            return this.serverlessConfig != null ? this.serverlessConfig.toBuilder() : null;
        }

        public final void setServerlessConfig(ProductionVariantServerlessConfig.BuilderImpl serverlessConfig) {
            this.serverlessConfig = serverlessConfig != null ? serverlessConfig.build() : null;
        }

        @Override
        public final Builder serverlessConfig(ProductionVariantServerlessConfig serverlessConfig) {
            this.serverlessConfig = serverlessConfig;
            return this;
        }

        public final Integer getVolumeSizeInGB() {
            return this.volumeSizeInGB;
        }

        public final void setVolumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
        }

        @Override
        public final Builder volumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
            return this;
        }

        public final Integer getModelDataDownloadTimeoutInSeconds() {
            return this.modelDataDownloadTimeoutInSeconds;
        }

        public final void setModelDataDownloadTimeoutInSeconds(Integer modelDataDownloadTimeoutInSeconds) {
            this.modelDataDownloadTimeoutInSeconds = modelDataDownloadTimeoutInSeconds;
        }

        @Override
        public final Builder modelDataDownloadTimeoutInSeconds(Integer modelDataDownloadTimeoutInSeconds) {
            this.modelDataDownloadTimeoutInSeconds = modelDataDownloadTimeoutInSeconds;
            return this;
        }

        public final Integer getContainerStartupHealthCheckTimeoutInSeconds() {
            return this.containerStartupHealthCheckTimeoutInSeconds;
        }

        public final void setContainerStartupHealthCheckTimeoutInSeconds(Integer containerStartupHealthCheckTimeoutInSeconds) {
            this.containerStartupHealthCheckTimeoutInSeconds = containerStartupHealthCheckTimeoutInSeconds;
        }

        @Override
        public final Builder containerStartupHealthCheckTimeoutInSeconds(Integer containerStartupHealthCheckTimeoutInSeconds) {
            this.containerStartupHealthCheckTimeoutInSeconds = containerStartupHealthCheckTimeoutInSeconds;
            return this;
        }

        public final Boolean getEnableSSMAccess() {
            return this.enableSSMAccess;
        }

        public final void setEnableSSMAccess(Boolean enableSSMAccess) {
            this.enableSSMAccess = enableSSMAccess;
        }

        @Override
        public final Builder enableSSMAccess(Boolean enableSSMAccess) {
            this.enableSSMAccess = enableSSMAccess;
            return this;
        }

        public ProductionVariant build() {
            return new ProductionVariant(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProductionVariant> {
        public Builder variantName(String var1);

        public Builder modelName(String var1);

        public Builder initialInstanceCount(Integer var1);

        public Builder instanceType(String var1);

        public Builder instanceType(ProductionVariantInstanceType var1);

        public Builder initialVariantWeight(Float var1);

        public Builder acceleratorType(String var1);

        public Builder acceleratorType(ProductionVariantAcceleratorType var1);

        public Builder coreDumpConfig(ProductionVariantCoreDumpConfig var1);

        default public Builder coreDumpConfig(Consumer<ProductionVariantCoreDumpConfig.Builder> coreDumpConfig) {
            return this.coreDumpConfig((ProductionVariantCoreDumpConfig)((ProductionVariantCoreDumpConfig.Builder)ProductionVariantCoreDumpConfig.builder().applyMutation(coreDumpConfig)).build());
        }

        public Builder serverlessConfig(ProductionVariantServerlessConfig var1);

        default public Builder serverlessConfig(Consumer<ProductionVariantServerlessConfig.Builder> serverlessConfig) {
            return this.serverlessConfig((ProductionVariantServerlessConfig)((ProductionVariantServerlessConfig.Builder)ProductionVariantServerlessConfig.builder().applyMutation(serverlessConfig)).build());
        }

        public Builder volumeSizeInGB(Integer var1);

        public Builder modelDataDownloadTimeoutInSeconds(Integer var1);

        public Builder containerStartupHealthCheckTimeoutInSeconds(Integer var1);

        public Builder enableSSMAccess(Boolean var1);
    }
}

