/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BatchStrategy {
    MULTI_RECORD("MultiRecord"),
    SINGLE_RECORD("SingleRecord"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BatchStrategy> VALUE_MAP;
    private final String value;

    private BatchStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BatchStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BatchStrategy> knownValues() {
        EnumSet<BatchStrategy> knownValues = EnumSet.allOf(BatchStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BatchStrategy.class, BatchStrategy::toString);
    }
}

