/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelVariantStatus {
    CREATING("Creating"),
    UPDATING("Updating"),
    IN_SERVICE("InService"),
    DELETING("Deleting"),
    DELETED("Deleted"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelVariantStatus> VALUE_MAP;
    private final String value;

    private ModelVariantStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelVariantStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelVariantStatus> knownValues() {
        EnumSet<ModelVariantStatus> knownValues = EnumSet.allOf(ModelVariantStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelVariantStatus.class, ModelVariantStatus::toString);
    }
}

