/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupSummary;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListModelPackageGroupsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListModelPackageGroupsResponse> {
    private static final SdkField<List<ModelPackageGroupSummary>> MODEL_PACKAGE_GROUP_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModelPackageGroupSummaryList").getter(ListModelPackageGroupsResponse.getter(ListModelPackageGroupsResponse::modelPackageGroupSummaryList)).setter(ListModelPackageGroupsResponse.setter(Builder::modelPackageGroupSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelPackageGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListModelPackageGroupsResponse.getter(ListModelPackageGroupsResponse::nextToken)).setter(ListModelPackageGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_GROUP_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<ModelPackageGroupSummary> modelPackageGroupSummaryList;
    private final String nextToken;

    private ListModelPackageGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.modelPackageGroupSummaryList = builder.modelPackageGroupSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasModelPackageGroupSummaryList() {
        return this.modelPackageGroupSummaryList != null && !(this.modelPackageGroupSummaryList instanceof SdkAutoConstructList);
    }

    public final List<ModelPackageGroupSummary> modelPackageGroupSummaryList() {
        return this.modelPackageGroupSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelPackageGroupSummaryList() ? this.modelPackageGroupSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelPackageGroupsResponse)) {
            return false;
        }
        ListModelPackageGroupsResponse other = (ListModelPackageGroupsResponse)((Object)obj);
        return this.hasModelPackageGroupSummaryList() == other.hasModelPackageGroupSummaryList() && Objects.equals(this.modelPackageGroupSummaryList(), other.modelPackageGroupSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListModelPackageGroupsResponse").add("ModelPackageGroupSummaryList", this.hasModelPackageGroupSummaryList() ? this.modelPackageGroupSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelPackageGroupSummaryList": {
                return Optional.ofNullable(clazz.cast(this.modelPackageGroupSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListModelPackageGroupsResponse, T> g) {
        return obj -> g.apply((ListModelPackageGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<ModelPackageGroupSummary> modelPackageGroupSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelPackageGroupsResponse model) {
            super(model);
            this.modelPackageGroupSummaryList(model.modelPackageGroupSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<ModelPackageGroupSummary.Builder> getModelPackageGroupSummaryList() {
            List<ModelPackageGroupSummary.Builder> result = ModelPackageGroupSummaryListCopier.copyToBuilder(this.modelPackageGroupSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelPackageGroupSummaryList(Collection<ModelPackageGroupSummary.BuilderImpl> modelPackageGroupSummaryList) {
            this.modelPackageGroupSummaryList = ModelPackageGroupSummaryListCopier.copyFromBuilder(modelPackageGroupSummaryList);
        }

        @Override
        public final Builder modelPackageGroupSummaryList(Collection<ModelPackageGroupSummary> modelPackageGroupSummaryList) {
            this.modelPackageGroupSummaryList = ModelPackageGroupSummaryListCopier.copy(modelPackageGroupSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelPackageGroupSummaryList(ModelPackageGroupSummary ... modelPackageGroupSummaryList) {
            this.modelPackageGroupSummaryList(Arrays.asList(modelPackageGroupSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelPackageGroupSummaryList(Consumer<ModelPackageGroupSummary.Builder> ... modelPackageGroupSummaryList) {
            this.modelPackageGroupSummaryList(Stream.of(modelPackageGroupSummaryList).map(c -> (ModelPackageGroupSummary)((ModelPackageGroupSummary.Builder)ModelPackageGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListModelPackageGroupsResponse build() {
            return new ListModelPackageGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListModelPackageGroupsResponse> {
        public Builder modelPackageGroupSummaryList(Collection<ModelPackageGroupSummary> var1);

        public Builder modelPackageGroupSummaryList(ModelPackageGroupSummary ... var1);

        public Builder modelPackageGroupSummaryList(Consumer<ModelPackageGroupSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

