/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListResourceCatalogsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListResourceCatalogsResponse;
import software.amazon.awssdk.services.sagemaker.model.ResourceCatalog;

public class ListResourceCatalogsIterable
implements SdkIterable<ListResourceCatalogsResponse> {
    private final SageMakerClient client;
    private final ListResourceCatalogsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceCatalogsIterable(SageMakerClient client, ListResourceCatalogsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourceCatalogsResponseFetcher();
    }

    public Iterator<ListResourceCatalogsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceCatalog> resourceCatalogs() {
        Function<ListResourceCatalogsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceCatalogs() != null) {
                return response.resourceCatalogs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceCatalogsResponseFetcher
    implements SyncPageFetcher<ListResourceCatalogsResponse> {
        private ListResourceCatalogsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceCatalogsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceCatalogsResponse nextPage(ListResourceCatalogsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceCatalogsIterable.this.client.listResourceCatalogs(ListResourceCatalogsIterable.this.firstRequest);
            }
            return ListResourceCatalogsIterable.this.client.listResourceCatalogs((ListResourceCatalogsRequest)((Object)ListResourceCatalogsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

