/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackagesResponse;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageSummary;

public class ListModelPackagesIterable
implements SdkIterable<ListModelPackagesResponse> {
    private final SageMakerClient client;
    private final ListModelPackagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListModelPackagesIterable(SageMakerClient client, ListModelPackagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListModelPackagesResponseFetcher();
    }

    public Iterator<ListModelPackagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ModelPackageSummary> modelPackageSummaryList() {
        Function<ListModelPackagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.modelPackageSummaryList() != null) {
                return response.modelPackageSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListModelPackagesResponseFetcher
    implements SyncPageFetcher<ListModelPackagesResponse> {
        private ListModelPackagesResponseFetcher() {
        }

        public boolean hasNextPage(ListModelPackagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListModelPackagesResponse nextPage(ListModelPackagesResponse previousPage) {
            if (previousPage == null) {
                return ListModelPackagesIterable.this.client.listModelPackages(ListModelPackagesIterable.this.firstRequest);
            }
            return ListModelPackagesIterable.this.client.listModelPackages((ListModelPackagesRequest)((Object)ListModelPackagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

