/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.EndpointInfo;
import software.amazon.awssdk.services.sagemaker.model.EndpointInputConfiguration;
import software.amazon.awssdk.services.sagemaker.model.EndpointInputConfigurationsCopier;
import software.amazon.awssdk.services.sagemaker.model.EndpointsCopier;
import software.amazon.awssdk.services.sagemaker.model.RecommendationJobContainerConfig;
import software.amazon.awssdk.services.sagemaker.model.RecommendationJobResourceLimit;
import software.amazon.awssdk.services.sagemaker.model.RecommendationJobVpcConfig;
import software.amazon.awssdk.services.sagemaker.model.TrafficPattern;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationJobInputConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationJobInputConfig> {
    private static final SdkField<String> MODEL_PACKAGE_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageVersionArn").getter(RecommendationJobInputConfig.getter(RecommendationJobInputConfig::modelPackageVersionArn)).setter(RecommendationJobInputConfig.setter(Builder::modelPackageVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageVersionArn").build()}).build();
    private static final SdkField<Integer> JOB_DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("JobDurationInSeconds").getter(RecommendationJobInputConfig.getter(RecommendationJobInputConfig::jobDurationInSeconds)).setter(RecommendationJobInputConfig.setter(Builder::jobDurationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDurationInSeconds").build()}).build();
    private static final SdkField<TrafficPattern> TRAFFIC_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrafficPattern").getter(RecommendationJobInputConfig.getter(RecommendationJobInputConfig::trafficPattern)).setter(RecommendationJobInputConfig.setter(Builder::trafficPattern)).constructor(TrafficPattern::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPattern").build()}).build();
    private static final SdkField<RecommendationJobResourceLimit> RESOURCE_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceLimit").getter(RecommendationJobInputConfig.getter(RecommendationJobInputConfig::resourceLimit)).setter(RecommendationJobInputConfig.setter(Builder::resourceLimit)).constructor(RecommendationJobResourceLimit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceLimit").build()}).build();
    private static final SdkField<List<EndpointInputConfiguration>> ENDPOINT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EndpointConfigurations").getter(RecommendationJobInputConfig.getter(RecommendationJobInputConfig::endpointConfigurations)).setter(RecommendationJobInputConfig.setter(Builder::endpointConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VOLUME_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeKmsKeyId").getter(RecommendationJobInputConfig.getter(RecommendationJobInputConfig::volumeKmsKeyId)).setter(RecommendationJobInputConfig.setter(Builder::volumeKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeKmsKeyId").build()}).build();
    private static final SdkField<RecommendationJobContainerConfig> CONTAINER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContainerConfig").getter(RecommendationJobInputConfig.getter(RecommendationJobInputConfig::containerConfig)).setter(RecommendationJobInputConfig.setter(Builder::containerConfig)).constructor(RecommendationJobContainerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerConfig").build()}).build();
    private static final SdkField<List<EndpointInfo>> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Endpoints").getter(RecommendationJobInputConfig.getter(RecommendationJobInputConfig::endpoints)).setter(RecommendationJobInputConfig.setter(Builder::endpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RecommendationJobVpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(RecommendationJobInputConfig.getter(RecommendationJobInputConfig::vpcConfig)).setter(RecommendationJobInputConfig.setter(Builder::vpcConfig)).constructor(RecommendationJobVpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(RecommendationJobInputConfig.getter(RecommendationJobInputConfig::modelName)).setter(RecommendationJobInputConfig.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_VERSION_ARN_FIELD, JOB_DURATION_IN_SECONDS_FIELD, TRAFFIC_PATTERN_FIELD, RESOURCE_LIMIT_FIELD, ENDPOINT_CONFIGURATIONS_FIELD, VOLUME_KMS_KEY_ID_FIELD, CONTAINER_CONFIG_FIELD, ENDPOINTS_FIELD, VPC_CONFIG_FIELD, MODEL_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String modelPackageVersionArn;
    private final Integer jobDurationInSeconds;
    private final TrafficPattern trafficPattern;
    private final RecommendationJobResourceLimit resourceLimit;
    private final List<EndpointInputConfiguration> endpointConfigurations;
    private final String volumeKmsKeyId;
    private final RecommendationJobContainerConfig containerConfig;
    private final List<EndpointInfo> endpoints;
    private final RecommendationJobVpcConfig vpcConfig;
    private final String modelName;

    private RecommendationJobInputConfig(BuilderImpl builder) {
        this.modelPackageVersionArn = builder.modelPackageVersionArn;
        this.jobDurationInSeconds = builder.jobDurationInSeconds;
        this.trafficPattern = builder.trafficPattern;
        this.resourceLimit = builder.resourceLimit;
        this.endpointConfigurations = builder.endpointConfigurations;
        this.volumeKmsKeyId = builder.volumeKmsKeyId;
        this.containerConfig = builder.containerConfig;
        this.endpoints = builder.endpoints;
        this.vpcConfig = builder.vpcConfig;
        this.modelName = builder.modelName;
    }

    public final String modelPackageVersionArn() {
        return this.modelPackageVersionArn;
    }

    public final Integer jobDurationInSeconds() {
        return this.jobDurationInSeconds;
    }

    public final TrafficPattern trafficPattern() {
        return this.trafficPattern;
    }

    public final RecommendationJobResourceLimit resourceLimit() {
        return this.resourceLimit;
    }

    public final boolean hasEndpointConfigurations() {
        return this.endpointConfigurations != null && !(this.endpointConfigurations instanceof SdkAutoConstructList);
    }

    public final List<EndpointInputConfiguration> endpointConfigurations() {
        return this.endpointConfigurations;
    }

    public final String volumeKmsKeyId() {
        return this.volumeKmsKeyId;
    }

    public final RecommendationJobContainerConfig containerConfig() {
        return this.containerConfig;
    }

    public final boolean hasEndpoints() {
        return this.endpoints != null && !(this.endpoints instanceof SdkAutoConstructList);
    }

    public final List<EndpointInfo> endpoints() {
        return this.endpoints;
    }

    public final RecommendationJobVpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final String modelName() {
        return this.modelName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpointConfigurations() ? this.endpointConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpoints() ? this.endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationJobInputConfig)) {
            return false;
        }
        RecommendationJobInputConfig other = (RecommendationJobInputConfig)obj;
        return Objects.equals(this.modelPackageVersionArn(), other.modelPackageVersionArn()) && Objects.equals(this.jobDurationInSeconds(), other.jobDurationInSeconds()) && Objects.equals(this.trafficPattern(), other.trafficPattern()) && Objects.equals(this.resourceLimit(), other.resourceLimit()) && this.hasEndpointConfigurations() == other.hasEndpointConfigurations() && Objects.equals(this.endpointConfigurations(), other.endpointConfigurations()) && Objects.equals(this.volumeKmsKeyId(), other.volumeKmsKeyId()) && Objects.equals(this.containerConfig(), other.containerConfig()) && this.hasEndpoints() == other.hasEndpoints() && Objects.equals(this.endpoints(), other.endpoints()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.modelName(), other.modelName());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationJobInputConfig").add("ModelPackageVersionArn", (Object)this.modelPackageVersionArn()).add("JobDurationInSeconds", (Object)this.jobDurationInSeconds()).add("TrafficPattern", (Object)this.trafficPattern()).add("ResourceLimit", (Object)this.resourceLimit()).add("EndpointConfigurations", this.hasEndpointConfigurations() ? this.endpointConfigurations() : null).add("VolumeKmsKeyId", (Object)this.volumeKmsKeyId()).add("ContainerConfig", (Object)this.containerConfig()).add("Endpoints", this.hasEndpoints() ? this.endpoints() : null).add("VpcConfig", (Object)this.vpcConfig()).add("ModelName", (Object)this.modelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelPackageVersionArn": {
                return Optional.ofNullable(clazz.cast(this.modelPackageVersionArn()));
            }
            case "JobDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.jobDurationInSeconds()));
            }
            case "TrafficPattern": {
                return Optional.ofNullable(clazz.cast(this.trafficPattern()));
            }
            case "ResourceLimit": {
                return Optional.ofNullable(clazz.cast(this.resourceLimit()));
            }
            case "EndpointConfigurations": {
                return Optional.ofNullable(clazz.cast(this.endpointConfigurations()));
            }
            case "VolumeKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.volumeKmsKeyId()));
            }
            case "ContainerConfig": {
                return Optional.ofNullable(clazz.cast(this.containerConfig()));
            }
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationJobInputConfig, T> g) {
        return obj -> g.apply((RecommendationJobInputConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelPackageVersionArn;
        private Integer jobDurationInSeconds;
        private TrafficPattern trafficPattern;
        private RecommendationJobResourceLimit resourceLimit;
        private List<EndpointInputConfiguration> endpointConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String volumeKmsKeyId;
        private RecommendationJobContainerConfig containerConfig;
        private List<EndpointInfo> endpoints = DefaultSdkAutoConstructList.getInstance();
        private RecommendationJobVpcConfig vpcConfig;
        private String modelName;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationJobInputConfig model) {
            this.modelPackageVersionArn(model.modelPackageVersionArn);
            this.jobDurationInSeconds(model.jobDurationInSeconds);
            this.trafficPattern(model.trafficPattern);
            this.resourceLimit(model.resourceLimit);
            this.endpointConfigurations(model.endpointConfigurations);
            this.volumeKmsKeyId(model.volumeKmsKeyId);
            this.containerConfig(model.containerConfig);
            this.endpoints(model.endpoints);
            this.vpcConfig(model.vpcConfig);
            this.modelName(model.modelName);
        }

        public final String getModelPackageVersionArn() {
            return this.modelPackageVersionArn;
        }

        public final void setModelPackageVersionArn(String modelPackageVersionArn) {
            this.modelPackageVersionArn = modelPackageVersionArn;
        }

        @Override
        public final Builder modelPackageVersionArn(String modelPackageVersionArn) {
            this.modelPackageVersionArn = modelPackageVersionArn;
            return this;
        }

        public final Integer getJobDurationInSeconds() {
            return this.jobDurationInSeconds;
        }

        public final void setJobDurationInSeconds(Integer jobDurationInSeconds) {
            this.jobDurationInSeconds = jobDurationInSeconds;
        }

        @Override
        public final Builder jobDurationInSeconds(Integer jobDurationInSeconds) {
            this.jobDurationInSeconds = jobDurationInSeconds;
            return this;
        }

        public final TrafficPattern.Builder getTrafficPattern() {
            return this.trafficPattern != null ? this.trafficPattern.toBuilder() : null;
        }

        public final void setTrafficPattern(TrafficPattern.BuilderImpl trafficPattern) {
            this.trafficPattern = trafficPattern != null ? trafficPattern.build() : null;
        }

        @Override
        public final Builder trafficPattern(TrafficPattern trafficPattern) {
            this.trafficPattern = trafficPattern;
            return this;
        }

        public final RecommendationJobResourceLimit.Builder getResourceLimit() {
            return this.resourceLimit != null ? this.resourceLimit.toBuilder() : null;
        }

        public final void setResourceLimit(RecommendationJobResourceLimit.BuilderImpl resourceLimit) {
            this.resourceLimit = resourceLimit != null ? resourceLimit.build() : null;
        }

        @Override
        public final Builder resourceLimit(RecommendationJobResourceLimit resourceLimit) {
            this.resourceLimit = resourceLimit;
            return this;
        }

        public final List<EndpointInputConfiguration.Builder> getEndpointConfigurations() {
            List<EndpointInputConfiguration.Builder> result = EndpointInputConfigurationsCopier.copyToBuilder(this.endpointConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpointConfigurations(Collection<EndpointInputConfiguration.BuilderImpl> endpointConfigurations) {
            this.endpointConfigurations = EndpointInputConfigurationsCopier.copyFromBuilder(endpointConfigurations);
        }

        @Override
        public final Builder endpointConfigurations(Collection<EndpointInputConfiguration> endpointConfigurations) {
            this.endpointConfigurations = EndpointInputConfigurationsCopier.copy(endpointConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointConfigurations(EndpointInputConfiguration ... endpointConfigurations) {
            this.endpointConfigurations(Arrays.asList(endpointConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointConfigurations(Consumer<EndpointInputConfiguration.Builder> ... endpointConfigurations) {
            this.endpointConfigurations(Stream.of(endpointConfigurations).map(c -> (EndpointInputConfiguration)((EndpointInputConfiguration.Builder)EndpointInputConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVolumeKmsKeyId() {
            return this.volumeKmsKeyId;
        }

        public final void setVolumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
        }

        @Override
        public final Builder volumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
            return this;
        }

        public final RecommendationJobContainerConfig.Builder getContainerConfig() {
            return this.containerConfig != null ? this.containerConfig.toBuilder() : null;
        }

        public final void setContainerConfig(RecommendationJobContainerConfig.BuilderImpl containerConfig) {
            this.containerConfig = containerConfig != null ? containerConfig.build() : null;
        }

        @Override
        public final Builder containerConfig(RecommendationJobContainerConfig containerConfig) {
            this.containerConfig = containerConfig;
            return this;
        }

        public final List<EndpointInfo.Builder> getEndpoints() {
            List<EndpointInfo.Builder> result = EndpointsCopier.copyToBuilder(this.endpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpoints(Collection<EndpointInfo.BuilderImpl> endpoints) {
            this.endpoints = EndpointsCopier.copyFromBuilder(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<EndpointInfo> endpoints) {
            this.endpoints = EndpointsCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(EndpointInfo ... endpoints) {
            this.endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<EndpointInfo.Builder> ... endpoints) {
            this.endpoints(Stream.of(endpoints).map(c -> (EndpointInfo)((EndpointInfo.Builder)EndpointInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RecommendationJobVpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(RecommendationJobVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(RecommendationJobVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public RecommendationJobInputConfig build() {
            return new RecommendationJobInputConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationJobInputConfig> {
        public Builder modelPackageVersionArn(String var1);

        public Builder jobDurationInSeconds(Integer var1);

        public Builder trafficPattern(TrafficPattern var1);

        default public Builder trafficPattern(Consumer<TrafficPattern.Builder> trafficPattern) {
            return this.trafficPattern((TrafficPattern)((TrafficPattern.Builder)TrafficPattern.builder().applyMutation(trafficPattern)).build());
        }

        public Builder resourceLimit(RecommendationJobResourceLimit var1);

        default public Builder resourceLimit(Consumer<RecommendationJobResourceLimit.Builder> resourceLimit) {
            return this.resourceLimit((RecommendationJobResourceLimit)((RecommendationJobResourceLimit.Builder)RecommendationJobResourceLimit.builder().applyMutation(resourceLimit)).build());
        }

        public Builder endpointConfigurations(Collection<EndpointInputConfiguration> var1);

        public Builder endpointConfigurations(EndpointInputConfiguration ... var1);

        public Builder endpointConfigurations(Consumer<EndpointInputConfiguration.Builder> ... var1);

        public Builder volumeKmsKeyId(String var1);

        public Builder containerConfig(RecommendationJobContainerConfig var1);

        default public Builder containerConfig(Consumer<RecommendationJobContainerConfig.Builder> containerConfig) {
            return this.containerConfig((RecommendationJobContainerConfig)((RecommendationJobContainerConfig.Builder)RecommendationJobContainerConfig.builder().applyMutation(containerConfig)).build());
        }

        public Builder endpoints(Collection<EndpointInfo> var1);

        public Builder endpoints(EndpointInfo ... var1);

        public Builder endpoints(Consumer<EndpointInfo.Builder> ... var1);

        public Builder vpcConfig(RecommendationJobVpcConfig var1);

        default public Builder vpcConfig(Consumer<RecommendationJobVpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((RecommendationJobVpcConfig)((RecommendationJobVpcConfig.Builder)RecommendationJobVpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder modelName(String var1);
    }
}

