/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Time to live duration, where the record is hard deleted after the expiration time is reached; <code>ExpiresAt</code>
 * = <code>EventTime</code> + <code>TtlDuration</code>. For information on HardDelete, see the <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html">DeleteRecord</a>
 * API in the Amazon SageMaker API Reference guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TtlDuration implements SdkPojo, Serializable, ToCopyableBuilder<TtlDuration.Builder, TtlDuration> {
    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(TtlDuration::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final SdkField<Integer> VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Value")
            .getter(getter(TtlDuration::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNIT_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String unit;

    private final Integer value;

    private TtlDuration(BuilderImpl builder) {
        this.unit = builder.unit;
        this.value = builder.value;
    }

    /**
     * <p>
     * <code>TtlDuration</code> time unit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link TtlDurationUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return <code>TtlDuration</code> time unit.
     * @see TtlDurationUnit
     */
    public final TtlDurationUnit unit() {
        return TtlDurationUnit.fromValue(unit);
    }

    /**
     * <p>
     * <code>TtlDuration</code> time unit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link TtlDurationUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return <code>TtlDuration</code> time unit.
     * @see TtlDurationUnit
     */
    public final String unitAsString() {
        return unit;
    }

    /**
     * <p>
     * <code>TtlDuration</code> time value.
     * </p>
     * 
     * @return <code>TtlDuration</code> time value.
     */
    public final Integer value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TtlDuration)) {
            return false;
        }
        TtlDuration other = (TtlDuration) obj;
        return Objects.equals(unitAsString(), other.unitAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TtlDuration").add("Unit", unitAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TtlDuration, T> g) {
        return obj -> g.apply((TtlDuration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TtlDuration> {
        /**
         * <p>
         * <code>TtlDuration</code> time unit.
         * </p>
         * 
         * @param unit
         *        <code>TtlDuration</code> time unit.
         * @see TtlDurationUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TtlDurationUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * <code>TtlDuration</code> time unit.
         * </p>
         * 
         * @param unit
         *        <code>TtlDuration</code> time unit.
         * @see TtlDurationUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TtlDurationUnit
         */
        Builder unit(TtlDurationUnit unit);

        /**
         * <p>
         * <code>TtlDuration</code> time value.
         * </p>
         * 
         * @param value
         *        <code>TtlDuration</code> time value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Integer value);
    }

    static final class BuilderImpl implements Builder {
        private String unit;

        private Integer value;

        private BuilderImpl() {
        }

        private BuilderImpl(TtlDuration model) {
            unit(model.unit);
            value(model.value);
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(TtlDurationUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final Integer getValue() {
            return value;
        }

        public final void setValue(Integer value) {
            this.value = value;
        }

        @Override
        public final Builder value(Integer value) {
            this.value = value;
            return this;
        }

        @Override
        public TtlDuration build() {
            return new TtlDuration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
