/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of an in-progress deployment when an endpoint is creating or updating with a new endpoint configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PendingDeploymentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<PendingDeploymentSummary.Builder, PendingDeploymentSummary> {
    private static final SdkField<String> ENDPOINT_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointConfigName").getter(getter(PendingDeploymentSummary::endpointConfigName))
            .setter(setter(Builder::endpointConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigName").build())
            .build();

    private static final SdkField<List<PendingProductionVariantSummary>> PRODUCTION_VARIANTS_FIELD = SdkField
            .<List<PendingProductionVariantSummary>> builder(MarshallingType.LIST)
            .memberName("ProductionVariants")
            .getter(getter(PendingDeploymentSummary::productionVariants))
            .setter(setter(Builder::productionVariants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductionVariants").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PendingProductionVariantSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PendingProductionVariantSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(PendingDeploymentSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<List<PendingProductionVariantSummary>> SHADOW_PRODUCTION_VARIANTS_FIELD = SdkField
            .<List<PendingProductionVariantSummary>> builder(MarshallingType.LIST)
            .memberName("ShadowProductionVariants")
            .getter(getter(PendingDeploymentSummary::shadowProductionVariants))
            .setter(setter(Builder::shadowProductionVariants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShadowProductionVariants").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PendingProductionVariantSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PendingProductionVariantSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_CONFIG_NAME_FIELD,
            PRODUCTION_VARIANTS_FIELD, START_TIME_FIELD, SHADOW_PRODUCTION_VARIANTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endpointConfigName;

    private final List<PendingProductionVariantSummary> productionVariants;

    private final Instant startTime;

    private final List<PendingProductionVariantSummary> shadowProductionVariants;

    private PendingDeploymentSummary(BuilderImpl builder) {
        this.endpointConfigName = builder.endpointConfigName;
        this.productionVariants = builder.productionVariants;
        this.startTime = builder.startTime;
        this.shadowProductionVariants = builder.shadowProductionVariants;
    }

    /**
     * <p>
     * The name of the endpoint configuration used in the deployment.
     * </p>
     * 
     * @return The name of the endpoint configuration used in the deployment.
     */
    public final String endpointConfigName() {
        return endpointConfigName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProductionVariants property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProductionVariants() {
        return productionVariants != null && !(productionVariants instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_PendingProductionVariantSummary.html"
     * >PendingProductionVariantSummary</a> objects, one for each model hosted behind this endpoint for the in-progress
     * deployment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductionVariants} method.
     * </p>
     * 
     * @return An array of <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_PendingProductionVariantSummary.html"
     *         >PendingProductionVariantSummary</a> objects, one for each model hosted behind this endpoint for the
     *         in-progress deployment.
     */
    public final List<PendingProductionVariantSummary> productionVariants() {
        return productionVariants;
    }

    /**
     * <p>
     * The start time of the deployment.
     * </p>
     * 
     * @return The start time of the deployment.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the ShadowProductionVariants property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasShadowProductionVariants() {
        return shadowProductionVariants != null && !(shadowProductionVariants instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_PendingProductionVariantSummary.html"
     * >PendingProductionVariantSummary</a> objects, one for each model hosted behind this endpoint in shadow mode with
     * production traffic replicated from the model specified on <code>ProductionVariants</code> for the in-progress
     * deployment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasShadowProductionVariants} method.
     * </p>
     * 
     * @return An array of <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_PendingProductionVariantSummary.html"
     *         >PendingProductionVariantSummary</a> objects, one for each model hosted behind this endpoint in shadow
     *         mode with production traffic replicated from the model specified on <code>ProductionVariants</code> for
     *         the in-progress deployment.
     */
    public final List<PendingProductionVariantSummary> shadowProductionVariants() {
        return shadowProductionVariants;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(hasProductionVariants() ? productionVariants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasShadowProductionVariants() ? shadowProductionVariants() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingDeploymentSummary)) {
            return false;
        }
        PendingDeploymentSummary other = (PendingDeploymentSummary) obj;
        return Objects.equals(endpointConfigName(), other.endpointConfigName())
                && hasProductionVariants() == other.hasProductionVariants()
                && Objects.equals(productionVariants(), other.productionVariants())
                && Objects.equals(startTime(), other.startTime())
                && hasShadowProductionVariants() == other.hasShadowProductionVariants()
                && Objects.equals(shadowProductionVariants(), other.shadowProductionVariants());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PendingDeploymentSummary").add("EndpointConfigName", endpointConfigName())
                .add("ProductionVariants", hasProductionVariants() ? productionVariants() : null).add("StartTime", startTime())
                .add("ShadowProductionVariants", hasShadowProductionVariants() ? shadowProductionVariants() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointConfigName":
            return Optional.ofNullable(clazz.cast(endpointConfigName()));
        case "ProductionVariants":
            return Optional.ofNullable(clazz.cast(productionVariants()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "ShadowProductionVariants":
            return Optional.ofNullable(clazz.cast(shadowProductionVariants()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PendingDeploymentSummary, T> g) {
        return obj -> g.apply((PendingDeploymentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PendingDeploymentSummary> {
        /**
         * <p>
         * The name of the endpoint configuration used in the deployment.
         * </p>
         * 
         * @param endpointConfigName
         *        The name of the endpoint configuration used in the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfigName(String endpointConfigName);

        /**
         * <p>
         * An array of <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_PendingProductionVariantSummary.html"
         * >PendingProductionVariantSummary</a> objects, one for each model hosted behind this endpoint for the
         * in-progress deployment.
         * </p>
         * 
         * @param productionVariants
         *        An array of <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_PendingProductionVariantSummary.html"
         *        >PendingProductionVariantSummary</a> objects, one for each model hosted behind this endpoint for the
         *        in-progress deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productionVariants(Collection<PendingProductionVariantSummary> productionVariants);

        /**
         * <p>
         * An array of <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_PendingProductionVariantSummary.html"
         * >PendingProductionVariantSummary</a> objects, one for each model hosted behind this endpoint for the
         * in-progress deployment.
         * </p>
         * 
         * @param productionVariants
         *        An array of <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_PendingProductionVariantSummary.html"
         *        >PendingProductionVariantSummary</a> objects, one for each model hosted behind this endpoint for the
         *        in-progress deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productionVariants(PendingProductionVariantSummary... productionVariants);

        /**
         * <p>
         * An array of <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_PendingProductionVariantSummary.html"
         * >PendingProductionVariantSummary</a> objects, one for each model hosted behind this endpoint for the
         * in-progress deployment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.PendingProductionVariantSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.PendingProductionVariantSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.PendingProductionVariantSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #productionVariants(List<PendingProductionVariantSummary>)}.
         * 
         * @param productionVariants
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.PendingProductionVariantSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productionVariants(java.util.Collection<PendingProductionVariantSummary>)
         */
        Builder productionVariants(Consumer<PendingProductionVariantSummary.Builder>... productionVariants);

        /**
         * <p>
         * The start time of the deployment.
         * </p>
         * 
         * @param startTime
         *        The start time of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * An array of <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_PendingProductionVariantSummary.html"
         * >PendingProductionVariantSummary</a> objects, one for each model hosted behind this endpoint in shadow mode
         * with production traffic replicated from the model specified on <code>ProductionVariants</code> for the
         * in-progress deployment.
         * </p>
         * 
         * @param shadowProductionVariants
         *        An array of <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_PendingProductionVariantSummary.html"
         *        >PendingProductionVariantSummary</a> objects, one for each model hosted behind this endpoint in shadow
         *        mode with production traffic replicated from the model specified on <code>ProductionVariants</code>
         *        for the in-progress deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shadowProductionVariants(Collection<PendingProductionVariantSummary> shadowProductionVariants);

        /**
         * <p>
         * An array of <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_PendingProductionVariantSummary.html"
         * >PendingProductionVariantSummary</a> objects, one for each model hosted behind this endpoint in shadow mode
         * with production traffic replicated from the model specified on <code>ProductionVariants</code> for the
         * in-progress deployment.
         * </p>
         * 
         * @param shadowProductionVariants
         *        An array of <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_PendingProductionVariantSummary.html"
         *        >PendingProductionVariantSummary</a> objects, one for each model hosted behind this endpoint in shadow
         *        mode with production traffic replicated from the model specified on <code>ProductionVariants</code>
         *        for the in-progress deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shadowProductionVariants(PendingProductionVariantSummary... shadowProductionVariants);

        /**
         * <p>
         * An array of <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_PendingProductionVariantSummary.html"
         * >PendingProductionVariantSummary</a> objects, one for each model hosted behind this endpoint in shadow mode
         * with production traffic replicated from the model specified on <code>ProductionVariants</code> for the
         * in-progress deployment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.PendingProductionVariantSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.PendingProductionVariantSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.PendingProductionVariantSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #shadowProductionVariants(List<PendingProductionVariantSummary>)}.
         * 
         * @param shadowProductionVariants
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.PendingProductionVariantSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shadowProductionVariants(java.util.Collection<PendingProductionVariantSummary>)
         */
        Builder shadowProductionVariants(Consumer<PendingProductionVariantSummary.Builder>... shadowProductionVariants);
    }

    static final class BuilderImpl implements Builder {
        private String endpointConfigName;

        private List<PendingProductionVariantSummary> productionVariants = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private List<PendingProductionVariantSummary> shadowProductionVariants = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PendingDeploymentSummary model) {
            endpointConfigName(model.endpointConfigName);
            productionVariants(model.productionVariants);
            startTime(model.startTime);
            shadowProductionVariants(model.shadowProductionVariants);
        }

        public final String getEndpointConfigName() {
            return endpointConfigName;
        }

        public final void setEndpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
        }

        @Override
        public final Builder endpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        public final List<PendingProductionVariantSummary.Builder> getProductionVariants() {
            List<PendingProductionVariantSummary.Builder> result = PendingProductionVariantSummaryListCopier
                    .copyToBuilder(this.productionVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductionVariants(Collection<PendingProductionVariantSummary.BuilderImpl> productionVariants) {
            this.productionVariants = PendingProductionVariantSummaryListCopier.copyFromBuilder(productionVariants);
        }

        @Override
        public final Builder productionVariants(Collection<PendingProductionVariantSummary> productionVariants) {
            this.productionVariants = PendingProductionVariantSummaryListCopier.copy(productionVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productionVariants(PendingProductionVariantSummary... productionVariants) {
            productionVariants(Arrays.asList(productionVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productionVariants(Consumer<PendingProductionVariantSummary.Builder>... productionVariants) {
            productionVariants(Stream.of(productionVariants)
                    .map(c -> PendingProductionVariantSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final List<PendingProductionVariantSummary.Builder> getShadowProductionVariants() {
            List<PendingProductionVariantSummary.Builder> result = PendingProductionVariantSummaryListCopier
                    .copyToBuilder(this.shadowProductionVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShadowProductionVariants(
                Collection<PendingProductionVariantSummary.BuilderImpl> shadowProductionVariants) {
            this.shadowProductionVariants = PendingProductionVariantSummaryListCopier.copyFromBuilder(shadowProductionVariants);
        }

        @Override
        public final Builder shadowProductionVariants(Collection<PendingProductionVariantSummary> shadowProductionVariants) {
            this.shadowProductionVariants = PendingProductionVariantSummaryListCopier.copy(shadowProductionVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shadowProductionVariants(PendingProductionVariantSummary... shadowProductionVariants) {
            shadowProductionVariants(Arrays.asList(shadowProductionVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shadowProductionVariants(
                Consumer<PendingProductionVariantSummary.Builder>... shadowProductionVariants) {
            shadowProductionVariants(Stream.of(shadowProductionVariants)
                    .map(c -> PendingProductionVariantSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PendingDeploymentSummary build() {
            return new PendingDeploymentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
