/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStageDevicesRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListStageDevicesRequest.Builder, ListStageDevicesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStageDevicesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListStageDevicesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> EDGE_DEPLOYMENT_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgeDeploymentPlanName").getter(getter(ListStageDevicesRequest::edgeDeploymentPlanName))
            .setter(setter(Builder::edgeDeploymentPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentPlanName").build())
            .build();

    private static final SdkField<Boolean> EXCLUDE_DEVICES_DEPLOYED_IN_OTHER_STAGE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExcludeDevicesDeployedInOtherStage")
            .getter(getter(ListStageDevicesRequest::excludeDevicesDeployedInOtherStage))
            .setter(setter(Builder::excludeDevicesDeployedInOtherStage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeDevicesDeployedInOtherStage")
                    .build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StageName").getter(getter(ListStageDevicesRequest::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, EDGE_DEPLOYMENT_PLAN_NAME_FIELD, EXCLUDE_DEVICES_DEPLOYED_IN_OTHER_STAGE_FIELD, STAGE_NAME_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final String edgeDeploymentPlanName;

    private final Boolean excludeDevicesDeployedInOtherStage;

    private final String stageName;

    private ListStageDevicesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.edgeDeploymentPlanName = builder.edgeDeploymentPlanName;
        this.excludeDevicesDeployedInOtherStage = builder.excludeDevicesDeployedInOtherStage;
        this.stageName = builder.stageName;
    }

    /**
     * <p>
     * The response from the last list when returning a list large enough to neeed tokening.
     * </p>
     * 
     * @return The response from the last list when returning a list large enough to neeed tokening.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of requests to select.
     * </p>
     * 
     * @return The maximum number of requests to select.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The name of the edge deployment plan.
     * </p>
     * 
     * @return The name of the edge deployment plan.
     */
    public final String edgeDeploymentPlanName() {
        return edgeDeploymentPlanName;
    }

    /**
     * <p>
     * Toggle for excluding devices deployed in other stages.
     * </p>
     * 
     * @return Toggle for excluding devices deployed in other stages.
     */
    public final Boolean excludeDevicesDeployedInOtherStage() {
        return excludeDevicesDeployedInOtherStage;
    }

    /**
     * <p>
     * The name of the stage in the deployment.
     * </p>
     * 
     * @return The name of the stage in the deployment.
     */
    public final String stageName() {
        return stageName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(edgeDeploymentPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(excludeDevicesDeployedInOtherStage());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStageDevicesRequest)) {
            return false;
        }
        ListStageDevicesRequest other = (ListStageDevicesRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(edgeDeploymentPlanName(), other.edgeDeploymentPlanName())
                && Objects.equals(excludeDevicesDeployedInOtherStage(), other.excludeDevicesDeployedInOtherStage())
                && Objects.equals(stageName(), other.stageName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStageDevicesRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("EdgeDeploymentPlanName", edgeDeploymentPlanName())
                .add("ExcludeDevicesDeployedInOtherStage", excludeDevicesDeployedInOtherStage()).add("StageName", stageName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "EdgeDeploymentPlanName":
            return Optional.ofNullable(clazz.cast(edgeDeploymentPlanName()));
        case "ExcludeDevicesDeployedInOtherStage":
            return Optional.ofNullable(clazz.cast(excludeDevicesDeployedInOtherStage()));
        case "StageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStageDevicesRequest, T> g) {
        return obj -> g.apply((ListStageDevicesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListStageDevicesRequest> {
        /**
         * <p>
         * The response from the last list when returning a list large enough to neeed tokening.
         * </p>
         * 
         * @param nextToken
         *        The response from the last list when returning a list large enough to neeed tokening.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of requests to select.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of requests to select.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The name of the edge deployment plan.
         * </p>
         * 
         * @param edgeDeploymentPlanName
         *        The name of the edge deployment plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeDeploymentPlanName(String edgeDeploymentPlanName);

        /**
         * <p>
         * Toggle for excluding devices deployed in other stages.
         * </p>
         * 
         * @param excludeDevicesDeployedInOtherStage
         *        Toggle for excluding devices deployed in other stages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeDevicesDeployedInOtherStage(Boolean excludeDevicesDeployedInOtherStage);

        /**
         * <p>
         * The name of the stage in the deployment.
         * </p>
         * 
         * @param stageName
         *        The name of the stage in the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String edgeDeploymentPlanName;

        private Boolean excludeDevicesDeployedInOtherStage;

        private String stageName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStageDevicesRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            edgeDeploymentPlanName(model.edgeDeploymentPlanName);
            excludeDevicesDeployedInOtherStage(model.excludeDevicesDeployedInOtherStage);
            stageName(model.stageName);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getEdgeDeploymentPlanName() {
            return edgeDeploymentPlanName;
        }

        public final void setEdgeDeploymentPlanName(String edgeDeploymentPlanName) {
            this.edgeDeploymentPlanName = edgeDeploymentPlanName;
        }

        @Override
        public final Builder edgeDeploymentPlanName(String edgeDeploymentPlanName) {
            this.edgeDeploymentPlanName = edgeDeploymentPlanName;
            return this;
        }

        public final Boolean getExcludeDevicesDeployedInOtherStage() {
            return excludeDevicesDeployedInOtherStage;
        }

        public final void setExcludeDevicesDeployedInOtherStage(Boolean excludeDevicesDeployedInOtherStage) {
            this.excludeDevicesDeployedInOtherStage = excludeDevicesDeployedInOtherStage;
        }

        @Override
        public final Builder excludeDevicesDeployedInOtherStage(Boolean excludeDevicesDeployedInOtherStage) {
            this.excludeDevicesDeployedInOtherStage = excludeDevicesDeployedInOtherStage;
            return this;
        }

        public final String getStageName() {
            return stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListStageDevicesRequest build() {
            return new ListStageDevicesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
