/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3outposts.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EndpointAccessType {
    PRIVATE("Private"),
    CUSTOMER_OWNED_IP("CustomerOwnedIp"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EndpointAccessType> VALUE_MAP;
    private final String value;

    private EndpointAccessType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EndpointAccessType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EndpointAccessType> knownValues() {
        EnumSet<EndpointAccessType> knownValues = EnumSet.allOf(EndpointAccessType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EndpointAccessType.class, EndpointAccessType::toString);
    }
}

