/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3outposts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3outposts.S3OutpostsAsyncClient;
import software.amazon.awssdk.services.s3outposts.model.ListOutpostsWithS3Request;
import software.amazon.awssdk.services.s3outposts.model.ListOutpostsWithS3Response;
import software.amazon.awssdk.services.s3outposts.model.Outpost;

public class ListOutpostsWithS3Publisher
implements SdkPublisher<ListOutpostsWithS3Response> {
    private final S3OutpostsAsyncClient client;
    private final ListOutpostsWithS3Request firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOutpostsWithS3Publisher(S3OutpostsAsyncClient client, ListOutpostsWithS3Request firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOutpostsWithS3Publisher(S3OutpostsAsyncClient client, ListOutpostsWithS3Request firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOutpostsWithS3ResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOutpostsWithS3Response> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Outpost> outposts() {
        Function<ListOutpostsWithS3Response, Iterator> getIterator = response -> {
            if (response != null && response.outposts() != null) {
                return response.outposts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOutpostsWithS3ResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOutpostsWithS3ResponseFetcher
    implements AsyncPageFetcher<ListOutpostsWithS3Response> {
        private ListOutpostsWithS3ResponseFetcher() {
        }

        public boolean hasNextPage(ListOutpostsWithS3Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOutpostsWithS3Response> nextPage(ListOutpostsWithS3Response previousPage) {
            if (previousPage == null) {
                return ListOutpostsWithS3Publisher.this.client.listOutpostsWithS3(ListOutpostsWithS3Publisher.this.firstRequest);
            }
            return ListOutpostsWithS3Publisher.this.client.listOutpostsWithS3((ListOutpostsWithS3Request)((Object)ListOutpostsWithS3Publisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

