/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlClient;
import software.amazon.awssdk.services.s3control.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsResponse;

public class ListAccessGrantsIterable
implements SdkIterable<ListAccessGrantsResponse> {
    private final S3ControlClient client;
    private final ListAccessGrantsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccessGrantsIterable(S3ControlClient client, ListAccessGrantsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccessGrantsResponseFetcher();
    }

    public Iterator<ListAccessGrantsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAccessGrantsResponseFetcher
    implements SyncPageFetcher<ListAccessGrantsResponse> {
        private ListAccessGrantsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessGrantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccessGrantsResponse nextPage(ListAccessGrantsResponse previousPage) {
            if (previousPage == null) {
                return ListAccessGrantsIterable.this.client.listAccessGrants(ListAccessGrantsIterable.this.firstRequest);
            }
            return ListAccessGrantsIterable.this.client.listAccessGrants((ListAccessGrantsRequest)((Object)ListAccessGrantsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

