/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccessGrantsLocationResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, GetAccessGrantsLocationResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetAccessGrantsLocationResponse.getter(GetAccessGrantsLocationResponse::createdAt)).setter(GetAccessGrantsLocationResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").unmarshallLocationName("CreatedAt").build()}).build();
    private static final SdkField<String> ACCESS_GRANTS_LOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessGrantsLocationId").getter(GetAccessGrantsLocationResponse.getter(GetAccessGrantsLocationResponse::accessGrantsLocationId)).setter(GetAccessGrantsLocationResponse.setter(Builder::accessGrantsLocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsLocationId").unmarshallLocationName("AccessGrantsLocationId").build()}).build();
    private static final SdkField<String> ACCESS_GRANTS_LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessGrantsLocationArn").getter(GetAccessGrantsLocationResponse.getter(GetAccessGrantsLocationResponse::accessGrantsLocationArn)).setter(GetAccessGrantsLocationResponse.setter(Builder::accessGrantsLocationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsLocationArn").unmarshallLocationName("AccessGrantsLocationArn").build()}).build();
    private static final SdkField<String> LOCATION_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationScope").getter(GetAccessGrantsLocationResponse.getter(GetAccessGrantsLocationResponse::locationScope)).setter(GetAccessGrantsLocationResponse.setter(Builder::locationScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationScope").unmarshallLocationName("LocationScope").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IAMRoleArn").getter(GetAccessGrantsLocationResponse.getter(GetAccessGrantsLocationResponse::iamRoleArn)).setter(GetAccessGrantsLocationResponse.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMRoleArn").unmarshallLocationName("IAMRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, ACCESS_GRANTS_LOCATION_ID_FIELD, ACCESS_GRANTS_LOCATION_ARN_FIELD, LOCATION_SCOPE_FIELD, IAM_ROLE_ARN_FIELD));
    private final Instant createdAt;
    private final String accessGrantsLocationId;
    private final String accessGrantsLocationArn;
    private final String locationScope;
    private final String iamRoleArn;

    private GetAccessGrantsLocationResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.accessGrantsLocationId = builder.accessGrantsLocationId;
        this.accessGrantsLocationArn = builder.accessGrantsLocationArn;
        this.locationScope = builder.locationScope;
        this.iamRoleArn = builder.iamRoleArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String accessGrantsLocationId() {
        return this.accessGrantsLocationId;
    }

    public final String accessGrantsLocationArn() {
        return this.accessGrantsLocationArn;
    }

    public final String locationScope() {
        return this.locationScope;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessGrantsLocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessGrantsLocationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessGrantsLocationResponse)) {
            return false;
        }
        GetAccessGrantsLocationResponse other = (GetAccessGrantsLocationResponse)((Object)obj);
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.accessGrantsLocationId(), other.accessGrantsLocationId()) && Objects.equals(this.accessGrantsLocationArn(), other.accessGrantsLocationArn()) && Objects.equals(this.locationScope(), other.locationScope()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccessGrantsLocationResponse").add("CreatedAt", (Object)this.createdAt()).add("AccessGrantsLocationId", (Object)this.accessGrantsLocationId()).add("AccessGrantsLocationArn", (Object)this.accessGrantsLocationArn()).add("LocationScope", (Object)this.locationScope()).add("IAMRoleArn", (Object)this.iamRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "AccessGrantsLocationId": {
                return Optional.ofNullable(clazz.cast(this.accessGrantsLocationId()));
            }
            case "AccessGrantsLocationArn": {
                return Optional.ofNullable(clazz.cast(this.accessGrantsLocationArn()));
            }
            case "LocationScope": {
                return Optional.ofNullable(clazz.cast(this.locationScope()));
            }
            case "IAMRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccessGrantsLocationResponse, T> g) {
        return obj -> g.apply((GetAccessGrantsLocationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String accessGrantsLocationId;
        private String accessGrantsLocationArn;
        private String locationScope;
        private String iamRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessGrantsLocationResponse model) {
            super(model);
            this.createdAt(model.createdAt);
            this.accessGrantsLocationId(model.accessGrantsLocationId);
            this.accessGrantsLocationArn(model.accessGrantsLocationArn);
            this.locationScope(model.locationScope);
            this.iamRoleArn(model.iamRoleArn);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getAccessGrantsLocationId() {
            return this.accessGrantsLocationId;
        }

        public final void setAccessGrantsLocationId(String accessGrantsLocationId) {
            this.accessGrantsLocationId = accessGrantsLocationId;
        }

        @Override
        public final Builder accessGrantsLocationId(String accessGrantsLocationId) {
            this.accessGrantsLocationId = accessGrantsLocationId;
            return this;
        }

        public final String getAccessGrantsLocationArn() {
            return this.accessGrantsLocationArn;
        }

        public final void setAccessGrantsLocationArn(String accessGrantsLocationArn) {
            this.accessGrantsLocationArn = accessGrantsLocationArn;
        }

        @Override
        public final Builder accessGrantsLocationArn(String accessGrantsLocationArn) {
            this.accessGrantsLocationArn = accessGrantsLocationArn;
            return this;
        }

        public final String getLocationScope() {
            return this.locationScope;
        }

        public final void setLocationScope(String locationScope) {
            this.locationScope = locationScope;
        }

        @Override
        public final Builder locationScope(String locationScope) {
            this.locationScope = locationScope;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        @Override
        public GetAccessGrantsLocationResponse build() {
            return new GetAccessGrantsLocationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccessGrantsLocationResponse> {
        public Builder createdAt(Instant var1);

        public Builder accessGrantsLocationId(String var1);

        public Builder accessGrantsLocationArn(String var1);

        public Builder locationScope(String var1);

        public Builder iamRoleArn(String var1);
    }
}

