/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlAsyncClient;
import software.amazon.awssdk.services.s3control.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsRequest;
import software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsResponse;

public class ListMultiRegionAccessPointsPublisher
implements SdkPublisher<ListMultiRegionAccessPointsResponse> {
    private final S3ControlAsyncClient client;
    private final ListMultiRegionAccessPointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMultiRegionAccessPointsPublisher(S3ControlAsyncClient client, ListMultiRegionAccessPointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMultiRegionAccessPointsPublisher(S3ControlAsyncClient client, ListMultiRegionAccessPointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMultiRegionAccessPointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMultiRegionAccessPointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListMultiRegionAccessPointsResponseFetcher
    implements AsyncPageFetcher<ListMultiRegionAccessPointsResponse> {
        private ListMultiRegionAccessPointsResponseFetcher() {
        }

        public boolean hasNextPage(ListMultiRegionAccessPointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMultiRegionAccessPointsResponse> nextPage(ListMultiRegionAccessPointsResponse previousPage) {
            if (previousPage == null) {
                return ListMultiRegionAccessPointsPublisher.this.client.listMultiRegionAccessPoints(ListMultiRegionAccessPointsPublisher.this.firstRequest);
            }
            return ListMultiRegionAccessPointsPublisher.this.client.listMultiRegionAccessPoints((ListMultiRegionAccessPointsRequest)((Object)ListMultiRegionAccessPointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

