/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPoint;
import software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPointListCopier;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccessPointsForObjectLambdaResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, ListAccessPointsForObjectLambdaResponse> {
    private static final SdkField<List<ObjectLambdaAccessPoint>> OBJECT_LAMBDA_ACCESS_POINT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ObjectLambdaAccessPointList").getter(ListAccessPointsForObjectLambdaResponse.getter(ListAccessPointsForObjectLambdaResponse::objectLambdaAccessPointList)).setter(ListAccessPointsForObjectLambdaResponse.setter(Builder::objectLambdaAccessPointList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectLambdaAccessPointList").unmarshallLocationName("ObjectLambdaAccessPointList").build(), ListTrait.builder().memberLocationName("ObjectLambdaAccessPoint").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ObjectLambdaAccessPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectLambdaAccessPoint").unmarshallLocationName("ObjectLambdaAccessPoint").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAccessPointsForObjectLambdaResponse.getter(ListAccessPointsForObjectLambdaResponse::nextToken)).setter(ListAccessPointsForObjectLambdaResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_LAMBDA_ACCESS_POINT_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<ObjectLambdaAccessPoint> objectLambdaAccessPointList;
    private final String nextToken;

    private ListAccessPointsForObjectLambdaResponse(BuilderImpl builder) {
        super(builder);
        this.objectLambdaAccessPointList = builder.objectLambdaAccessPointList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasObjectLambdaAccessPointList() {
        return this.objectLambdaAccessPointList != null && !(this.objectLambdaAccessPointList instanceof SdkAutoConstructList);
    }

    public final List<ObjectLambdaAccessPoint> objectLambdaAccessPointList() {
        return this.objectLambdaAccessPointList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasObjectLambdaAccessPointList() ? this.objectLambdaAccessPointList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessPointsForObjectLambdaResponse)) {
            return false;
        }
        ListAccessPointsForObjectLambdaResponse other = (ListAccessPointsForObjectLambdaResponse)((Object)obj);
        return this.hasObjectLambdaAccessPointList() == other.hasObjectLambdaAccessPointList() && Objects.equals(this.objectLambdaAccessPointList(), other.objectLambdaAccessPointList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAccessPointsForObjectLambdaResponse").add("ObjectLambdaAccessPointList", this.hasObjectLambdaAccessPointList() ? this.objectLambdaAccessPointList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectLambdaAccessPointList": {
                return Optional.ofNullable(clazz.cast(this.objectLambdaAccessPointList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccessPointsForObjectLambdaResponse, T> g) {
        return obj -> g.apply((ListAccessPointsForObjectLambdaResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private List<ObjectLambdaAccessPoint> objectLambdaAccessPointList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessPointsForObjectLambdaResponse model) {
            super(model);
            this.objectLambdaAccessPointList(model.objectLambdaAccessPointList);
            this.nextToken(model.nextToken);
        }

        public final List<ObjectLambdaAccessPoint.Builder> getObjectLambdaAccessPointList() {
            List<ObjectLambdaAccessPoint.Builder> result = ObjectLambdaAccessPointListCopier.copyToBuilder(this.objectLambdaAccessPointList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setObjectLambdaAccessPointList(Collection<ObjectLambdaAccessPoint.BuilderImpl> objectLambdaAccessPointList) {
            this.objectLambdaAccessPointList = ObjectLambdaAccessPointListCopier.copyFromBuilder(objectLambdaAccessPointList);
        }

        @Override
        public final Builder objectLambdaAccessPointList(Collection<ObjectLambdaAccessPoint> objectLambdaAccessPointList) {
            this.objectLambdaAccessPointList = ObjectLambdaAccessPointListCopier.copy(objectLambdaAccessPointList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectLambdaAccessPointList(ObjectLambdaAccessPoint ... objectLambdaAccessPointList) {
            this.objectLambdaAccessPointList(Arrays.asList(objectLambdaAccessPointList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectLambdaAccessPointList(Consumer<ObjectLambdaAccessPoint.Builder> ... objectLambdaAccessPointList) {
            this.objectLambdaAccessPointList(Stream.of(objectLambdaAccessPointList).map(c -> (ObjectLambdaAccessPoint)((ObjectLambdaAccessPoint.Builder)ObjectLambdaAccessPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAccessPointsForObjectLambdaResponse build() {
            return new ListAccessPointsForObjectLambdaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccessPointsForObjectLambdaResponse> {
        public Builder objectLambdaAccessPointList(Collection<ObjectLambdaAccessPoint> var1);

        public Builder objectLambdaAccessPointList(ObjectLambdaAccessPoint ... var1);

        public Builder objectLambdaAccessPointList(Consumer<ObjectLambdaAccessPoint.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

