/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubmitMultiRegionAccessPointRoutesRequest extends S3ControlRequest implements
        ToCopyableBuilder<SubmitMultiRegionAccessPointRoutesRequest.Builder, SubmitMultiRegionAccessPointRoutesRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(SubmitMultiRegionAccessPointRoutesRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id")
                    .unmarshallLocationName("x-amz-account-id").build()).build();

    private static final SdkField<String> MRAP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Mrap")
            .getter(getter(SubmitMultiRegionAccessPointRoutesRequest::mrap))
            .setter(setter(Builder::mrap))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("mrap")
                    .unmarshallLocationName("mrap").build()).build();

    private static final SdkField<List<MultiRegionAccessPointRoute>> ROUTE_UPDATES_FIELD = SdkField
            .<List<MultiRegionAccessPointRoute>> builder(MarshallingType.LIST)
            .memberName("RouteUpdates")
            .getter(getter(SubmitMultiRegionAccessPointRoutesRequest::routeUpdates))
            .setter(setter(Builder::routeUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteUpdates")
                    .unmarshallLocationName("RouteUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Route")
                            .memberFieldInfo(
                                    SdkField.<MultiRegionAccessPointRoute> builder(MarshallingType.SDK_POJO)
                                            .constructor(MultiRegionAccessPointRoute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Route").unmarshallLocationName("Route").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, MRAP_FIELD,
            ROUTE_UPDATES_FIELD));

    private final String accountId;

    private final String mrap;

    private final List<MultiRegionAccessPointRoute> routeUpdates;

    private SubmitMultiRegionAccessPointRoutesRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.mrap = builder.mrap;
        this.routeUpdates = builder.routeUpdates;
    }

    /**
     * <p>
     * The Amazon Web Services account ID for the owner of the Multi-Region Access Point.
     * </p>
     * 
     * @return The Amazon Web Services account ID for the owner of the Multi-Region Access Point.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The Multi-Region Access Point ARN.
     * </p>
     * 
     * @return The Multi-Region Access Point ARN.
     */
    public final String mrap() {
        return mrap;
    }

    /**
     * For responses, this returns true if the service returned a value for the RouteUpdates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRouteUpdates() {
        return routeUpdates != null && !(routeUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The different routes that make up the new route configuration. Active routes return a value of <code>100</code>,
     * and passive routes return a value of <code>0</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRouteUpdates} method.
     * </p>
     * 
     * @return The different routes that make up the new route configuration. Active routes return a value of
     *         <code>100</code>, and passive routes return a value of <code>0</code>.
     */
    public final List<MultiRegionAccessPointRoute> routeUpdates() {
        return routeUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(mrap());
        hashCode = 31 * hashCode + Objects.hashCode(hasRouteUpdates() ? routeUpdates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitMultiRegionAccessPointRoutesRequest)) {
            return false;
        }
        SubmitMultiRegionAccessPointRoutesRequest other = (SubmitMultiRegionAccessPointRoutesRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(mrap(), other.mrap())
                && hasRouteUpdates() == other.hasRouteUpdates() && Objects.equals(routeUpdates(), other.routeUpdates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubmitMultiRegionAccessPointRoutesRequest").add("AccountId", accountId()).add("Mrap", mrap())
                .add("RouteUpdates", hasRouteUpdates() ? routeUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Mrap":
            return Optional.ofNullable(clazz.cast(mrap()));
        case "RouteUpdates":
            return Optional.ofNullable(clazz.cast(routeUpdates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubmitMultiRegionAccessPointRoutesRequest, T> g) {
        return obj -> g.apply((SubmitMultiRegionAccessPointRoutesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SubmitMultiRegionAccessPointRoutesRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID for the owner of the Multi-Region Access Point.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID for the owner of the Multi-Region Access Point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The Multi-Region Access Point ARN.
         * </p>
         * 
         * @param mrap
         *        The Multi-Region Access Point ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mrap(String mrap);

        /**
         * <p>
         * The different routes that make up the new route configuration. Active routes return a value of
         * <code>100</code>, and passive routes return a value of <code>0</code>.
         * </p>
         * 
         * @param routeUpdates
         *        The different routes that make up the new route configuration. Active routes return a value of
         *        <code>100</code>, and passive routes return a value of <code>0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeUpdates(Collection<MultiRegionAccessPointRoute> routeUpdates);

        /**
         * <p>
         * The different routes that make up the new route configuration. Active routes return a value of
         * <code>100</code>, and passive routes return a value of <code>0</code>.
         * </p>
         * 
         * @param routeUpdates
         *        The different routes that make up the new route configuration. Active routes return a value of
         *        <code>100</code>, and passive routes return a value of <code>0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeUpdates(MultiRegionAccessPointRoute... routeUpdates);

        /**
         * <p>
         * The different routes that make up the new route configuration. Active routes return a value of
         * <code>100</code>, and passive routes return a value of <code>0</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointRoute.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointRoute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointRoute.Builder#build()} is called
         * immediately and its result is passed to {@link #routeUpdates(List<MultiRegionAccessPointRoute>)}.
         * 
         * @param routeUpdates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeUpdates(java.util.Collection<MultiRegionAccessPointRoute>)
         */
        Builder routeUpdates(Consumer<MultiRegionAccessPointRoute.Builder>... routeUpdates);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3ControlRequest.BuilderImpl implements Builder {
        private String accountId;

        private String mrap;

        private List<MultiRegionAccessPointRoute> routeUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitMultiRegionAccessPointRoutesRequest model) {
            super(model);
            accountId(model.accountId);
            mrap(model.mrap);
            routeUpdates(model.routeUpdates);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getMrap() {
            return mrap;
        }

        public final void setMrap(String mrap) {
            this.mrap = mrap;
        }

        @Override
        public final Builder mrap(String mrap) {
            this.mrap = mrap;
            return this;
        }

        public final List<MultiRegionAccessPointRoute.Builder> getRouteUpdates() {
            List<MultiRegionAccessPointRoute.Builder> result = RouteListCopier.copyToBuilder(this.routeUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteUpdates(Collection<MultiRegionAccessPointRoute.BuilderImpl> routeUpdates) {
            this.routeUpdates = RouteListCopier.copyFromBuilder(routeUpdates);
        }

        @Override
        public final Builder routeUpdates(Collection<MultiRegionAccessPointRoute> routeUpdates) {
            this.routeUpdates = RouteListCopier.copy(routeUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeUpdates(MultiRegionAccessPointRoute... routeUpdates) {
            routeUpdates(Arrays.asList(routeUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeUpdates(Consumer<MultiRegionAccessPointRoute.Builder>... routeUpdates) {
            routeUpdates(Stream.of(routeUpdates).map(c -> MultiRegionAccessPointRoute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubmitMultiRegionAccessPointRoutesRequest build() {
            return new SubmitMultiRegionAccessPointRoutesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
