/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.services.s3control.endpoints.S3ControlEndpointProvider;

/**
 * This includes configuration specific to AWS S3 Control that is supported by both {@link S3ControlClientBuilder} and
 * {@link S3ControlAsyncClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
public interface S3ControlBaseClientBuilder<B extends S3ControlBaseClientBuilder<B, C>, C> extends AwsClientBuilder<B, C> {
    B serviceConfiguration(S3ControlConfiguration serviceConfiguration);

    default B serviceConfiguration(Consumer<S3ControlConfiguration.Builder> serviceConfiguration) {
        return serviceConfiguration(S3ControlConfiguration.builder().applyMutation(serviceConfiguration).build());
    }

    /**
     * Set the {@link S3ControlEndpointProvider} implementation that will be used by the client to determine the
     * endpoint for each request. This is optional; if none is provided a default implementation will be used the SDK.
     */
    default B endpointProvider(S3ControlEndpointProvider endpointProvider) {
        throw new UnsupportedOperationException();
    }

    /**
     * Enables this client to use an ARN's region when constructing an endpoint instead of the client's configured
     * region.
     */
    B useArnRegion(Boolean useArnRegion);
}
