/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for the bucket-level configuration for Amazon S3 Storage Lens.
 * </p>
 * <p>
 * For more information about S3 Storage Lens, see <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html">Assessing your storage activity and
 * usage with S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BucketLevel implements SdkPojo, Serializable, ToCopyableBuilder<BucketLevel.Builder, BucketLevel> {
    private static final SdkField<ActivityMetrics> ACTIVITY_METRICS_FIELD = SdkField
            .<ActivityMetrics> builder(MarshallingType.SDK_POJO)
            .memberName("ActivityMetrics")
            .getter(getter(BucketLevel::activityMetrics))
            .setter(setter(Builder::activityMetrics))
            .constructor(ActivityMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityMetrics")
                    .unmarshallLocationName("ActivityMetrics").build()).build();

    private static final SdkField<PrefixLevel> PREFIX_LEVEL_FIELD = SdkField
            .<PrefixLevel> builder(MarshallingType.SDK_POJO)
            .memberName("PrefixLevel")
            .getter(getter(BucketLevel::prefixLevel))
            .setter(setter(Builder::prefixLevel))
            .constructor(PrefixLevel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixLevel")
                    .unmarshallLocationName("PrefixLevel").build()).build();

    private static final SdkField<AdvancedCostOptimizationMetrics> ADVANCED_COST_OPTIMIZATION_METRICS_FIELD = SdkField
            .<AdvancedCostOptimizationMetrics> builder(MarshallingType.SDK_POJO)
            .memberName("AdvancedCostOptimizationMetrics")
            .getter(getter(BucketLevel::advancedCostOptimizationMetrics))
            .setter(setter(Builder::advancedCostOptimizationMetrics))
            .constructor(AdvancedCostOptimizationMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedCostOptimizationMetrics")
                    .unmarshallLocationName("AdvancedCostOptimizationMetrics").build()).build();

    private static final SdkField<AdvancedDataProtectionMetrics> ADVANCED_DATA_PROTECTION_METRICS_FIELD = SdkField
            .<AdvancedDataProtectionMetrics> builder(MarshallingType.SDK_POJO)
            .memberName("AdvancedDataProtectionMetrics")
            .getter(getter(BucketLevel::advancedDataProtectionMetrics))
            .setter(setter(Builder::advancedDataProtectionMetrics))
            .constructor(AdvancedDataProtectionMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedDataProtectionMetrics")
                    .unmarshallLocationName("AdvancedDataProtectionMetrics").build()).build();

    private static final SdkField<DetailedStatusCodesMetrics> DETAILED_STATUS_CODES_METRICS_FIELD = SdkField
            .<DetailedStatusCodesMetrics> builder(MarshallingType.SDK_POJO)
            .memberName("DetailedStatusCodesMetrics")
            .getter(getter(BucketLevel::detailedStatusCodesMetrics))
            .setter(setter(Builder::detailedStatusCodesMetrics))
            .constructor(DetailedStatusCodesMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedStatusCodesMetrics")
                    .unmarshallLocationName("DetailedStatusCodesMetrics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_METRICS_FIELD,
            PREFIX_LEVEL_FIELD, ADVANCED_COST_OPTIMIZATION_METRICS_FIELD, ADVANCED_DATA_PROTECTION_METRICS_FIELD,
            DETAILED_STATUS_CODES_METRICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ActivityMetrics activityMetrics;

    private final PrefixLevel prefixLevel;

    private final AdvancedCostOptimizationMetrics advancedCostOptimizationMetrics;

    private final AdvancedDataProtectionMetrics advancedDataProtectionMetrics;

    private final DetailedStatusCodesMetrics detailedStatusCodesMetrics;

    private BucketLevel(BuilderImpl builder) {
        this.activityMetrics = builder.activityMetrics;
        this.prefixLevel = builder.prefixLevel;
        this.advancedCostOptimizationMetrics = builder.advancedCostOptimizationMetrics;
        this.advancedDataProtectionMetrics = builder.advancedDataProtectionMetrics;
        this.detailedStatusCodesMetrics = builder.detailedStatusCodesMetrics;
    }

    /**
     * <p>
     * A container for the bucket-level activity metrics for S3 Storage Lens.
     * </p>
     * 
     * @return A container for the bucket-level activity metrics for S3 Storage Lens.
     */
    public final ActivityMetrics activityMetrics() {
        return activityMetrics;
    }

    /**
     * <p>
     * A container for the prefix-level metrics for S3 Storage Lens.
     * </p>
     * 
     * @return A container for the prefix-level metrics for S3 Storage Lens.
     */
    public final PrefixLevel prefixLevel() {
        return prefixLevel;
    }

    /**
     * <p>
     * A container for bucket-level advanced cost-optimization metrics for S3 Storage Lens.
     * </p>
     * 
     * @return A container for bucket-level advanced cost-optimization metrics for S3 Storage Lens.
     */
    public final AdvancedCostOptimizationMetrics advancedCostOptimizationMetrics() {
        return advancedCostOptimizationMetrics;
    }

    /**
     * <p>
     * A container for bucket-level advanced data-protection metrics for S3 Storage Lens.
     * </p>
     * 
     * @return A container for bucket-level advanced data-protection metrics for S3 Storage Lens.
     */
    public final AdvancedDataProtectionMetrics advancedDataProtectionMetrics() {
        return advancedDataProtectionMetrics;
    }

    /**
     * <p>
     * A container for bucket-level detailed status code metrics for S3 Storage Lens.
     * </p>
     * 
     * @return A container for bucket-level detailed status code metrics for S3 Storage Lens.
     */
    public final DetailedStatusCodesMetrics detailedStatusCodesMetrics() {
        return detailedStatusCodesMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activityMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(prefixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(advancedCostOptimizationMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(advancedDataProtectionMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(detailedStatusCodesMetrics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketLevel)) {
            return false;
        }
        BucketLevel other = (BucketLevel) obj;
        return Objects.equals(activityMetrics(), other.activityMetrics()) && Objects.equals(prefixLevel(), other.prefixLevel())
                && Objects.equals(advancedCostOptimizationMetrics(), other.advancedCostOptimizationMetrics())
                && Objects.equals(advancedDataProtectionMetrics(), other.advancedDataProtectionMetrics())
                && Objects.equals(detailedStatusCodesMetrics(), other.detailedStatusCodesMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BucketLevel").add("ActivityMetrics", activityMetrics()).add("PrefixLevel", prefixLevel())
                .add("AdvancedCostOptimizationMetrics", advancedCostOptimizationMetrics())
                .add("AdvancedDataProtectionMetrics", advancedDataProtectionMetrics())
                .add("DetailedStatusCodesMetrics", detailedStatusCodesMetrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivityMetrics":
            return Optional.ofNullable(clazz.cast(activityMetrics()));
        case "PrefixLevel":
            return Optional.ofNullable(clazz.cast(prefixLevel()));
        case "AdvancedCostOptimizationMetrics":
            return Optional.ofNullable(clazz.cast(advancedCostOptimizationMetrics()));
        case "AdvancedDataProtectionMetrics":
            return Optional.ofNullable(clazz.cast(advancedDataProtectionMetrics()));
        case "DetailedStatusCodesMetrics":
            return Optional.ofNullable(clazz.cast(detailedStatusCodesMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BucketLevel, T> g) {
        return obj -> g.apply((BucketLevel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BucketLevel> {
        /**
         * <p>
         * A container for the bucket-level activity metrics for S3 Storage Lens.
         * </p>
         * 
         * @param activityMetrics
         *        A container for the bucket-level activity metrics for S3 Storage Lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityMetrics(ActivityMetrics activityMetrics);

        /**
         * <p>
         * A container for the bucket-level activity metrics for S3 Storage Lens.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActivityMetrics.Builder} avoiding the
         * need to create one manually via {@link ActivityMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActivityMetrics.Builder#build()} is called immediately and its
         * result is passed to {@link #activityMetrics(ActivityMetrics)}.
         * 
         * @param activityMetrics
         *        a consumer that will call methods on {@link ActivityMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activityMetrics(ActivityMetrics)
         */
        default Builder activityMetrics(Consumer<ActivityMetrics.Builder> activityMetrics) {
            return activityMetrics(ActivityMetrics.builder().applyMutation(activityMetrics).build());
        }

        /**
         * <p>
         * A container for the prefix-level metrics for S3 Storage Lens.
         * </p>
         * 
         * @param prefixLevel
         *        A container for the prefix-level metrics for S3 Storage Lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixLevel(PrefixLevel prefixLevel);

        /**
         * <p>
         * A container for the prefix-level metrics for S3 Storage Lens.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrefixLevel.Builder} avoiding the need to
         * create one manually via {@link PrefixLevel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrefixLevel.Builder#build()} is called immediately and its result
         * is passed to {@link #prefixLevel(PrefixLevel)}.
         * 
         * @param prefixLevel
         *        a consumer that will call methods on {@link PrefixLevel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prefixLevel(PrefixLevel)
         */
        default Builder prefixLevel(Consumer<PrefixLevel.Builder> prefixLevel) {
            return prefixLevel(PrefixLevel.builder().applyMutation(prefixLevel).build());
        }

        /**
         * <p>
         * A container for bucket-level advanced cost-optimization metrics for S3 Storage Lens.
         * </p>
         * 
         * @param advancedCostOptimizationMetrics
         *        A container for bucket-level advanced cost-optimization metrics for S3 Storage Lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedCostOptimizationMetrics(AdvancedCostOptimizationMetrics advancedCostOptimizationMetrics);

        /**
         * <p>
         * A container for bucket-level advanced cost-optimization metrics for S3 Storage Lens.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdvancedCostOptimizationMetrics.Builder}
         * avoiding the need to create one manually via {@link AdvancedCostOptimizationMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdvancedCostOptimizationMetrics.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #advancedCostOptimizationMetrics(AdvancedCostOptimizationMetrics)}.
         * 
         * @param advancedCostOptimizationMetrics
         *        a consumer that will call methods on {@link AdvancedCostOptimizationMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedCostOptimizationMetrics(AdvancedCostOptimizationMetrics)
         */
        default Builder advancedCostOptimizationMetrics(
                Consumer<AdvancedCostOptimizationMetrics.Builder> advancedCostOptimizationMetrics) {
            return advancedCostOptimizationMetrics(AdvancedCostOptimizationMetrics.builder()
                    .applyMutation(advancedCostOptimizationMetrics).build());
        }

        /**
         * <p>
         * A container for bucket-level advanced data-protection metrics for S3 Storage Lens.
         * </p>
         * 
         * @param advancedDataProtectionMetrics
         *        A container for bucket-level advanced data-protection metrics for S3 Storage Lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedDataProtectionMetrics(AdvancedDataProtectionMetrics advancedDataProtectionMetrics);

        /**
         * <p>
         * A container for bucket-level advanced data-protection metrics for S3 Storage Lens.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdvancedDataProtectionMetrics.Builder}
         * avoiding the need to create one manually via {@link AdvancedDataProtectionMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdvancedDataProtectionMetrics.Builder#build()} is called
         * immediately and its result is passed to {@link #advancedDataProtectionMetrics(AdvancedDataProtectionMetrics)}.
         * 
         * @param advancedDataProtectionMetrics
         *        a consumer that will call methods on {@link AdvancedDataProtectionMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedDataProtectionMetrics(AdvancedDataProtectionMetrics)
         */
        default Builder advancedDataProtectionMetrics(
                Consumer<AdvancedDataProtectionMetrics.Builder> advancedDataProtectionMetrics) {
            return advancedDataProtectionMetrics(AdvancedDataProtectionMetrics.builder()
                    .applyMutation(advancedDataProtectionMetrics).build());
        }

        /**
         * <p>
         * A container for bucket-level detailed status code metrics for S3 Storage Lens.
         * </p>
         * 
         * @param detailedStatusCodesMetrics
         *        A container for bucket-level detailed status code metrics for S3 Storage Lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailedStatusCodesMetrics(DetailedStatusCodesMetrics detailedStatusCodesMetrics);

        /**
         * <p>
         * A container for bucket-level detailed status code metrics for S3 Storage Lens.
         * </p>
         * This is a convenience method that creates an instance of the {@link DetailedStatusCodesMetrics.Builder}
         * avoiding the need to create one manually via {@link DetailedStatusCodesMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetailedStatusCodesMetrics.Builder#build()} is called immediately
         * and its result is passed to {@link #detailedStatusCodesMetrics(DetailedStatusCodesMetrics)}.
         * 
         * @param detailedStatusCodesMetrics
         *        a consumer that will call methods on {@link DetailedStatusCodesMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detailedStatusCodesMetrics(DetailedStatusCodesMetrics)
         */
        default Builder detailedStatusCodesMetrics(Consumer<DetailedStatusCodesMetrics.Builder> detailedStatusCodesMetrics) {
            return detailedStatusCodesMetrics(DetailedStatusCodesMetrics.builder().applyMutation(detailedStatusCodesMetrics)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ActivityMetrics activityMetrics;

        private PrefixLevel prefixLevel;

        private AdvancedCostOptimizationMetrics advancedCostOptimizationMetrics;

        private AdvancedDataProtectionMetrics advancedDataProtectionMetrics;

        private DetailedStatusCodesMetrics detailedStatusCodesMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketLevel model) {
            activityMetrics(model.activityMetrics);
            prefixLevel(model.prefixLevel);
            advancedCostOptimizationMetrics(model.advancedCostOptimizationMetrics);
            advancedDataProtectionMetrics(model.advancedDataProtectionMetrics);
            detailedStatusCodesMetrics(model.detailedStatusCodesMetrics);
        }

        public final ActivityMetrics.Builder getActivityMetrics() {
            return activityMetrics != null ? activityMetrics.toBuilder() : null;
        }

        public final void setActivityMetrics(ActivityMetrics.BuilderImpl activityMetrics) {
            this.activityMetrics = activityMetrics != null ? activityMetrics.build() : null;
        }

        @Override
        public final Builder activityMetrics(ActivityMetrics activityMetrics) {
            this.activityMetrics = activityMetrics;
            return this;
        }

        public final PrefixLevel.Builder getPrefixLevel() {
            return prefixLevel != null ? prefixLevel.toBuilder() : null;
        }

        public final void setPrefixLevel(PrefixLevel.BuilderImpl prefixLevel) {
            this.prefixLevel = prefixLevel != null ? prefixLevel.build() : null;
        }

        @Override
        public final Builder prefixLevel(PrefixLevel prefixLevel) {
            this.prefixLevel = prefixLevel;
            return this;
        }

        public final AdvancedCostOptimizationMetrics.Builder getAdvancedCostOptimizationMetrics() {
            return advancedCostOptimizationMetrics != null ? advancedCostOptimizationMetrics.toBuilder() : null;
        }

        public final void setAdvancedCostOptimizationMetrics(
                AdvancedCostOptimizationMetrics.BuilderImpl advancedCostOptimizationMetrics) {
            this.advancedCostOptimizationMetrics = advancedCostOptimizationMetrics != null ? advancedCostOptimizationMetrics
                    .build() : null;
        }

        @Override
        public final Builder advancedCostOptimizationMetrics(AdvancedCostOptimizationMetrics advancedCostOptimizationMetrics) {
            this.advancedCostOptimizationMetrics = advancedCostOptimizationMetrics;
            return this;
        }

        public final AdvancedDataProtectionMetrics.Builder getAdvancedDataProtectionMetrics() {
            return advancedDataProtectionMetrics != null ? advancedDataProtectionMetrics.toBuilder() : null;
        }

        public final void setAdvancedDataProtectionMetrics(AdvancedDataProtectionMetrics.BuilderImpl advancedDataProtectionMetrics) {
            this.advancedDataProtectionMetrics = advancedDataProtectionMetrics != null ? advancedDataProtectionMetrics.build()
                    : null;
        }

        @Override
        public final Builder advancedDataProtectionMetrics(AdvancedDataProtectionMetrics advancedDataProtectionMetrics) {
            this.advancedDataProtectionMetrics = advancedDataProtectionMetrics;
            return this;
        }

        public final DetailedStatusCodesMetrics.Builder getDetailedStatusCodesMetrics() {
            return detailedStatusCodesMetrics != null ? detailedStatusCodesMetrics.toBuilder() : null;
        }

        public final void setDetailedStatusCodesMetrics(DetailedStatusCodesMetrics.BuilderImpl detailedStatusCodesMetrics) {
            this.detailedStatusCodesMetrics = detailedStatusCodesMetrics != null ? detailedStatusCodesMetrics.build() : null;
        }

        @Override
        public final Builder detailedStatusCodesMetrics(DetailedStatusCodesMetrics detailedStatusCodesMetrics) {
            this.detailedStatusCodesMetrics = detailedStatusCodesMetrics;
            return this;
        }

        @Override
        public BucketLevel build() {
            return new BucketLevel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
