/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.model;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.transfer.s3.model.CompletedFileUpload;
import software.amazon.awssdk.transfer.s3.model.FileUpload;
import software.amazon.awssdk.transfer.s3.model.ResumableFileUpload;
import software.amazon.awssdk.transfer.s3.model.UploadFileRequest;
import software.amazon.awssdk.transfer.s3.progress.TransferProgress;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultFileUpload
implements FileUpload {
    private final CompletableFuture<CompletedFileUpload> completionFuture;
    private final TransferProgress progress;
    private final UploadFileRequest request;

    public DefaultFileUpload(CompletableFuture<CompletedFileUpload> completionFuture, TransferProgress progress, UploadFileRequest request) {
        this.completionFuture = (CompletableFuture)Validate.paramNotNull(completionFuture, (String)"completionFuture");
        this.progress = (TransferProgress)Validate.paramNotNull((Object)progress, (String)"progress");
        this.request = (UploadFileRequest)Validate.paramNotNull((Object)request, (String)"request");
    }

    @Override
    public ResumableFileUpload pause() {
        throw new UnsupportedOperationException("Pausing an upload is not supported in a non CRT-based S3 Client. For upload pause support, pass an AWS CRT-based S3 client to S3TransferManagerinstead: S3AsyncClient.crtBuilder().build();");
    }

    @Override
    public CompletableFuture<CompletedFileUpload> completionFuture() {
        return this.completionFuture;
    }

    @Override
    public TransferProgress progress() {
        return this.progress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultFileUpload that = (DefaultFileUpload)o;
        if (!this.completionFuture.equals(that.completionFuture)) {
            return false;
        }
        if (!this.progress.equals(that.progress)) {
            return false;
        }
        return this.request.equals(that.request);
    }

    public int hashCode() {
        int result = this.completionFuture.hashCode();
        result = 31 * result + this.progress.hashCode();
        result = 31 * result + this.request.hashCode();
        return result;
    }

    public String toString() {
        return ToString.builder((String)"DefaultFileUpload").add("completionFuture", this.completionFuture).add("progress", (Object)this.progress).add("request", (Object)this.request).build();
    }
}

